/*
 * Copyright 2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gradle.launcher.exec;

import org.gradle.api.logging.LogLevel;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.composite.CompositeBuildActionParameters;
import org.gradle.internal.composite.CompositeParameters;

import java.io.File;
import java.util.Map;

public class DefaultCompositeBuildActionParameters extends DefaultBuildActionParameters implements CompositeBuildActionParameters {
    private final CompositeParameters compositeParameters;

    public DefaultCompositeBuildActionParameters(Map<?, ?> systemProperties, Map<String, String> envVariables, File currentDir, LogLevel logLevel, boolean useDaemon, boolean continuous, boolean interactive, ClassPath injectedPluginClasspath, CompositeParameters compositeParameters) {
        super(systemProperties, envVariables, currentDir, logLevel, useDaemon, continuous, interactive, injectedPluginClasspath);
        this.compositeParameters = compositeParameters;
    }

    public CompositeParameters getCompositeParameters() {
        return compositeParameters;
    }

    @Override
    public String toString() {
        return "DefaultCompositeBuildActionParameters{"
            + "super=" + super.toString()
            + "compositeParameters=" + compositeParameters
            + '}';
    }
}
