/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.script;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.parsing.KotlinParserDefinition;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.script.KotlinConfigurableScriptDefinitionKt;
import org.jetbrains.kotlin.script.KotlinScriptConfig;
import org.jetbrains.kotlin.script.KotlinScriptDefinition;
import org.jetbrains.kotlin.script.KotlinScriptDefinitionKt;
import org.jetbrains.kotlin.script.KotlinScriptParameterConfig;
import org.jetbrains.kotlin.script.KotlinScriptSuperclassParameterConfig;
import org.jetbrains.kotlin.script.ScriptNameUtil;
import org.jetbrains.kotlin.script.ScriptParameter;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u001a\u0010\u0004\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0007\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0016\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0007\u0018\u00010\u0005H\u00c6\u0003J1\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u001c\b\u0002\u0010\u0004\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0007\u0018\u00010\u0005H\u00c6\u0001J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\u0007H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00072\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u00072\u0006\u0010\u001f\u001a\u00020 H\u0016J\"\u0010#\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\"0$0\u00072\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020)H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR%\u0010\u0004\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0007\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR \u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u00078BX\u0082\u0004\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0012\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/script/KotlinConfigurableScriptDefinition;", "Lorg/jetbrains/kotlin/script/KotlinScriptDefinition;", "config", "Lorg/jetbrains/kotlin/script/KotlinScriptConfig;", "environmentVars", "", "", "", "(Lorg/jetbrains/kotlin/script/KotlinScriptConfig;Ljava/util/Map;)V", "getConfig", "()Lorg/jetbrains/kotlin/script/KotlinScriptConfig;", "getEnvironmentVars", "()Ljava/util/Map;", "evaluatedClasspath", "getEvaluatedClasspath", "()Ljava/util/List;", "evaluatedClasspath$delegate", "Lkotlin/Lazy;", "name", "getName", "()Ljava/lang/String;", "component1", "component2", "copy", "getScriptDependenciesClasspath", "getScriptName", "Lorg/jetbrains/kotlin/name/Name;", "script", "Lorg/jetbrains/kotlin/psi/KtScript;", "getScriptParameters", "Lorg/jetbrains/kotlin/script/ScriptParameter;", "scriptDescriptor", "Lorg/jetbrains/kotlin/descriptors/ScriptDescriptor;", "getScriptSupertypes", "Lorg/jetbrains/kotlin/types/KotlinType;", "getSuperclassConstructorParametersToScriptParametersMap", "Lkotlin/Pair;", "isScript", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/psi/PsiFile;", "kotlin-compiler"})
public final class KotlinConfigurableScriptDefinition
implements KotlinScriptDefinition {
    @NotNull
    private final String name;
    private final Lazy<List<String>> evaluatedClasspath$delegate;
    @NotNull
    private final KotlinScriptConfig config;
    @Nullable
    private final Map<String, List<String>> environmentVars;
    private static final /* synthetic */ KProperty[] $$delegatedProperties;

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ScriptParameter> getScriptParameters(@NotNull ScriptDescriptor scriptDescriptor) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull(scriptDescriptor, "scriptDescriptor");
        Iterable $receiver$iv = this.config.getParameters();
        Iterable iterable = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            KotlinScriptParameterConfig kotlinScriptParameterConfig = (KotlinScriptParameterConfig)item$iv$iv;
            void var8_8 = destination$iv$iv;
            Name name = Name.identifier(it.getName());
            Intrinsics.checkExpressionValueIsNotNull(name, "Name.identifier(it.name)");
            ScriptParameter scriptParameter = new ScriptParameter(name, KotlinScriptDefinitionKt.getKotlinTypeByFqName(scriptDescriptor, it.getType()));
            var8_8.add(scriptParameter);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<KotlinType> getScriptSupertypes(@NotNull ScriptDescriptor scriptDescriptor) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull(scriptDescriptor, "scriptDescriptor");
        Iterable $receiver$iv = this.config.getSupertypes();
        Iterable iterable = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            void var8_8 = destination$iv$iv;
            KotlinType kotlinType = KotlinScriptDefinitionKt.getKotlinTypeByFqName(scriptDescriptor, (String)it);
            var8_8.add(kotlinType);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Pair<Name, KotlinType>> getSuperclassConstructorParametersToScriptParametersMap(@NotNull ScriptDescriptor scriptDescriptor) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull(scriptDescriptor, "scriptDescriptor");
        Iterable $receiver$iv = this.config.getSuperclassParamsMapping();
        Iterable iterable = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            KotlinScriptSuperclassParameterConfig kotlinScriptSuperclassParameterConfig = (KotlinScriptSuperclassParameterConfig)item$iv$iv;
            void var8_8 = destination$iv$iv;
            Pair<Name, KotlinType> pair = new Pair<Name, KotlinType>(Name.identifier(it.getScriptParamName()), KotlinScriptDefinitionKt.getKotlinTypeByFqName(scriptDescriptor, it.getSuperclassParamType()));
            var8_8.add(pair);
        }
        return (List)destination$iv$iv;
    }

    @Override
    public boolean isScript(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull(file, "file");
        Regex regex = new Regex(this.config.getFileNameMatch());
        CharSequence charSequence = file.getName();
        Intrinsics.checkExpressionValueIsNotNull(charSequence, "file.name");
        return regex.matches(charSequence);
    }

    @Override
    public boolean isScript(@NotNull PsiFile file) {
        Intrinsics.checkParameterIsNotNull(file, "file");
        Regex regex = new Regex(this.config.getFileNameMatch());
        CharSequence charSequence = file.getName();
        Intrinsics.checkExpressionValueIsNotNull(charSequence, "file.name");
        return regex.matches(charSequence);
    }

    @Override
    @NotNull
    public Name getScriptName(@NotNull KtScript script) {
        Intrinsics.checkParameterIsNotNull(script, "script");
        Name name = ScriptNameUtil.fileNameWithExtensionStripped(script, KotlinParserDefinition.STD_SCRIPT_EXT);
        Intrinsics.checkExpressionValueIsNotNull(name, "ScriptNameUtil.fileNameW\u2026efinition.STD_SCRIPT_EXT)");
        return name;
    }

    private final List<String> getEvaluatedClasspath() {
        Lazy<List<String>> lazy = this.evaluatedClasspath$delegate;
        KotlinConfigurableScriptDefinition kotlinConfigurableScriptDefinition = this;
        KProperty kProperty = $$delegatedProperties[0];
        return lazy.getValue();
    }

    @Override
    @NotNull
    public List<String> getScriptDependenciesClasspath() {
        return this.getEvaluatedClasspath();
    }

    @NotNull
    public final KotlinScriptConfig getConfig() {
        return this.config;
    }

    @Nullable
    public final Map<String, List<String>> getEnvironmentVars() {
        return this.environmentVars;
    }

    public KotlinConfigurableScriptDefinition(@NotNull KotlinScriptConfig config, @Nullable Map<String, ? extends List<String>> environmentVars) {
        Intrinsics.checkParameterIsNotNull(config, "config");
        this.config = config;
        this.environmentVars = environmentVars;
        this.name = this.config.getName();
        this.evaluatedClasspath$delegate = LazyKt.lazy((Function0)new Function0<List<? extends String>>(this){
            final /* synthetic */ KotlinConfigurableScriptDefinition this$0;

            @NotNull
            public final List<String> invoke() {
                return CollectionsKt.distinct((Iterable)KotlinConfigurableScriptDefinitionKt.evalWithVars(this.this$0.getConfig().getClasspath(), this.this$0.getEnvironmentVars()));
            }
            {
                this.this$0 = kotlinConfigurableScriptDefinition;
                super(0);
            }
        });
    }

    static {
        $$delegatedProperties = new KProperty[]{Reflection.property1(new PropertyReference1Impl(Reflection.getOrCreateKotlinClass(KotlinConfigurableScriptDefinition.class), "evaluatedClasspath", "getEvaluatedClasspath()Ljava/util/List;"))};
    }

    @NotNull
    public final KotlinScriptConfig component1() {
        return this.config;
    }

    @Nullable
    public final Map<String, List<String>> component2() {
        return this.environmentVars;
    }

    @NotNull
    public final KotlinConfigurableScriptDefinition copy(@NotNull KotlinScriptConfig config, @Nullable Map<String, ? extends List<String>> environmentVars) {
        Intrinsics.checkParameterIsNotNull(config, "config");
        return new KotlinConfigurableScriptDefinition(config, environmentVars);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ KotlinConfigurableScriptDefinition copy$default(KotlinConfigurableScriptDefinition kotlinConfigurableScriptDefinition, KotlinScriptConfig kotlinScriptConfig, Map map2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
        }
        if ((n & 1) != 0) {
            kotlinScriptConfig = kotlinConfigurableScriptDefinition.config;
        }
        if ((n & 2) != 0) {
            map2 = kotlinConfigurableScriptDefinition.environmentVars;
        }
        return kotlinConfigurableScriptDefinition.copy(kotlinScriptConfig, (Map<String, ? extends List<String>>)map2);
    }

    public String toString() {
        return "KotlinConfigurableScriptDefinition(config=" + this.config + ", environmentVars=" + this.environmentVars + ")";
    }

    public int hashCode() {
        KotlinScriptConfig kotlinScriptConfig = this.config;
        Map<String, List<String>> map2 = this.environmentVars;
        return (kotlinScriptConfig != null ? ((Object)kotlinScriptConfig).hashCode() : 0) * 31 + (map2 != null ? ((Object)map2).hashCode() : 0);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof KotlinConfigurableScriptDefinition)) break block3;
                KotlinConfigurableScriptDefinition kotlinConfigurableScriptDefinition = (KotlinConfigurableScriptDefinition)object;
                if (!Intrinsics.areEqual(this.config, kotlinConfigurableScriptDefinition.config) || !Intrinsics.areEqual(this.environmentVars, kotlinConfigurableScriptDefinition.environmentVars)) break block3;
            }
            return true;
        }
        return false;
    }
}

