/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.intrinsic.operation;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.BinaryOperationIntrinsic;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.BinaryOperationIntrinsicFactory;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.CompareToBOIF;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.EqualsBOIF;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.LongCompareToBOIF;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.NO_INTRINSIC;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.relocated.gnu.trove.THashMap;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\nH\u0002J\u0018\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\nH\u0002J\u0016\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\nH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0006\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u0012\u0004\u0012\u00020\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/BinaryOperationIntrinsics;", "", "()V", "factories", "", "Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/BinaryOperationIntrinsicFactory;", "intrinsicCache", "Lorg/jetbrains/kotlin/relocated/gnu/trove/THashMap;", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/lexer/KtToken;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/BinaryOperationIntrinsic;", "computeAndCacheIntrinsic", "token", "descriptor", "computeIntrinsic", "getIntrinsic", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "lookUpCache", "kotlin-compiler"})
public final class BinaryOperationIntrinsics {
    private final THashMap<Pair<KtToken, FunctionDescriptor>, BinaryOperationIntrinsic> intrinsicCache = new THashMap();
    private final List<BinaryOperationIntrinsicFactory> factories = CollectionsKt.listOf(new BinaryOperationIntrinsicFactory[]{LongCompareToBOIF.INSTANCE, EqualsBOIF.INSTANCE, CompareToBOIF.INSTANCE});

    @NotNull
    public final BinaryOperationIntrinsic getIntrinsic(@NotNull KtBinaryExpression expression, @NotNull TranslationContext context) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        KtToken token = PsiUtils.getOperationToken(expression);
        CallableDescriptor descriptor2 = BindingUtils.getCallableDescriptorForOperationExpression(context.bindingContext(), expression);
        if (descriptor2 == null || !(descriptor2 instanceof FunctionDescriptor)) {
            return NO_INTRINSIC.INSTANCE;
        }
        KtToken ktToken = token;
        Intrinsics.checkExpressionValueIsNotNull(ktToken, "token");
        BinaryOperationIntrinsic binaryOperationIntrinsic = this.lookUpCache(ktToken, (FunctionDescriptor)descriptor2);
        if (binaryOperationIntrinsic == null) {
            KtToken ktToken2 = token;
            Intrinsics.checkExpressionValueIsNotNull(ktToken2, "token");
            binaryOperationIntrinsic = this.computeAndCacheIntrinsic(ktToken2, (FunctionDescriptor)descriptor2);
        }
        return binaryOperationIntrinsic;
    }

    private final BinaryOperationIntrinsic lookUpCache(KtToken token, FunctionDescriptor descriptor2) {
        return this.intrinsicCache.get(new Pair<KtToken, FunctionDescriptor>(token, descriptor2));
    }

    private final BinaryOperationIntrinsic computeAndCacheIntrinsic(KtToken token, FunctionDescriptor descriptor2) {
        BinaryOperationIntrinsic result2 = this.computeIntrinsic(token, descriptor2);
        this.intrinsicCache.put(new Pair<KtToken, FunctionDescriptor>(token, descriptor2), result2);
        return result2;
    }

    private final BinaryOperationIntrinsic computeIntrinsic(KtToken token, FunctionDescriptor descriptor2) {
        for (BinaryOperationIntrinsicFactory factory : this.factories) {
            BinaryOperationIntrinsic intrinsic;
            if (!CollectionsKt.contains((Iterable)factory.getSupportTokens(), token) || (intrinsic = factory.getIntrinsic(descriptor2)) == null) continue;
            return intrinsic;
        }
        return NO_INTRINSIC.INSTANCE;
    }
}

