/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.patterns;

import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.relocated.com.google.common.base.Predicate;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Lists;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Sets;

public final class NamePredicate
implements Predicate<Name> {
    @NotNull
    public static final NamePredicate PRIMITIVE_NUMBERS = new NamePredicate(ContainerUtil.map(PrimitiveType.NUMBER_TYPES, new Function<PrimitiveType, String>(){

        @Override
        public String fun(PrimitiveType type2) {
            return type2.getTypeName().asString();
        }
    }));
    @NotNull
    public static final NamePredicate PRIMITIVE_NUMBERS_MAPPED_TO_PRIMITIVE_JS = new NamePredicate(ContainerUtil.mapNotNull(PrimitiveType.NUMBER_TYPES, new Function<PrimitiveType, String>(){

        @Override
        public String fun(PrimitiveType type2) {
            return type2 != PrimitiveType.LONG ? type2.getTypeName().asString() : null;
        }
    }));
    @NotNull
    public static final NamePredicate STRING = new NamePredicate("String");
    @NotNull
    public static final NamePredicate NUMBER = new NamePredicate("Number");
    @NotNull
    public static final NamePredicate BOOLEAN = new NamePredicate("Boolean");
    @NotNull
    public static final NamePredicate CHAR = new NamePredicate(PrimitiveType.CHAR.getTypeName());
    @NotNull
    public static final NamePredicate LONG = new NamePredicate(PrimitiveType.LONG.getTypeName());
    @NotNull
    private final Set<Name> validNames;

    public NamePredicate(String ... validNames) {
        if (validNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "validNames", "org/jetbrains/kotlin/js/patterns/NamePredicate", "<init>"));
        }
        this(Arrays.asList(validNames));
    }

    public NamePredicate(@NotNull List<String> validNames) {
        if (validNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "validNames", "org/jetbrains/kotlin/js/patterns/NamePredicate", "<init>"));
        }
        this.validNames = Sets.newHashSet();
        for (String validName : validNames) {
            this.validNames.add(Name.guessByFirstCharacter(validName));
        }
    }

    public NamePredicate(@NotNull Collection<Name> validNames) {
        if (validNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "validNames", "org/jetbrains/kotlin/js/patterns/NamePredicate", "<init>"));
        }
        this.validNames = Sets.newHashSet();
        this.validNames.addAll(validNames);
    }

    public NamePredicate(Name ... validNames) {
        if (validNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "validNames", "org/jetbrains/kotlin/js/patterns/NamePredicate", "<init>"));
        }
        this.validNames = Sets.newHashSet();
        this.validNames.addAll(Lists.newArrayList(validNames));
    }

    @Override
    public boolean apply(@Nullable Name name) {
        return name != null && this.validNames.contains(name);
    }
}

