/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.util;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.inline.util.FunctionUtilsKt;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.HasName;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsFunction;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsInvocation;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsNode;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.metadata.MetadataProperties;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0003\u001a\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0007\u001a\u00020\u0003\u001a\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0010"}, d2={"getCallerQualifier", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsExpression;", "invocation", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsInvocation;", "getCallerQualifierImpl", "getSimpleIdent", "", "call", "getSimpleName", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsName;", "getStaticRef", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsNode;", "hasCallerQualifier", "", "isCallInvocation", "isFunctionCreatorInvocation", "kotlin-compiler"})
public final class InvocationUtilsKt {
    @Nullable
    public static final JsName getSimpleName(@NotNull JsInvocation call) {
        Intrinsics.checkParameterIsNotNull(call, "call");
        JsExpression qualifier2 = call.getQualifier();
        JsExpression jsExpression = qualifier2;
        if (!(jsExpression instanceof JsNameRef)) {
            jsExpression = null;
        }
        JsNameRef jsNameRef = (JsNameRef)jsExpression;
        return jsNameRef != null ? jsNameRef.getName() : null;
    }

    @Nullable
    public static final String getSimpleIdent(@NotNull JsInvocation call) {
        Intrinsics.checkParameterIsNotNull(call, "call");
        JsExpression qualifier2 = call.getQualifier();
        while (qualifier2 != null) {
            JsExpression jsExpression = qualifier2;
            if (jsExpression instanceof JsInvocation) {
                JsExpression callableQualifier = qualifier2;
                qualifier2 = ((JsInvocation)callableQualifier).getQualifier();
                if (!InvocationUtilsKt.isCallInvocation((JsInvocation)callableQualifier)) continue;
                JsExpression jsExpression2 = qualifier2;
                if (!(jsExpression2 instanceof JsNameRef)) {
                    jsExpression2 = null;
                }
                JsNameRef jsNameRef = (JsNameRef)jsExpression2;
                qualifier2 = jsNameRef != null ? jsNameRef.getQualifier() : null;
                continue;
            }
            if (!(jsExpression instanceof HasName)) break;
            JsName jsName = ((HasName)((Object)qualifier2)).getName();
            return jsName != null ? jsName.getIdent() : null;
        }
        return null;
    }

    public static final boolean isFunctionCreatorInvocation(@NotNull JsInvocation invocation) {
        JsNode staticRef;
        Intrinsics.checkParameterIsNotNull(invocation, "invocation");
        JsNode jsNode = staticRef = InvocationUtilsKt.getStaticRef(invocation);
        return jsNode instanceof JsFunction ? FunctionUtilsKt.isFunctionCreator((JsFunction)staticRef) : false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isCallInvocation(@NotNull JsInvocation invocation) {
        Intrinsics.checkParameterIsNotNull(invocation, "invocation");
        JsExpression jsExpression = invocation.getQualifier();
        if (!(jsExpression instanceof JsNameRef)) {
            jsExpression = null;
        }
        JsNameRef qualifier2 = (JsNameRef)jsExpression;
        List<JsExpression> arguments2 = invocation.getArguments();
        JsNameRef jsNameRef = qualifier2;
        if (!Intrinsics.areEqual(jsNameRef != null ? jsNameRef.getIdent() : null, "call")) return false;
        Collection collection = arguments2;
        if (collection.isEmpty()) return false;
        return true;
    }

    public static final boolean hasCallerQualifier(@NotNull JsInvocation invocation) {
        Intrinsics.checkParameterIsNotNull(invocation, "invocation");
        return InvocationUtilsKt.getCallerQualifierImpl(invocation) != null;
    }

    @NotNull
    public static final JsExpression getCallerQualifier(@NotNull JsInvocation invocation) {
        Intrinsics.checkParameterIsNotNull(invocation, "invocation");
        JsExpression jsExpression = InvocationUtilsKt.getCallerQualifierImpl(invocation);
        if (jsExpression == null) {
            throw (Throwable)((Object)new AssertionError((Object)"must check hasQualifier() before calling getQualifier"));
        }
        return jsExpression;
    }

    private static final JsExpression getCallerQualifierImpl(JsInvocation invocation) {
        JsExpression jsExpression = invocation.getQualifier();
        if (!(jsExpression instanceof JsNameRef)) {
            jsExpression = null;
        }
        JsNameRef jsNameRef = (JsNameRef)jsExpression;
        return jsNameRef != null ? jsNameRef.getQualifier() : null;
    }

    private static final JsNode getStaticRef(JsInvocation invocation) {
        JsName qualifierName;
        JsExpression qualifier2 = invocation.getQualifier();
        JsExpression jsExpression = qualifier2;
        if (!(jsExpression instanceof HasName)) {
            jsExpression = null;
        }
        HasName hasName = (HasName)((Object)jsExpression);
        JsName jsName = qualifierName = hasName != null ? hasName.getName() : null;
        return jsName != null ? MetadataProperties.getStaticRef(jsName) : null;
    }
}

