/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon;

import com.intellij.core.JavaCoreApplicationEnvironment;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.impl.ZipHandler;
import com.intellij.openapi.vfs.impl.jar.CoreJarFileSystem;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TimeZone;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.PropertiesKt;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.daemon.CompileServiceImpl;
import org.jetbrains.kotlin.daemon.CompileServiceImpl$WhenMappings;
import org.jetbrains.kotlin.daemon.CompileServiceImpl$scheduleShutdown$1$$special$;
import org.jetbrains.kotlin.daemon.CompileServiceImplKt;
import org.jetbrains.kotlin.daemon.CompilerSelector;
import org.jetbrains.kotlin.daemon.EventManger;
import org.jetbrains.kotlin.daemon.EventMangerImpl;
import org.jetbrains.kotlin.daemon.KotlinCompileDaemonKt;
import org.jetbrains.kotlin.daemon.LazyClasspathWatcher;
import org.jetbrains.kotlin.daemon.RemoteCompilationCanceledStatusClient;
import org.jetbrains.kotlin.daemon.RemoteIncrementalCompilationComponentsClient;
import org.jetbrains.kotlin.daemon.RemoteOutputStreamClient;
import org.jetbrains.kotlin.daemon.common.ClientUtilsKt;
import org.jetbrains.kotlin.daemon.common.CompileService;
import org.jetbrains.kotlin.daemon.common.CompilerCallbackServicesFacade;
import org.jetbrains.kotlin.daemon.common.CompilerId;
import org.jetbrains.kotlin.daemon.common.DaemonJVMOptions;
import org.jetbrains.kotlin.daemon.common.DaemonJVMOptionsMemoryComparator;
import org.jetbrains.kotlin.daemon.common.DaemonOptions;
import org.jetbrains.kotlin.daemon.common.DaemonParamsKt;
import org.jetbrains.kotlin.daemon.common.DaemonReportCategory;
import org.jetbrains.kotlin.daemon.common.DummyProfiler;
import org.jetbrains.kotlin.daemon.common.LoopbackNetworkInterface;
import org.jetbrains.kotlin.daemon.common.PerfCounters;
import org.jetbrains.kotlin.daemon.common.Profiler;
import org.jetbrains.kotlin.daemon.common.RemoteOperationsTracer;
import org.jetbrains.kotlin.daemon.common.RemoteOutputStream;
import org.jetbrains.kotlin.daemon.common.WallAndThreadAndMemoryTotalProfiler;
import org.jetbrains.kotlin.daemon.common.WallAndThreadTotalProfiler;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCompilationComponents;
import org.jetbrains.kotlin.progress.CompilationCanceledStatus;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u00f7\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0001\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f*\u0001:\u0018\u00002\u00020\u0001:\u0004\u0086\u0001\u0087\u0001BK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\u0002\u0010\u0013J\u0018\u0010>\u001a\u00020\u00122\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020@H\u0002J\u0010\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020\u0007H\u0016JA\u0010E\u001a\u0002HF\"\u0004\b\u0000\u0010F2\u000e\u0010G\u001a\n\u0012\u0006\b\u0001\u0012\u00020@0H2\u0006\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020L2\f\u0010M\u001a\b\u0012\u0004\u0012\u0002HF0\u0011H\u0002\u00a2\u0006\u0002\u0010NJ\b\u0010O\u001a\u00020\u0012H\u0002J \u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020U2\u0006\u0010K\u001a\u00020LH\u0002Je\u0010V\u001a\b\u0012\u0004\u0012\u00020\r0W2\u0006\u0010X\u001a\u00020\r2\u000e\u0010G\u001a\n\u0012\u0006\b\u0001\u0012\u00020@0H2\u0006\u0010Y\u001a\u00020Z2\u0006\u0010[\u001a\u00020Z2\b\u0010\\\u001a\u0004\u0018\u00010]2\u001e\u0010M\u001a\u001a\u0012\u0004\u0012\u00020J\u0012\u0004\u0012\u00020U\u0012\u0004\u0012\u00020L\u0012\u0004\u0012\u00020_0^H\u0002\u00a2\u0006\u0002\u0010`J\u0014\u0010a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020@0b0WH\u0016J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000b0WH\u0016J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\t0WH\u0016J\u000e\u0010c\u001a\b\u0012\u0004\u0012\u00020\u00150WH\u0016J6\u0010d\u001a\b\u0012\u0004\u0012\u0002HF0W\"\u0004\b\u0000\u0010F2\b\b\u0002\u0010e\u001a\u00020f2\b\b\u0002\u0010g\u001a\u00020C2\f\u0010M\u001a\b\u0012\u0004\u0012\u0002HF0\u0011H\u0002J=\u0010h\u001a\b\u0012\u0004\u0012\u0002HF0W\"\u0004\b\u0000\u0010F2\b\b\u0002\u0010e\u001a\u00020f2\b\b\u0002\u0010g\u001a\u00020C2\u0012\u0010M\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002HF0W0\u0011H\u0082\bJ6\u0010i\u001a\b\u0012\u0004\u0012\u0002HF0W\"\u0004\b\u0000\u0010F2\b\b\u0002\u0010e\u001a\u00020f2\b\b\u0002\u0010g\u001a\u00020C2\f\u0010M\u001a\b\u0012\u0004\u0012\u0002HF0\u0011H\u0002J6\u0010j\u001a\b\u0012\u0004\u0012\u0002HF0W\"\u0004\b\u0000\u0010F2\b\b\u0002\u0010e\u001a\u00020f2\b\b\u0002\u0010g\u001a\u00020C2\f\u0010M\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J0\u0010k\u001a\b\u0012\u0004\u0012\u00020l0W2\b\b\u0002\u0010e\u001a\u00020f2\b\b\u0002\u0010g\u001a\u00020C2\f\u0010M\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\b\u0010m\u001a\u00020\u0012H\u0002J\u0018\u0010n\u001a\b\u0012\u0004\u0012\u00020\r0W2\b\u0010o\u001a\u0004\u0018\u00010@H\u0016J\b\u0010p\u001a\u00020\u0012H\u0002J\u0018\u0010q\u001a\b\u0012\u0004\u0012\u00020l0W2\b\u0010o\u001a\u0004\u0018\u00010@H\u0016J\u0016\u0010r\u001a\b\u0012\u0004\u0012\u00020l0W2\u0006\u0010X\u001a\u00020\rH\u0016J]\u0010s\u001a\b\u0012\u0004\u0012\u00020\r0W2\u0006\u0010X\u001a\u00020\r2\u0006\u0010t\u001a\u00020u2\u000e\u0010G\u001a\n\u0012\u0006\b\u0001\u0012\u00020@0H2\u0006\u0010v\u001a\u00020S2\u0006\u0010w\u001a\u00020Z2\u0006\u0010x\u001a\u00020y2\u0006\u0010z\u001a\u00020Z2\b\u0010\\\u001a\u0004\u0018\u00010]H\u0016\u00a2\u0006\u0002\u0010{J]\u0010|\u001a\b\u0012\u0004\u0012\u00020\r0W2\u0006\u0010X\u001a\u00020\r2\u0006\u0010t\u001a\u00020u2\u000e\u0010G\u001a\n\u0012\u0006\b\u0001\u0012\u00020@0H2\u0006\u0010v\u001a\u00020S2\u0006\u0010w\u001a\u00020Z2\u0006\u0010}\u001a\u00020y2\u0006\u0010z\u001a\u00020Z2\b\u0010\\\u001a\u0004\u0018\u00010]H\u0016\u00a2\u0006\u0002\u0010{J\u0016\u0010~\u001a\b\u0012\u0004\u0012\u00020C0W2\u0006\u0010\u007f\u001a\u00020CH\u0016J\u000f\u0010\u0080\u0001\u001a\b\u0012\u0004\u0012\u00020l0WH\u0016J\"\u0010\u0081\u0001\u001a\u00020C2\r\u0010\u0082\u0001\u001a\b\u0012\u0004\u0012\u00020C0\u00112\u0007\u0010\u0083\u0001\u001a\u00020@H\u0082\bJ\t\u0010\u0084\u0001\u001a\u00020\u0012H\u0002J\t\u0010\u0085\u0001\u001a\u00020\u0012H\u0002R\u0012\u0010\u0014\u001a\u00020\u00158\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010$\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\"\u0010'\u001a\n )*\u0004\u0018\u00010(0(8BX\u0082\u0004\u00a2\u0006\f\n\u0004\b,\u0010-\u001a\u0004\b*\u0010+R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u000e\u00104\u001a\u000205X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u000207X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00109\u001a\u00020:X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010;R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010=\u00a8\u0006\u0088\u0001"}, d2={"Lorg/jetbrains/kotlin/daemon/CompileServiceImpl;", "Lorg/jetbrains/kotlin/daemon/common/CompileService;", "registry", "Ljava/rmi/registry/Registry;", "compiler", "Lorg/jetbrains/kotlin/daemon/CompilerSelector;", "compilerId", "Lorg/jetbrains/kotlin/daemon/common/CompilerId;", "daemonOptions", "Lorg/jetbrains/kotlin/daemon/common/DaemonOptions;", "daemonJVMOptions", "Lorg/jetbrains/kotlin/daemon/common/DaemonJVMOptions;", "port", "", "timer", "Ljava/util/Timer;", "onShutdown", "Lkotlin/Function0;", "", "(Ljava/rmi/registry/Registry;Lorg/jetbrains/kotlin/daemon/CompilerSelector;Lorg/jetbrains/kotlin/daemon/common/CompilerId;Lorg/jetbrains/kotlin/daemon/common/DaemonOptions;Lorg/jetbrains/kotlin/daemon/common/DaemonJVMOptions;ILjava/util/Timer;Lkotlin/jvm/functions/Function0;)V", "_lastUsedSeconds", "", "classpathWatcher", "Lorg/jetbrains/kotlin/daemon/LazyClasspathWatcher;", "compilationsCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "getCompiler", "()Lorg/jetbrains/kotlin/daemon/CompilerSelector;", "getCompilerId", "()Lorg/jetbrains/kotlin/daemon/common/CompilerId;", "getDaemonJVMOptions", "()Lorg/jetbrains/kotlin/daemon/common/DaemonJVMOptions;", "getDaemonOptions", "()Lorg/jetbrains/kotlin/daemon/common/DaemonOptions;", "internalRng", "Ljava/util/Random;", "lastUsedSeconds", "getLastUsedSeconds", "()J", "log", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Ljava/util/logging/Logger;", "log$delegate", "Lkotlin/Lazy;", "getOnShutdown", "()Lkotlin/jvm/functions/Function0;", "getPort", "()I", "getRegistry", "()Ljava/rmi/registry/Registry;", "runFile", "Ljava/io/File;", "rwlock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "sessionsIdCounter", "state", "org/jetbrains/kotlin/daemon/CompileServiceImpl$state$1", "Lorg/jetbrains/kotlin/daemon/CompileServiceImpl$state$1;", "getTimer", "()Ljava/util/Timer;", "callVoidStaticMethod", "classFqName", "", "methodName", "checkCompilerId", "", "expectedCompilerId", "checkedCompile", "R", "args", "", "serviceOut", "Ljava/io/PrintStream;", "rpcProfiler", "Lorg/jetbrains/kotlin/daemon/common/Profiler;", "body", "([Ljava/lang/String;Ljava/io/PrintStream;Lorg/jetbrains/kotlin/daemon/common/Profiler;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "clearJarCache", "createCompileServices", "Lorg/jetbrains/kotlin/config/Services;", "facade", "Lorg/jetbrains/kotlin/daemon/common/CompilerCallbackServicesFacade;", "eventManger", "Lorg/jetbrains/kotlin/daemon/EventManger;", "doCompile", "Lorg/jetbrains/kotlin/daemon/common/CompileService$CallResult;", "sessionId", "compilerMessagesStreamProxy", "Lorg/jetbrains/kotlin/daemon/common/RemoteOutputStream;", "serviceOutputStreamProxy", "operationsTracer", "Lorg/jetbrains/kotlin/daemon/common/RemoteOperationsTracer;", "Lkotlin/Function3;", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "(I[Ljava/lang/String;Lorg/jetbrains/kotlin/daemon/common/RemoteOutputStream;Lorg/jetbrains/kotlin/daemon/common/RemoteOutputStream;Lorg/jetbrains/kotlin/daemon/common/RemoteOperationsTracer;Lkotlin/jvm/functions/Function3;)Lorg/jetbrains/kotlin/daemon/common/CompileService$CallResult;", "getClients", "", "getUsedMemory", "ifAlive", "minAliveness", "Lorg/jetbrains/kotlin/daemon/CompileServiceImpl$Aliveness;", "ignoreCompilerChanged", "ifAliveChecksImpl", "ifAliveExclusive", "ifAliveExclusive_Nothing", "ifAlive_Nothing", "", "initiateElections", "leaseCompileSession", "aliveFlagPath", "periodicAndAfterSessionCheck", "registerClient", "releaseCompileSession", "remoteCompile", "targetPlatform", "Lorg/jetbrains/kotlin/daemon/common/CompileService$TargetPlatform;", "servicesFacade", "compilerOutputStream", "outputFormat", "Lorg/jetbrains/kotlin/daemon/common/CompileService$OutputFormat;", "serviceOutputStream", "(ILorg/jetbrains/kotlin/daemon/common/CompileService$TargetPlatform;[Ljava/lang/String;Lorg/jetbrains/kotlin/daemon/common/CompilerCallbackServicesFacade;Lorg/jetbrains/kotlin/daemon/common/RemoteOutputStream;Lorg/jetbrains/kotlin/daemon/common/CompileService$OutputFormat;Lorg/jetbrains/kotlin/daemon/common/RemoteOutputStream;Lorg/jetbrains/kotlin/daemon/common/RemoteOperationsTracer;)Lorg/jetbrains/kotlin/daemon/common/CompileService$CallResult;", "remoteIncrementalCompile", "compilerOutputFormat", "scheduleShutdown", "graceful", "shutdown", "shutdownCondition", "check", "message", "shutdownImpl", "shutdownWithDelay", "Aliveness", "ClientOrSessionProxy", "kotlin-compiler"})
public final class CompileServiceImpl
implements CompileService {
    private final AtomicInteger sessionsIdCounter;
    private final AtomicInteger compilationsCounter;
    private final Random internalRng;
    private final LazyClasspathWatcher classpathWatcher;
    private final state.1 state;
    private volatile long _lastUsedSeconds;
    private final Lazy<Logger> log$delegate;
    private final ReentrantReadWriteLock rwlock;
    private File runFile;
    @NotNull
    private final Registry registry;
    @NotNull
    private final CompilerSelector compiler;
    @NotNull
    private final CompilerId compilerId;
    @NotNull
    private final DaemonOptions daemonOptions;
    @NotNull
    private final DaemonJVMOptions daemonJVMOptions;
    private final int port;
    @NotNull
    private final Timer timer;
    @NotNull
    private final Function0<Unit> onShutdown;
    private static final /* synthetic */ KProperty[] $$delegatedProperties;

    public final long getLastUsedSeconds() {
        return this.rwlock.isWriteLocked() || this.rwlock.getReadLockCount() - this.rwlock.getReadHoldCount() > 0 ? CompileServiceImplKt.nowSeconds() : this._lastUsedSeconds;
    }

    private final Logger getLog() {
        Lazy<Logger> lazy = this.log$delegate;
        CompileServiceImpl compileServiceImpl = this;
        KProperty kProperty = $$delegatedProperties[0];
        return lazy.getValue();
    }

    @Override
    @NotNull
    public CompileService.CallResult<DaemonOptions> getDaemonOptions() {
        return CompileServiceImpl.ifAlive$default(this, null, false, new Function0<DaemonOptions>(this){
            final /* synthetic */ CompileServiceImpl this$0;

            @NotNull
            public final DaemonOptions invoke() {
                return this.this$0.getDaemonOptions();
            }
            {
                this.this$0 = compileServiceImpl;
                super(0);
            }
        }, 3, null);
    }

    @Override
    @NotNull
    public CompileService.CallResult<DaemonJVMOptions> getDaemonJVMOptions() {
        return CompileServiceImpl.ifAlive$default(this, null, false, new Function0<DaemonJVMOptions>(this){
            final /* synthetic */ CompileServiceImpl this$0;

            @NotNull
            public final DaemonJVMOptions invoke() {
                return this.this$0.getDaemonJVMOptions();
            }
            {
                this.this$0 = compileServiceImpl;
                super(0);
            }
        }, 3, null);
    }

    @Override
    @NotNull
    public CompileService.CallResult registerClient(@Nullable String aliveFlagPath) {
        return CompileServiceImpl.ifAlive_Nothing$default(this, null, false, new Function0<Unit>(this, aliveFlagPath){
            final /* synthetic */ CompileServiceImpl this$0;
            final /* synthetic */ String $aliveFlagPath;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                Set<ClientOrSessionProxy> set = CompileServiceImpl.access$getState$p(this.this$0).getClientProxies();
                synchronized (set) {
                    boolean bl = CompileServiceImpl.access$getState$p(this.this$0).getClientProxies().add(new ClientOrSessionProxy(this.$aliveFlagPath));
                }
            }
            {
                this.this$0 = compileServiceImpl;
                this.$aliveFlagPath = string;
                super(0);
            }
        }, 3, null);
    }

    @Override
    @NotNull
    public CompileService.CallResult<List<String>> getClients() {
        return CompileServiceImpl.ifAlive$default(this, null, false, new Function0<List<? extends String>>(this){
            final /* synthetic */ CompileServiceImpl this$0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @NotNull
            public final List<String> invoke() {
                Iterable iterable;
                Set<ClientOrSessionProxy> set = CompileServiceImpl.access$getState$p(this.this$0).getClientProxies();
                synchronized (set) {
                    void destination$iv$iv;
                    void $receiver$iv$iv$iv;
                    void $receiver$iv$iv;
                    Iterable $receiver$iv = CompileServiceImpl.access$getState$p(this.this$0).getClientProxies();
                    iterable = $receiver$iv;
                    Collection collection = new ArrayList<E>();
                    void var5_6 = $receiver$iv$iv;
                    for (T element$iv$iv$iv : $receiver$iv$iv$iv) {
                        String string;
                        T element$iv$iv = element$iv$iv$iv;
                        ClientOrSessionProxy it = (ClientOrSessionProxy)element$iv$iv;
                        if (it.getAliveFlagPath() == null) continue;
                        String it$iv$iv = string;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    iterable = (List)destination$iv$iv;
                }
                return (List)iterable;
            }
            {
                this.this$0 = compileServiceImpl;
                super(0);
            }
        }, 3, null);
    }

    @Override
    @NotNull
    public CompileService.CallResult<Integer> leaseCompileSession(@Nullable String aliveFlagPath) {
        return CompileServiceImpl.ifAlive$default(this, Aliveness.Alive, false, new Function0<Integer>(this, aliveFlagPath){
            final /* synthetic */ CompileServiceImpl this$0;
            final /* synthetic */ String $aliveFlagPath;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final int invoke() {
                Ref.IntRef intRef = new Ref.IntRef();
                intRef.element = CompileServiceImpl.access$getSessionsIdCounter$p(this.this$0).incrementAndGet();
                ClientOrSessionProxy session = new ClientOrSessionProxy(this.$aliveFlagPath);
                int n = 1;
                int n2 = 100;
                if (n <= n2) {
                    while (true) {
                        void attempt;
                        void newId;
                        if (newId.element != CompileService.Companion.getNO_SESSION()) {
                            Map<Integer, ClientOrSessionProxy> map2 = CompileServiceImpl.access$getState$p(this.this$0).getSessions();
                            synchronized (map2) {
                                block7: {
                                    if (CompileServiceImpl.access$getState$p(this.this$0).getSessions().containsKey(newId.element)) break block7;
                                    CompileServiceImpl.access$getState$p(this.this$0).getSessions().put(newId.element, session);
                                    CompileServiceImpl.access$getLog$p(this.this$0).info("leased a new session " + newId.element + ", client alive file: " + this.$aliveFlagPath);
                                    int n3 = newId.element;
                                    return n3;
                                }
                                Unit unit = Unit.INSTANCE;
                            }
                        }
                        newId.element = CompileServiceImpl.access$getSessionsIdCounter$p(this.this$0).addAndGet(CompileServiceImpl.access$getInternalRng$p(this.this$0).nextInt());
                        if (attempt == n2) break;
                        ++attempt;
                    }
                }
                throw (Throwable)new IllegalStateException("Invalid state or algorithm error");
            }
            {
                this.this$0 = compileServiceImpl;
                this.$aliveFlagPath = string;
                super(0);
            }
        }, 2, null);
    }

    @Override
    @NotNull
    public CompileService.CallResult releaseCompileSession(int sessionId) {
        return CompileServiceImpl.ifAlive_Nothing$default(this, Aliveness.LastSession, false, new Function0<Unit>(this, sessionId){
            final /* synthetic */ CompileServiceImpl this$0;
            final /* synthetic */ int $sessionId;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                Object object = CompileServiceImpl.access$getState$p(this.this$0).getSessions();
                synchronized (object) {
                    CompileServiceImpl.access$getState$p(this.this$0).getSessions().remove(this.$sessionId);
                    CompileServiceImpl.access$getLog$p(this.this$0).info("cleaning after session " + this.$sessionId);
                    CompileServiceImpl.access$clearJarCache(this.this$0);
                    CompileServiceImpl.access$getState$p(this.this$0).getSessions().isEmpty();
                    Unit unit = Unit.INSTANCE;
                }
                object = this.this$0.getTimer();
                long l = 0L;
                TimerTask timerTask2 = new TimerTask(this){
                    final /* synthetic */ releaseCompileSession.1 this$0;

                    public void run() {
                        TimerTask $receiver = this;
                        CompileServiceImpl.access$periodicAndAfterSessionCheck(this.this$0.this$0);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                };
                ((Timer)object).schedule(timerTask2, l);
            }
            {
                this.this$0 = compileServiceImpl;
                this.$sessionId = n;
                super(0);
            }
        }, 2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean checkCompilerId(@NotNull CompilerId expectedCompilerId) {
        Intrinsics.checkParameterIsNotNull(expectedCompilerId, "expectedCompilerId");
        CharSequence charSequence = this.compilerId.getCompilerVersion();
        if (!(charSequence.length() == 0)) {
            if (!Intrinsics.areEqual(this.compilerId.getCompilerVersion(), expectedCompilerId.getCompilerVersion())) return false;
        }
        Iterable $receiver$iv = this.compilerId.getCompilerClasspath();
        for (Object element$iv : $receiver$iv) {
            String it = (String)element$iv;
            if (expectedCompilerId.getCompilerClasspath().contains(it)) continue;
            return false;
        }
        boolean bl = true;
        if (!bl) return false;
        if (this.classpathWatcher.isChanged()) return false;
        return true;
    }

    @Override
    @NotNull
    public CompileService.CallResult<Long> getUsedMemory() {
        return CompileServiceImpl.ifAlive$default(this, null, false, getUsedMemory.1.INSTANCE, 3, null);
    }

    @Override
    @NotNull
    public CompileService.CallResult shutdown() {
        return this.ifAliveExclusive_Nothing(Aliveness.LastSession, true, new Function0<Unit>(this){
            final /* synthetic */ CompileServiceImpl this$0;

            public final void invoke() {
                CompileServiceImpl.access$shutdownImpl(this.this$0);
            }
            {
                this.this$0 = compileServiceImpl;
                super(0);
            }
        });
    }

    @Override
    @NotNull
    public CompileService.CallResult<Boolean> scheduleShutdown(boolean graceful) {
        return CompileServiceImpl.ifAlive$default(this, Aliveness.Alive, false, new Function0<Boolean>(this, graceful){
            final /* synthetic */ CompileServiceImpl this$0;
            final /* synthetic */ boolean $graceful;

            public final boolean invoke() {
                boolean bl;
                if (!this.$graceful || CompileServiceImpl.access$getState$p(this.this$0).getAlive().compareAndSet(Aliveness.Alive.ordinal(), Aliveness.LastSession.ordinal())) {
                    Timer timer = this.this$0.getTimer();
                    long l = 0L;
                    TimerTask timerTask2 = new TimerTask(this){
                        final /* synthetic */ scheduleShutdown.1 this$0;

                        public void run() {
                            TimerTask $receiver = this;
                            CompileServiceImpl.access$ifAliveExclusive(this.this$0.this$0, Aliveness.LastSession, true, new Function0<Unit>(this){
                                final /* synthetic */ scheduleShutdown$1$$special$$inlined$schedule$1 this$0;

                                public final void invoke() {
                                    if (!this.this$0.this$0.$graceful || CompileServiceImpl.access$getState$p(this.this$0.this$0.this$0).getSessions().isEmpty()) {
                                        CompileServiceImpl.access$shutdownImpl(this.this$0.this$0.this$0);
                                    } else {
                                        CompileServiceImpl.access$getLog$p(this.this$0.this$0.this$0).info("Some sessions are active, waiting for them to finish");
                                    }
                                }
                                {
                                    this.this$0 = var1_1;
                                    super(0);
                                }
                            });
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    };
                    timer.schedule(timerTask2, l);
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }
            {
                this.this$0 = compileServiceImpl;
                this.$graceful = bl;
                super(0);
            }
        }, 2, null);
    }

    @Override
    @NotNull
    public CompileService.CallResult<Integer> remoteCompile(int sessionId, @NotNull CompileService.TargetPlatform targetPlatform, @NotNull String[] args, @NotNull CompilerCallbackServicesFacade servicesFacade, @NotNull RemoteOutputStream compilerOutputStream, @NotNull CompileService.OutputFormat outputFormat, @NotNull RemoteOutputStream serviceOutputStream, @Nullable RemoteOperationsTracer operationsTracer) {
        Intrinsics.checkParameterIsNotNull(targetPlatform, "targetPlatform");
        Intrinsics.checkParameterIsNotNull(args, "args");
        Intrinsics.checkParameterIsNotNull(servicesFacade, "servicesFacade");
        Intrinsics.checkParameterIsNotNull(compilerOutputStream, "compilerOutputStream");
        Intrinsics.checkParameterIsNotNull(outputFormat, "outputFormat");
        Intrinsics.checkParameterIsNotNull(serviceOutputStream, "serviceOutputStream");
        return this.doCompile(sessionId, args, compilerOutputStream, serviceOutputStream, operationsTracer, (Function3<? super PrintStream, ? super EventManger, ? super Profiler, ? extends ExitCode>)new Function3<PrintStream, EventManger, Profiler, ExitCode>(this, outputFormat, targetPlatform, args, servicesFacade){
            final /* synthetic */ CompileServiceImpl this$0;
            final /* synthetic */ CompileService.OutputFormat $outputFormat;
            final /* synthetic */ CompileService.TargetPlatform $targetPlatform;
            final /* synthetic */ String[] $args;
            final /* synthetic */ CompilerCallbackServicesFacade $servicesFacade;

            @NotNull
            public final ExitCode invoke(@NotNull PrintStream printStream, @NotNull EventManger eventManager, @NotNull Profiler profiler) {
                ExitCode exitCode;
                Intrinsics.checkParameterIsNotNull(printStream, "printStream");
                Intrinsics.checkParameterIsNotNull(eventManager, "eventManager");
                Intrinsics.checkParameterIsNotNull(profiler, "profiler");
                switch (CompileServiceImpl$WhenMappings.$EnumSwitchMapping$0[this.$outputFormat.ordinal()]) {
                    case 1: {
                        ExitCode exitCode2 = this.this$0.getCompiler().get(this.$targetPlatform).exec(printStream, Arrays.copyOf(this.$args, this.$args.length));
                        exitCode = exitCode2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)exitCode2), "compiler[targetPlatform].exec(printStream, *args)");
                        break;
                    }
                    case 2: {
                        ExitCode exitCode3 = this.this$0.getCompiler().get(this.$targetPlatform).execAndOutputXml(printStream, CompileServiceImpl.access$createCompileServices(this.this$0, this.$servicesFacade, eventManager, profiler), Arrays.copyOf(this.$args, this.$args.length));
                        exitCode = exitCode3;
                        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)exitCode3), "compiler[targetPlatform]\u2026anager, profiler), *args)");
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return exitCode;
            }
            {
                this.this$0 = compileServiceImpl;
                this.$outputFormat = outputFormat;
                this.$targetPlatform = targetPlatform;
                this.$args = stringArray;
                this.$servicesFacade = compilerCallbackServicesFacade;
                super(3);
            }
        });
    }

    @Override
    @NotNull
    public CompileService.CallResult<Integer> remoteIncrementalCompile(int sessionId, @NotNull CompileService.TargetPlatform targetPlatform, @NotNull String[] args, @NotNull CompilerCallbackServicesFacade servicesFacade, @NotNull RemoteOutputStream compilerOutputStream, @NotNull CompileService.OutputFormat compilerOutputFormat, @NotNull RemoteOutputStream serviceOutputStream, @Nullable RemoteOperationsTracer operationsTracer) {
        Intrinsics.checkParameterIsNotNull(targetPlatform, "targetPlatform");
        Intrinsics.checkParameterIsNotNull(args, "args");
        Intrinsics.checkParameterIsNotNull(servicesFacade, "servicesFacade");
        Intrinsics.checkParameterIsNotNull(compilerOutputStream, "compilerOutputStream");
        Intrinsics.checkParameterIsNotNull(compilerOutputFormat, "compilerOutputFormat");
        Intrinsics.checkParameterIsNotNull(serviceOutputStream, "serviceOutputStream");
        return this.doCompile(sessionId, args, compilerOutputStream, serviceOutputStream, operationsTracer, (Function3<? super PrintStream, ? super EventManger, ? super Profiler, ? extends ExitCode>)new Function3<PrintStream, EventManger, Profiler, ExitCode>(this, compilerOutputFormat, targetPlatform, servicesFacade, args){
            final /* synthetic */ CompileServiceImpl this$0;
            final /* synthetic */ CompileService.OutputFormat $compilerOutputFormat;
            final /* synthetic */ CompileService.TargetPlatform $targetPlatform;
            final /* synthetic */ CompilerCallbackServicesFacade $servicesFacade;
            final /* synthetic */ String[] $args;

            @NotNull
            public final ExitCode invoke(@NotNull PrintStream printStream, @NotNull EventManger eventManager, @NotNull Profiler profiler) {
                ExitCode exitCode;
                Intrinsics.checkParameterIsNotNull(printStream, "printStream");
                Intrinsics.checkParameterIsNotNull(eventManager, "eventManager");
                Intrinsics.checkParameterIsNotNull(profiler, "profiler");
                switch (CompileServiceImpl$WhenMappings.$EnumSwitchMapping$1[this.$compilerOutputFormat.ordinal()]) {
                    case 1: {
                        throw (Throwable)new NotImplementedError("Only XML output is supported in remote incremental compilation");
                    }
                    case 2: {
                        exitCode = this.this$0.getCompiler().get(this.$targetPlatform).execAndOutputXml(printStream, CompileServiceImpl.access$createCompileServices(this.this$0, this.$servicesFacade, eventManager, profiler), Arrays.copyOf(this.$args, this.$args.length));
                        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)exitCode), "compiler[targetPlatform]\u2026anager, profiler), *args)");
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return exitCode;
            }
            {
                this.this$0 = compileServiceImpl;
                this.$compilerOutputFormat = outputFormat;
                this.$targetPlatform = targetPlatform;
                this.$servicesFacade = compilerCallbackServicesFacade;
                this.$args = stringArray;
                super(3);
            }
        });
    }

    private final void periodicAndAfterSessionCheck() {
        CompileServiceImpl.ifAlive_Nothing$default(this, Aliveness.LastSession, false, new Function0<Unit>(this){
            final /* synthetic */ CompileServiceImpl this$0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void invoke() {
                block20: {
                    block21: {
                        void var3_8;
                        boolean res$iv;
                        boolean res$iv22;
                        Object result$iv;
                        Object $receiver$iv;
                        Object this_$iv;
                        Object message$iv;
                        block19: {
                            boolean res$iv3;
                            CompileServiceImpl compileServiceImpl = this.this$0;
                            message$iv = "Unused timeout exceeded " + this.this$0.getDaemonOptions().getAutoshutdownUnusedSeconds() + "s, shutting down";
                            boolean bl = res$iv3 = this.this$0.getDaemonOptions().getAutoshutdownUnusedSeconds() != DaemonParamsKt.getCOMPILE_DAEMON_TIMEOUT_INFINITE_S() && CompileServiceImpl.access$getCompilationsCounter$p(this.this$0).get() == 0 && CompileServiceImplKt.nowSeconds() - this.this$0.getLastUsedSeconds() > (long)this.this$0.getDaemonOptions().getAutoshutdownUnusedSeconds();
                            if (res$iv3) {
                                CompileServiceImpl.access$getLog$p((CompileServiceImpl)this_$iv).info((String)message$iv);
                            }
                            if (!res$iv3) break block19;
                            this.this$0.shutdown();
                            break block20;
                        }
                        this_$iv = CompileServiceImpl.access$getState$p(this.this$0).getSessions();
                        synchronized (this_$iv) {
                            $receiver$iv = CompileServiceImpl.access$getState$p(this.this$0).getSessions();
                            result$iv = new LinkedHashMap<K, V>();
                            Map<Integer, ClientOrSessionProxy> res$iv3 = $receiver$iv;
                            for (Map.Entry<Integer, ClientOrSessionProxy> entry$iv : res$iv3.entrySet()) {
                                ClientOrSessionProxy it = entry$iv.getValue();
                                if (!(!it.isAlive())) continue;
                                ((HashMap)result$iv).put(entry$iv.getKey(), entry$iv.getValue());
                            }
                            result$iv = CollectionsKt.toList((Iterable)((Map)result$iv).keySet());
                        }
                        Object $receiver$iv2 = (Iterable)result$iv;
                        $receiver$iv = $receiver$iv2.iterator();
                        while ($receiver$iv.hasNext()) {
                            E element$iv = $receiver$iv.next();
                            int it = ((Number)element$iv).intValue();
                            this.this$0.releaseCompileSession(it);
                        }
                        $receiver$iv2 = this.this$0;
                        message$iv = "All sessions finished, shutting down";
                        boolean bl = res$iv22 = CompileServiceImpl.access$getState$p(this.this$0).getAlive().get() == Aliveness.LastSession.ordinal() && MapsKt.none(CompileServiceImpl.access$getState$p(this.this$0).getSessions());
                        if (res$iv22) {
                            CompileServiceImpl.access$getLog$p(this_$iv).info((String)message$iv);
                        }
                        if (res$iv22) {
                            this.this$0.shutdown();
                        }
                        this_$iv = CompileServiceImpl.access$getState$p(this.this$0).getClientProxies();
                        synchronized (this_$iv) {
                            void destination$iv$iv;
                            void $receiver$iv$iv;
                            message$iv = CompileServiceImpl.access$getState$p(this.this$0).getClientProxies();
                            Set<ClientOrSessionProxy> $i$a$4$shutdownCondition22 = CompileServiceImpl.access$getState$p(this.this$0).getClientProxies();
                            Object res$iv22 = $receiver$iv;
                            Collection $i$f$shutdownCondition = new ArrayList<E>();
                            for (T element$iv$iv : $receiver$iv$iv) {
                                ClientOrSessionProxy it = (ClientOrSessionProxy)element$iv$iv;
                                if (!(!it.isAlive())) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            List list2 = (List)destination$iv$iv;
                            boolean $i$a$4$shutdownCondition22 = $i$a$4$shutdownCondition22.removeAll(list2);
                        }
                        if (CompileServiceImpl.access$getState$p(this.this$0).getClientProxies().isEmpty() && CompileServiceImpl.access$getCompilationsCounter$p(this.this$0).get() > 0 && !CompileServiceImpl.access$getState$p(this.this$0).getDelayedShutdownQueued().get()) {
                            CompileServiceImpl.access$getLog$p(this.this$0).info("No more clients left, delayed shutdown in " + this.this$0.getDaemonOptions().getShutdownDelayMilliseconds() + "ms");
                            CompileServiceImpl.access$shutdownWithDelay(this.this$0);
                        }
                        this_$iv = this.this$0;
                        message$iv = "Idle timeout exceeded " + this.this$0.getDaemonOptions().getAutoshutdownIdleSeconds() + "s, shutting down";
                        boolean bl2 = res$iv = this.this$0.getDaemonOptions().getAutoshutdownIdleSeconds() != DaemonParamsKt.getCOMPILE_DAEMON_TIMEOUT_INFINITE_S() && CompileServiceImplKt.nowSeconds() - this.this$0.getLastUsedSeconds() > (long)this.this$0.getDaemonOptions().getAutoshutdownIdleSeconds();
                        if (res$iv) {
                            CompileServiceImpl.access$getLog$p((CompileServiceImpl)this_$iv).info((String)message$iv);
                        }
                        if (res$iv) break block21;
                        this_$iv = this.this$0;
                        message$iv = "Run file removed, shutting down";
                        boolean bl3 = res$iv = !CompileServiceImpl.access$getRunFile$p(this.this$0).exists();
                        if (res$iv) {
                            CompileServiceImpl.access$getLog$p((CompileServiceImpl)this_$iv).info((String)message$iv);
                        }
                        if (res$iv) break block21;
                        this_$iv = this.this$0;
                        message$iv = "Compiler changed";
                        res$iv = CompileServiceImpl.access$getClasspathWatcher$p(this.this$0).isChanged();
                        if (res$iv) {
                            CompileServiceImpl.access$getLog$p((CompileServiceImpl)this_$iv).info((String)message$iv);
                        }
                        if (var3_8 == false) break block20;
                    }
                    this.this$0.shutdown();
                }
            }
            {
                this.this$0 = compileServiceImpl;
                super(0);
            }
        }, 2, null);
    }

    private final void initiateElections() {
        CompileServiceImpl.ifAlive_Nothing$default(this, null, false, new Function0<Unit>(this){
            final /* synthetic */ CompileServiceImpl this$0;

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                block5: {
                    DaemonJVMOptions fattestOpts;
                    Sequence<R> aliveWithOpts2;
                    block6: {
                        void $receiver$iv;
                        Comparator comparator = new DaemonJVMOptionsMemoryComparator();
                        Sequence<R> sequence2 = SequencesKt.filter(SequencesKt.map(ClientUtilsKt.walkDaemons(new File(DaemonParamsKt.getRunFilesPathOrDefault(this.this$0.getDaemonOptions())), this.this$0.getCompilerId(), (Function2<? super File, ? super Integer, Boolean>)new Function2<File, Integer, Boolean>(this){
                            final /* synthetic */ initiateElections.1 this$0;

                            public final boolean invoke(@NotNull File f, int p) {
                                Intrinsics.checkParameterIsNotNull(f, "f");
                                return p != this.this$0.this$0.getPort();
                            }
                            {
                                this.this$0 = var1_1;
                                super(2);
                            }
                        }, (Function2<? super DaemonReportCategory, ? super String, Unit>)new Function2<DaemonReportCategory, String, Unit>(this){
                            final /* synthetic */ initiateElections.1 this$0;

                            public final void invoke(@NotNull DaemonReportCategory lvl, @NotNull String msg2) {
                                Intrinsics.checkParameterIsNotNull((Object)((Object)lvl), "lvl");
                                Intrinsics.checkParameterIsNotNull(msg2, "msg");
                                CompileServiceImpl.access$getLog$p(this.this$0.this$0).info(msg2);
                            }
                            {
                                this.this$0 = var1_1;
                                super(2);
                            }
                        }), initiateElections.aliveWithOpts.3.INSTANCE), initiateElections.aliveWithOpts.4.INSTANCE);
                        Comparator comparator2 = new Comparator<Pair<? extends CompileService, ? extends CompileService.CallResult<? extends DaemonJVMOptions>>>(comparator){
                            final /* synthetic */ Comparator $comparator;

                            /*
                             * Ignored method signature, as it can't be verified against descriptor
                             */
                            public int compare(Object a, Object b) {
                                Pair it;
                                Comparator comparator = this.$comparator;
                                Pair pair = (Pair)b;
                                Comparator comparator2 = comparator;
                                DaemonJVMOptions daemonJVMOptions = (DaemonJVMOptions)((CompileService.CallResult)it.getSecond()).get();
                                it = (Pair)a;
                                DaemonJVMOptions daemonJVMOptions2 = (DaemonJVMOptions)((CompileService.CallResult)it.getSecond()).get();
                                return comparator2.compare(daemonJVMOptions, daemonJVMOptions2);
                            }
                            {
                                this.$comparator = $captured_local_variable$0;
                            }
                        };
                        aliveWithOpts2 = SequencesKt.sortedWith(sequence2, comparator2);
                        if (!SequencesKt.any(aliveWithOpts2)) break block5;
                        fattestOpts = (DaemonJVMOptions)((CompileService.CallResult)((Pair)SequencesKt.first(aliveWithOpts2)).getSecond()).get();
                        if (!DaemonParamsKt.memorywiseFitsInto(fattestOpts, this.this$0.getDaemonJVMOptions()) || DaemonParamsKt.memorywiseFitsInto(this.this$0.getDaemonJVMOptions(), fattestOpts)) break block6;
                        Sequence<R> sequence3 = aliveWithOpts2;
                        for (T element$iv : $receiver$iv) {
                            Pair it = (Pair)element$iv;
                            if (AddToStdlibKt.check(((CompileService)it.getFirst()).getClients(), initiateElections.1.1.INSTANCE) != null) {
                                void $receiver$iv2;
                                CompileService.CallResult<List<String>> callResult;
                                CompileService.CallResult<List<String>> it2 = callResult;
                                Iterable iterable = it2.get();
                                for (T element$iv2 : $receiver$iv2) {
                                    String it3 = (String)element$iv2;
                                    this.this$0.registerClient(it3);
                                }
                            }
                            ((CompileService)it.getFirst()).scheduleShutdown(true);
                        }
                        break block5;
                    }
                    if (!DaemonParamsKt.memorywiseFitsInto(this.this$0.getDaemonJVMOptions(), fattestOpts)) break block5;
                    this.this$0.scheduleShutdown(true);
                    A a = ((Pair)SequencesKt.first(aliveWithOpts2)).getFirst();
                    CompileService fattest = (CompileService)a;
                    CompileService.CallResult<List<String>> callResult = AddToStdlibKt.check(this.this$0.getClients(), initiateElections.2.1.INSTANCE);
                    if (callResult != null) {
                        void $receiver$iv;
                        CompileService.CallResult<List<String>> callResult2 = callResult;
                        CompileService.CallResult<List<String>> it = callResult2;
                        Iterable iterable = it.get();
                        for (T element$iv : $receiver$iv) {
                            String it4 = (String)element$iv;
                            fattest.registerClient(it4);
                        }
                    }
                }
            }
            {
                this.this$0 = compileServiceImpl;
                super(0);
            }
        }, 3, null);
    }

    private final void shutdownImpl() {
        this.getLog().info("Shutdown started");
        this.state.getAlive().set(Aliveness.Dying.ordinal());
        UnicastRemoteObject.unexportObject(this, true);
        this.getLog().info("Shutdown complete");
        this.onShutdown.invoke();
    }

    private final void shutdownWithDelay() {
        this.state.getDelayedShutdownQueued().set(true);
        int currentCompilationsCount = this.compilationsCounter.get();
        Timer timer = this.timer;
        long l = this.daemonOptions.getShutdownDelayMilliseconds();
        TimerTask timerTask2 = new TimerTask(this, currentCompilationsCount){
            final /* synthetic */ CompileServiceImpl this$0;
            final /* synthetic */ int $currentCompilationsCount$inlined;

            public void run() {
                TimerTask $receiver = this;
                CompileServiceImpl.access$getState$p(this.this$0).getDelayedShutdownQueued().set(false);
                if (this.$currentCompilationsCount$inlined == CompileServiceImpl.access$getCompilationsCounter$p(this.this$0).get()) {
                    CompileServiceImpl.access$getLog$p(this.this$0).fine("Execute delayed shutdown");
                    this.this$0.shutdown();
                } else {
                    CompileServiceImpl.access$getLog$p(this.this$0).info("Cancel delayed shutdown due to new client");
                }
            }
            {
                this.this$0 = compileServiceImpl;
                this.$currentCompilationsCount$inlined = n;
            }
        };
        timer.schedule(timerTask2, l);
    }

    private final boolean shutdownCondition(Function0<Boolean> check, String message) {
        boolean res = check.invoke();
        if (res) {
            this.getLog().info(message);
        }
        return res;
    }

    private final CompileService.CallResult<Integer> doCompile(int sessionId, String[] args, RemoteOutputStream compilerMessagesStreamProxy, RemoteOutputStream serviceOutputStreamProxy, RemoteOperationsTracer operationsTracer, Function3<? super PrintStream, ? super EventManger, ? super Profiler, ? extends ExitCode> body) {
        return CompileServiceImpl.ifAlive$default(this, null, false, new Function0<Integer>(this, operationsTracer, compilerMessagesStreamProxy, serviceOutputStreamProxy, args, body){
            final /* synthetic */ CompileServiceImpl this$0;
            final /* synthetic */ RemoteOperationsTracer $operationsTracer;
            final /* synthetic */ RemoteOutputStream $compilerMessagesStreamProxy;
            final /* synthetic */ RemoteOutputStream $serviceOutputStreamProxy;
            final /* synthetic */ String[] $args;
            final /* synthetic */ Function3 $body;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final int invoke() {
                int n;
                RemoteOperationsTracer remoteOperationsTracer = this.$operationsTracer;
                if (remoteOperationsTracer != null) {
                    remoteOperationsTracer.before("compile");
                }
                CompileServiceImpl.access$getCompilationsCounter$p(this.this$0).incrementAndGet();
                Profiler rpcProfiler = this.this$0.getDaemonOptions().getReportPerf() ? (Profiler)new WallAndThreadTotalProfiler() : (Profiler)new DummyProfiler();
                EventMangerImpl eventManger = new EventMangerImpl();
                PrintStream compilerMessagesStream = new PrintStream(new BufferedOutputStream(new RemoteOutputStreamClient(this.$compilerMessagesStreamProxy, rpcProfiler), 4096));
                PrintStream serviceOutputStream = new PrintStream(new BufferedOutputStream(new RemoteOutputStreamClient(this.$serviceOutputStreamProxy, rpcProfiler), 4096));
                try {
                    n = ((Number)CompileServiceImpl.access$checkedCompile(this.this$0, this.$args, serviceOutputStream, rpcProfiler, new Function0<Integer>(this, compilerMessagesStream, eventManger, rpcProfiler){
                        final /* synthetic */ doCompile.1 this$0;
                        final /* synthetic */ PrintStream $compilerMessagesStream;
                        final /* synthetic */ EventMangerImpl $eventManger;
                        final /* synthetic */ Profiler $rpcProfiler;

                        /*
                         * WARNING - void declaration
                         */
                        public final int invoke() {
                            void var1_1;
                            int res = ((ExitCode)((Object)this.this$0.$body.invoke(this.$compilerMessagesStream, this.$eventManger, this.$rpcProfiler))).getCode();
                            CompileServiceImpl.access$set_lastUsedSeconds$p(this.this$0.this$0, CompileServiceImplKt.nowSeconds());
                            return (int)var1_1;
                        }
                        {
                            this.this$0 = var1_1;
                            this.$compilerMessagesStream = printStream;
                            this.$eventManger = eventMangerImpl;
                            this.$rpcProfiler = profiler;
                            super(0);
                        }
                    })).intValue();
                }
                finally {
                    serviceOutputStream.flush();
                    compilerMessagesStream.flush();
                    eventManger.fireCompilationFinished();
                    RemoteOperationsTracer remoteOperationsTracer2 = this.$operationsTracer;
                    if (remoteOperationsTracer2 != null) {
                        remoteOperationsTracer2.after("compile");
                    }
                }
                return n;
            }
            {
                this.this$0 = compileServiceImpl;
                this.$operationsTracer = remoteOperationsTracer;
                this.$compilerMessagesStreamProxy = remoteOutputStream;
                this.$serviceOutputStreamProxy = remoteOutputStream2;
                this.$args = stringArray;
                this.$body = function3;
                super(0);
            }
        }, 3, null);
    }

    private final Services createCompileServices(CompilerCallbackServicesFacade facade, EventManger eventManger, Profiler rpcProfiler) {
        Services.Builder builder = new Services.Builder();
        if (facade.hasIncrementalCaches() || facade.hasLookupTracker()) {
            builder.register(IncrementalCompilationComponents.class, new RemoteIncrementalCompilationComponentsClient(facade, eventManger, rpcProfiler));
        }
        if (facade.hasCompilationCanceledStatus()) {
            builder.register(CompilationCanceledStatus.class, new RemoteCompilationCanceledStatusClient(facade, rpcProfiler));
        }
        return builder.build();
    }

    /*
     * WARNING - void declaration
     */
    private final <R> R checkedCompile(String[] args, PrintStream serviceOut, Profiler rpcProfiler, Function0<? extends R> body) {
        try {
            long l;
            if (ArraysKt.none((Object[])args)) {
                throw (Throwable)new IllegalArgumentException("Error: empty arguments list.");
            }
            this.getLog().info("Starting compilation with args: " + ArraysKt.joinToString$default(args, (CharSequence)" ", null, null, 0, null, null, 62, null));
            Profiler profiler = this.daemonOptions.getReportPerf() ? (Profiler)new WallAndThreadAndMemoryTotalProfiler(false) : (Profiler)new DummyProfiler();
            R res = profiler.withMeasure(null, body);
            if (this.daemonOptions.getReportPerf()) {
                void withGC$iv;
                boolean bl = false;
                if (withGC$iv != false) {
                    System.gc();
                }
                Runtime rt$iv = Runtime.getRuntime();
                l = rt$iv.totalMemory() - rt$iv.freeMemory();
            } else {
                l = 0L;
            }
            long endMem = l;
            this.getLog().info("Done with result " + String.valueOf(res));
            if (this.daemonOptions.getReportPerf()) {
                checkedCompile.1 ms$ = checkedCompile.1.INSTANCE;
                checkedCompile.2 kb$ = checkedCompile.2.INSTANCE;
                PerfCounters pc = profiler.getTotalCounters();
                PerfCounters rpc = rpcProfiler.getTotalCounters();
                Object object = "%+d";
                Object object2 = new Object[]{kb$.invoke(pc.getMemory())};
                StringBuilder stringBuilder = new StringBuilder().append("PERF: Compile on daemon: ").append(ms$.invoke(pc.getTime())).append(" ms; thread: user ").append(ms$.invoke(pc.getThreadUserTime())).append(" ms, sys ").append(ms$.invoke(pc.getThreadTime() - pc.getThreadUserTime())).append(" ms; rpc: ").append(rpc.getCount()).append(" calls, ").append(ms$.invoke(rpc.getTime())).append(" ms, thread ").append(ms$.invoke(rpc.getThreadTime())).append(" ms; memory: ").append(kb$.invoke(endMem)).append(" kb (");
                String string = String.format((String)object, Arrays.copyOf(object2, ((Object[])object2).length));
                Intrinsics.checkExpressionValueIsNotNull(string, "java.lang.String.format(this, *args)");
                String string2 = string;
                object = stringBuilder.append(string2).append(" kb)").toString();
                String it = object;
                serviceOut.println(it);
                this.getLog().info(it);
                Map<Object, PerfCounters> $i$a$3$let = rpcProfiler.getCounters();
                object2 = $i$a$3$let.entrySet().iterator();
                while (object2.hasNext()) {
                    Object object3 = object = (Map.Entry)object2.next();
                    Object obj = object3.getKey();
                    Object object4 = object;
                    PerfCounters counters = (PerfCounters)object4.getValue();
                    object4 = "PERF: rpc by " + obj + ": " + counters.getCount() + " calls, " + ms$.invoke(counters.getTime()) + " ms, thread " + ms$.invoke(counters.getThreadTime()) + " ms";
                    String it2 = (String)object4;
                    serviceOut.println(it2);
                    this.getLog().info(it2);
                }
            }
            return res;
        }
        catch (Exception e) {
            this.getLog().info("Error: " + e);
            throw (Throwable)e;
        }
    }

    private final void clearJarCache() {
        block1: {
            ZipHandler.clearFileAccessorCache();
            JavaCoreApplicationEnvironment javaCoreApplicationEnvironment = KotlinCoreEnvironment.Companion.getApplicationEnvironment();
            VirtualFileSystem virtualFileSystem = javaCoreApplicationEnvironment != null ? javaCoreApplicationEnvironment.getJarFileSystem() : null;
            if (!(virtualFileSystem instanceof CoreJarFileSystem)) {
                virtualFileSystem = null;
            }
            CoreJarFileSystem coreJarFileSystem = (CoreJarFileSystem)virtualFileSystem;
            if (coreJarFileSystem == null) break block1;
            coreJarFileSystem.clearHandlersCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final <R> CompileService.CallResult<R> ifAlive(Aliveness minAliveness, boolean ignoreCompilerChanged, Function0<? extends R> body) {
        Object object;
        ReentrantReadWriteLock reentrantReadWriteLock = this.rwlock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            Object object2;
            void ignoreCompilerChanged$iv;
            Object object3;
            void minAliveness$iv;
            void this_$iv;
            object = this;
            Aliveness aliveness = minAliveness;
            boolean bl = ignoreCompilerChanged;
            if (((CompileServiceImpl)this_$iv).state.getAlive().get() < minAliveness$iv.ordinal()) {
                object3 = new CompileService.CallResult.Dying();
            } else if (ignoreCompilerChanged$iv == false && ((CompileServiceImpl)this_$iv).classpathWatcher.isChanged()) {
                ((CompileServiceImpl)this_$iv).getLog().info("Compiler changed, scheduling shutdown");
                object2 = this_$iv.getTimer();
                long l = 0L;
                TimerTask timerTask2 = new TimerTask((CompileServiceImpl)this_$iv){
                    final /* synthetic */ CompileServiceImpl this$0;

                    public void run() {
                        TimerTask $receiver = this;
                        this.this$0.shutdown();
                    }
                    {
                        this.this$0 = compileServiceImpl;
                    }
                };
                ((Timer)object2).schedule(timerTask2, l);
                object3 = new CompileService.CallResult.Dying();
            } else {
                try {
                    object2 = new CompileService.CallResult.Good<R>(body.invoke());
                }
                catch (Exception e$iv) {
                    ((CompileServiceImpl)this_$iv).getLog().log(Level.SEVERE, "Exception", e$iv);
                    String string = e$iv.getMessage();
                    if (string == null) {
                        string = "unknown";
                    }
                    object2 = new CompileService.CallResult.Error(string);
                }
                object3 = object2;
            }
            object = object3;
        }
        finally {
            readLock.unlock();
        }
        return (CompileService.CallResult)object;
    }

    static /* bridge */ /* synthetic */ CompileService.CallResult ifAlive$default(CompileServiceImpl compileServiceImpl, Aliveness aliveness, boolean bl, Function0 function0, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: ifAlive");
        }
        if ((n & 1) != 0) {
            aliveness = Aliveness.Alive;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return compileServiceImpl.ifAlive(aliveness, bl, function0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final CompileService.CallResult ifAlive_Nothing(Aliveness minAliveness, boolean ignoreCompilerChanged, Function0<Unit> body) {
        Object object;
        ReentrantReadWriteLock reentrantReadWriteLock = this.rwlock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            Object object2;
            void ignoreCompilerChanged$iv;
            Object object3;
            void minAliveness$iv;
            void this_$iv;
            object = this;
            Aliveness aliveness = minAliveness;
            boolean bl = ignoreCompilerChanged;
            if (((CompileServiceImpl)this_$iv).state.getAlive().get() < minAliveness$iv.ordinal()) {
                object3 = new CompileService.CallResult.Dying();
            } else if (ignoreCompilerChanged$iv == false && ((CompileServiceImpl)this_$iv).classpathWatcher.isChanged()) {
                ((CompileServiceImpl)this_$iv).getLog().info("Compiler changed, scheduling shutdown");
                object2 = this_$iv.getTimer();
                long l = 0L;
                TimerTask timerTask2 = new TimerTask((CompileServiceImpl)this_$iv){
                    final /* synthetic */ CompileServiceImpl this$0;

                    public void run() {
                        TimerTask $receiver = this;
                        this.this$0.shutdown();
                    }
                    {
                        this.this$0 = compileServiceImpl;
                    }
                };
                ((Timer)object2).schedule(timerTask2, l);
                object3 = new CompileService.CallResult.Dying();
            } else {
                try {
                    body.invoke();
                    object2 = new CompileService.CallResult.Ok();
                }
                catch (Exception e$iv) {
                    ((CompileServiceImpl)this_$iv).getLog().log(Level.SEVERE, "Exception", e$iv);
                    String string = e$iv.getMessage();
                    if (string == null) {
                        string = "unknown";
                    }
                    object2 = new CompileService.CallResult.Error(string);
                }
                object3 = object2;
            }
            object = object3;
        }
        finally {
            readLock.unlock();
        }
        return (CompileService.CallResult)object;
    }

    static /* bridge */ /* synthetic */ CompileService.CallResult ifAlive_Nothing$default(CompileServiceImpl compileServiceImpl, Aliveness aliveness, boolean bl, Function0 function0, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: ifAlive_Nothing");
        }
        if ((n & 1) != 0) {
            aliveness = Aliveness.Alive;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return compileServiceImpl.ifAlive_Nothing(aliveness, bl, function0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final <R> CompileService.CallResult<R> ifAliveExclusive(Aliveness minAliveness, boolean ignoreCompilerChanged, Function0<? extends R> body) {
        CompileService.CallResult callResult;
        int n;
        ReentrantReadWriteLock reentrantReadWriteLock = this.rwlock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n2 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        int n3 = 0;
        int n4 = n2 - 1;
        if (n3 <= n4) {
            do {
                n = ++n3;
                readLock.unlock();
            } while (n3 != n4);
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            Object object;
            void ignoreCompilerChanged$iv;
            Object object2;
            void minAliveness$iv;
            void this_$iv;
            CompileServiceImpl compileServiceImpl = this;
            Aliveness aliveness = minAliveness;
            boolean bl = ignoreCompilerChanged;
            if (((CompileServiceImpl)this_$iv).state.getAlive().get() < minAliveness$iv.ordinal()) {
                object2 = new CompileService.CallResult.Dying();
            } else if (ignoreCompilerChanged$iv == false && ((CompileServiceImpl)this_$iv).classpathWatcher.isChanged()) {
                ((CompileServiceImpl)this_$iv).getLog().info("Compiler changed, scheduling shutdown");
                object = this_$iv.getTimer();
                long l = 0L;
                TimerTask timerTask2 = new TimerTask((CompileServiceImpl)this_$iv){
                    final /* synthetic */ CompileServiceImpl this$0;

                    public void run() {
                        TimerTask $receiver = this;
                        this.this$0.shutdown();
                    }
                    {
                        this.this$0 = compileServiceImpl;
                    }
                };
                ((Timer)object).schedule(timerTask2, l);
                object2 = new CompileService.CallResult.Dying();
            } else {
                try {
                    object = new CompileService.CallResult.Good<R>(body.invoke());
                }
                catch (Exception e$iv) {
                    ((CompileServiceImpl)this_$iv).getLog().log(Level.SEVERE, "Exception", e$iv);
                    String string = e$iv.getMessage();
                    if (string == null) {
                        string = "unknown";
                    }
                    object = new CompileService.CallResult.Error(string);
                }
                object2 = object;
            }
            callResult = object2;
        }
        finally {
            n = 0;
            int n5 = n2 - 1;
            if (n <= n5) {
                do {
                    int n6 = ++n;
                    readLock.lock();
                } while (n != n5);
            }
            writeLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final <R> CompileService.CallResult<R> ifAliveExclusive_Nothing(Aliveness minAliveness, boolean ignoreCompilerChanged, Function0<Unit> body) {
        CompileService.CallResult callResult;
        int n;
        ReentrantReadWriteLock reentrantReadWriteLock = this.rwlock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n2 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        int n3 = 0;
        int n4 = n2 - 1;
        if (n3 <= n4) {
            do {
                n = ++n3;
                readLock.unlock();
            } while (n3 != n4);
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            Object object;
            void ignoreCompilerChanged$iv;
            Object object2;
            void minAliveness$iv;
            void this_$iv;
            CompileServiceImpl compileServiceImpl = this;
            Aliveness aliveness = minAliveness;
            boolean bl = ignoreCompilerChanged;
            if (((CompileServiceImpl)this_$iv).state.getAlive().get() < minAliveness$iv.ordinal()) {
                object2 = new CompileService.CallResult.Dying();
            } else if (ignoreCompilerChanged$iv == false && ((CompileServiceImpl)this_$iv).classpathWatcher.isChanged()) {
                ((CompileServiceImpl)this_$iv).getLog().info("Compiler changed, scheduling shutdown");
                object = this_$iv.getTimer();
                long l = 0L;
                TimerTask timerTask2 = new TimerTask((CompileServiceImpl)this_$iv){
                    final /* synthetic */ CompileServiceImpl this$0;

                    public void run() {
                        TimerTask $receiver = this;
                        this.this$0.shutdown();
                    }
                    {
                        this.this$0 = compileServiceImpl;
                    }
                };
                ((Timer)object).schedule(timerTask2, l);
                object2 = new CompileService.CallResult.Dying();
            } else {
                try {
                    body.invoke();
                    object = new CompileService.CallResult.Ok();
                }
                catch (Exception e$iv) {
                    ((CompileServiceImpl)this_$iv).getLog().log(Level.SEVERE, "Exception", e$iv);
                    String string = e$iv.getMessage();
                    if (string == null) {
                        string = "unknown";
                    }
                    object = new CompileService.CallResult.Error(string);
                }
                object2 = object;
            }
            callResult = object2;
        }
        finally {
            n = 0;
            int n5 = n2 - 1;
            if (n <= n5) {
                do {
                    int n6 = ++n;
                    readLock.lock();
                } while (n != n5);
            }
            writeLock.unlock();
        }
        return callResult;
    }

    @NotNull
    public final Registry getRegistry() {
        return this.registry;
    }

    @NotNull
    public final CompilerSelector getCompiler() {
        return this.compiler;
    }

    @NotNull
    public final CompilerId getCompilerId() {
        return this.compilerId;
    }

    @NotNull
    public final DaemonOptions getDaemonOptions() {
        return this.daemonOptions;
    }

    @NotNull
    public final DaemonJVMOptions getDaemonJVMOptions() {
        return this.daemonJVMOptions;
    }

    public final int getPort() {
        return this.port;
    }

    @NotNull
    public final Timer getTimer() {
        return this.timer;
    }

    @NotNull
    public final Function0<Unit> getOnShutdown() {
        return this.onShutdown;
    }

    /*
     * WARNING - void declaration
     */
    public CompileServiceImpl(@NotNull Registry registry, @NotNull CompilerSelector compiler, @NotNull CompilerId compilerId, @NotNull DaemonOptions daemonOptions, @NotNull DaemonJVMOptions daemonJVMOptions, int port, @NotNull Timer timer, @NotNull Function0<Unit> onShutdown) {
        List list2;
        void destination$iv$iv;
        Object object;
        void $receiver$iv$iv;
        void $receiver$iv;
        File file;
        Intrinsics.checkParameterIsNotNull(registry, "registry");
        Intrinsics.checkParameterIsNotNull(compiler, "compiler");
        Intrinsics.checkParameterIsNotNull(compilerId, "compilerId");
        Intrinsics.checkParameterIsNotNull(daemonOptions, "daemonOptions");
        Intrinsics.checkParameterIsNotNull(daemonJVMOptions, "daemonJVMOptions");
        Intrinsics.checkParameterIsNotNull(timer, "timer");
        Intrinsics.checkParameterIsNotNull(onShutdown, "onShutdown");
        this.registry = registry;
        this.compiler = compiler;
        this.compilerId = compilerId;
        this.daemonOptions = daemonOptions;
        this.daemonJVMOptions = daemonJVMOptions;
        this.port = port;
        this.timer = timer;
        this.onShutdown = onShutdown;
        System.setProperty(PropertiesKt.getKOTLIN_COMPILER_ENVIRONMENT_KEEPALIVE_PROPERTY(), "true");
        this.sessionsIdCounter = new AtomicInteger(0);
        this.compilationsCounter = new AtomicInteger(0);
        this.internalRng = new Random();
        this.classpathWatcher = new LazyClasspathWatcher(this.compilerId.getCompilerClasspath(), 0L, 0L, 6, null);
        this.state = new Object(){
            @NotNull
            private final Set<ClientOrSessionProxy> clientProxies;
            @NotNull
            private final Map<Integer, ClientOrSessionProxy> sessions;
            @NotNull
            private final AtomicBoolean delayedShutdownQueued;
            @NotNull
            private AtomicInteger alive;

            @NotNull
            public final Set<ClientOrSessionProxy> getClientProxies() {
                return this.clientProxies;
            }

            @NotNull
            public final Map<Integer, ClientOrSessionProxy> getSessions() {
                return this.sessions;
            }

            @NotNull
            public final AtomicBoolean getDelayedShutdownQueued() {
                return this.delayedShutdownQueued;
            }

            @NotNull
            public final AtomicInteger getAlive() {
                return this.alive;
            }

            public final void setAlive(@NotNull AtomicInteger atomicInteger) {
                Intrinsics.checkParameterIsNotNull(atomicInteger, "<set-?>");
                this.alive = atomicInteger;
            }
            {
                this.clientProxies = SetsKt.hashSetOf(new ClientOrSessionProxy[0]);
                this.sessions = MapsKt.hashMapOf(new Pair[0]);
                this.delayedShutdownQueued = new AtomicBoolean(false);
                this.alive = new AtomicInteger(Aliveness.Alive.ordinal());
            }
        };
        this._lastUsedSeconds = CompileServiceImplKt.nowSeconds();
        this.log$delegate = LazyKt.lazy(log.2.INSTANCE);
        this.rwlock = new ReentrantReadWriteLock();
        File runFileDir = new File(DaemonParamsKt.getRunFilesPathOrDefault(this.daemonOptions));
        runFileDir.mkdirs();
        Object object2 = "%tFT%<tH-%<tM-%<tS.%<tLZ";
        Object[] objectArray = new Object[]{Calendar.getInstance(TimeZone.getTimeZone("Z"))};
        File file2 = runFileDir;
        File file3 = file;
        File file4 = file;
        CompileServiceImpl compileServiceImpl = this;
        String string = String.format((String)object2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull(string, "java.lang.String.format(this, *args)");
        String string2 = string;
        object2 = this.compilerId.getCompilerClasspath();
        objectArray = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            object = (String)item$iv$iv;
            list2 = destination$iv$iv;
            String string3 = new File((String)it).getAbsolutePath();
            list2.add(string3);
        }
        list2 = (List)destination$iv$iv;
        file3(file2, ClientUtilsKt.makeRunFilenameString$default(string2, DaemonParamsKt.toHexString(DaemonParamsKt.distinctStringsDigest(list2)), String.valueOf(this.port), null, 8, null));
        compileServiceImpl.runFile = file4;
        try {
            if (!this.runFile.createNewFile()) {
                throw (Throwable)new Exception("createNewFile returned false");
            }
        }
        catch (Exception e) {
            throw (Throwable)new IllegalStateException("Unable to create run file '" + this.runFile.getAbsolutePath() + "'", e);
        }
        this.runFile.deleteOnExit();
        try {
            UnicastRemoteObject.unexportObject(this, false);
        }
        catch (NoSuchObjectException e) {
            // empty catch block
        }
        Remote remote = UnicastRemoteObject.exportObject(this, this.port, LoopbackNetworkInterface.INSTANCE.getClientLoopbackSocketFactory(), LoopbackNetworkInterface.INSTANCE.getServerLoopbackSocketFactory());
        if (remote == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.daemon.common.CompileService");
        }
        CompileService stub = (CompileService)remote;
        this.registry.rebind(DaemonParamsKt.getCOMPILER_SERVICE_RMI_NAME(), stub);
        object2 = this.timer;
        long l = 0L;
        TimerTask timerTask2 = new TimerTask(this){
            final /* synthetic */ CompileServiceImpl this$0;

            public void run() {
                TimerTask $receiver = this;
                CompileServiceImpl.access$initiateElections(this.this$0);
            }
            {
                this.this$0 = compileServiceImpl;
            }
        };
        ((Timer)object2).schedule(timerTask2, l);
        object2 = this.timer;
        l = KotlinCompileDaemonKt.getDAEMON_PERIODIC_CHECK_INTERVAL_MS();
        long l2 = KotlinCompileDaemonKt.getDAEMON_PERIODIC_CHECK_INTERVAL_MS();
        object = new TimerTask(this){
            final /* synthetic */ CompileServiceImpl this$0;

            public void run() {
                TimerTask $receiver = this;
                try {
                    CompileServiceImpl.access$periodicAndAfterSessionCheck(this.this$0);
                }
                catch (Exception e) {
                    System.err.println("Exception in timer thread: " + e.getMessage());
                    e.printStackTrace(System.err);
                    CompileServiceImpl.access$getLog$p(this.this$0).log(Level.SEVERE, "Exception in timer thread", e);
                }
            }
            {
                this.this$0 = compileServiceImpl;
            }
        };
        ((Timer)object2).schedule((TimerTask)object, l, l2);
    }

    static {
        $$delegatedProperties = new KProperty[]{Reflection.property1(new PropertyReference1Impl(Reflection.getOrCreateKotlinClass(CompileServiceImpl.class), "log", "getLog()Ljava/util/logging/Logger;"))};
    }

    @NotNull
    public static final /* synthetic */ AtomicInteger access$getSessionsIdCounter$p(CompileServiceImpl $this) {
        return $this.sessionsIdCounter;
    }

    @NotNull
    public static final /* synthetic */ Random access$getInternalRng$p(CompileServiceImpl $this) {
        return $this.internalRng;
    }

    public static final /* synthetic */ void access$clearJarCache(CompileServiceImpl $this) {
        $this.clearJarCache();
    }

    public static final /* synthetic */ void access$periodicAndAfterSessionCheck(CompileServiceImpl $this) {
        $this.periodicAndAfterSessionCheck();
    }

    public static final /* synthetic */ void access$shutdownImpl(CompileServiceImpl $this) {
        $this.shutdownImpl();
    }

    @NotNull
    public static final /* synthetic */ CompileService.CallResult access$ifAliveExclusive(CompileServiceImpl $this, @NotNull Aliveness minAliveness, boolean ignoreCompilerChanged, @NotNull Function0 body) {
        return $this.ifAliveExclusive(minAliveness, ignoreCompilerChanged, body);
    }

    @NotNull
    public static final /* synthetic */ Services access$createCompileServices(CompileServiceImpl $this, @NotNull CompilerCallbackServicesFacade facade, @NotNull EventManger eventManger, @NotNull Profiler rpcProfiler) {
        return $this.createCompileServices(facade, eventManger, rpcProfiler);
    }

    public static final /* synthetic */ boolean access$shutdownCondition(CompileServiceImpl $this, @NotNull Function0 check, @NotNull String message) {
        return $this.shutdownCondition(check, message);
    }

    @NotNull
    public static final /* synthetic */ AtomicInteger access$getCompilationsCounter$p(CompileServiceImpl $this) {
        return $this.compilationsCounter;
    }

    public static final /* synthetic */ void access$shutdownWithDelay(CompileServiceImpl $this) {
        $this.shutdownWithDelay();
    }

    @NotNull
    public static final /* synthetic */ File access$getRunFile$p(CompileServiceImpl $this) {
        return $this.runFile;
    }

    public static final /* synthetic */ void access$setRunFile$p(CompileServiceImpl $this, @NotNull File file) {
        $this.runFile = file;
    }

    public static final /* synthetic */ Object access$checkedCompile(CompileServiceImpl $this, @NotNull String[] args, @NotNull PrintStream serviceOut, @NotNull Profiler rpcProfiler, @NotNull Function0 body) {
        return $this.checkedCompile(args, serviceOut, rpcProfiler, body);
    }

    public static final /* synthetic */ long access$get_lastUsedSeconds$p(CompileServiceImpl $this) {
        return $this._lastUsedSeconds;
    }

    public static final /* synthetic */ void access$set_lastUsedSeconds$p(CompileServiceImpl $this, long l) {
        $this._lastUsedSeconds = l;
    }

    public static final /* synthetic */ void access$initiateElections(CompileServiceImpl $this) {
        $this.initiateElections();
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/daemon/CompileServiceImpl$ClientOrSessionProxy;", "", "aliveFlagPath", "", "(Ljava/lang/String;)V", "getAliveFlagPath", "()Ljava/lang/String;", "isAlive", "", "()Z", "registered", "", "getRegistered", "()J", "secondsSinceRegistered", "getSecondsSinceRegistered", "kotlin-compiler"})
    private static final class ClientOrSessionProxy {
        private final long registered;
        @Nullable
        private final String aliveFlagPath;

        public final long getRegistered() {
            return this.registered;
        }

        public final long getSecondsSinceRegistered() {
            return CompileServiceImplKt.nowSeconds() - this.registered;
        }

        public final boolean isAlive() {
            boolean bl;
            String string = this.aliveFlagPath;
            if (string != null) {
                String string2 = string;
                String it = string2;
                bl = new File(it).exists();
            } else {
                bl = true;
            }
            return bl;
        }

        @Nullable
        public final String getAliveFlagPath() {
            return this.aliveFlagPath;
        }

        public ClientOrSessionProxy(@Nullable String aliveFlagPath) {
            this.aliveFlagPath = aliveFlagPath;
            this.registered = CompileServiceImplKt.nowSeconds();
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/daemon/CompileServiceImpl$Aliveness;", "", "(Ljava/lang/String;I)V", "Dying", "LastSession", "Alive", "kotlin-compiler"})
    public static final class Aliveness
    extends Enum<Aliveness> {
        public static final /* enum */ Aliveness Dying;
        public static final /* enum */ Aliveness LastSession;
        public static final /* enum */ Aliveness Alive;
        private static final /* synthetic */ Aliveness[] $VALUES;

        static {
            Aliveness[] alivenessArray = new Aliveness[3];
            Aliveness[] alivenessArray2 = alivenessArray;
            alivenessArray[0] = Dying = new Aliveness();
            alivenessArray[1] = LastSession = new Aliveness();
            alivenessArray[2] = Alive = new Aliveness();
            $VALUES = alivenessArray;
        }

        public static Aliveness[] values() {
            return (Aliveness[])$VALUES.clone();
        }

        public static Aliveness valueOf(String string) {
            return Enum.valueOf(Aliveness.class, string);
        }
    }
}

