/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.inline;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtil;
import org.jetbrains.kotlin.codegen.inline.ParameterInfo;
import org.jetbrains.kotlin.codegen.inline.Parameters;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

public class LocalVarRemapper {
    private final Parameters params;
    private final int actualParamsSize;
    private final StackValue[] remapValues;
    private final int additionalShift;

    public LocalVarRemapper(Parameters params, int additionalShift) {
        this.additionalShift = additionalShift;
        this.params = params;
        this.remapValues = new StackValue[params.getArgsSizeOnStack()];
        int realSize = 0;
        for (ParameterInfo info : params) {
            Integer shift = params.getDeclarationSlot(info);
            if (!info.isSkippedOrRemapped()) {
                this.remapValues[shift.intValue()] = StackValue.local(realSize, AsmTypes.OBJECT_TYPE);
                realSize += info.getType().getSize();
                continue;
            }
            this.remapValues[shift.intValue()] = info.isRemapped() ? info.getRemapValue() : null;
        }
        this.actualParamsSize = realSize;
    }

    public RemapInfo doRemap(int index2) {
        int remappedIndex;
        if (index2 < this.params.getArgsSizeOnStack()) {
            ParameterInfo info = this.params.getParameterByDeclarationSlot(index2);
            StackValue remapped = this.remapValues[index2];
            if (info.isSkipped || remapped == null) {
                return new RemapInfo(info);
            }
            if (info.isRemapped()) {
                return new RemapInfo(remapped, info, RemapStatus.REMAPPED);
            }
            remappedIndex = ((StackValue.Local)remapped).index;
        } else {
            remappedIndex = this.actualParamsSize - this.params.getArgsSizeOnStack() + index2;
        }
        return new RemapInfo(StackValue.local(remappedIndex + this.additionalShift, AsmTypes.OBJECT_TYPE), null, RemapStatus.SHIFT);
    }

    public RemapInfo remap(int index2) {
        RemapInfo info = this.doRemap(index2);
        if (RemapStatus.FAIL == info.status) {
            assert (info.parameterInfo != null) : "Parameter info should be not null";
            throw new RuntimeException("Trying to access skipped parameter: " + info.parameterInfo.type + " at " + index2);
        }
        return info;
    }

    public void visitIincInsn(int var, int increment, MethodVisitor mv) {
        RemapInfo remap = this.remap(var);
        assert (remap.value instanceof StackValue.Local);
        mv.visitIincInsn(((StackValue.Local)remap.value).index, increment);
    }

    public void visitLocalVariable(String name, String desc, String signature2, Label start, Label end, int index2, MethodVisitor mv) {
        RemapInfo info = this.doRemap(index2);
        if (RemapStatus.SHIFT == info.status) {
            int newIndex = ((StackValue.Local)info.value).index;
            mv.visitLocalVariable(name, desc, signature2, start, end, newIndex);
        }
    }

    public void visitVarInsn(int opcode, int var, InstructionAdapter mv) {
        RemapInfo remapInfo = this.remap(var);
        StackValue value = remapInfo.value;
        if (value instanceof StackValue.Local) {
            if (remapInfo.parameterInfo != null) {
                opcode = value.type.getOpcode(InlineCodegenUtil.isStoreInstruction(opcode) ? 54 : 21);
            }
            mv.visitVarInsn(opcode, ((StackValue.Local)value).index);
            if (remapInfo.parameterInfo != null) {
                StackValue.coerce(value.type, remapInfo.parameterInfo.type, mv);
            }
        } else {
            assert (remapInfo.parameterInfo != null) : "Non local value should have parameter info";
            value.put(remapInfo.parameterInfo.type, mv);
        }
    }

    public static class RemapInfo {
        public final StackValue value;
        public final ParameterInfo parameterInfo;
        public final RemapStatus status;

        public RemapInfo(@NotNull StackValue value, @Nullable ParameterInfo info, RemapStatus remapStatus) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/codegen/inline/LocalVarRemapper$RemapInfo", "<init>"));
            }
            this.value = value;
            this.parameterInfo = info;
            this.status = remapStatus;
        }

        public RemapInfo(@NotNull ParameterInfo info) {
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/kotlin/codegen/inline/LocalVarRemapper$RemapInfo", "<init>"));
            }
            this.value = null;
            this.parameterInfo = info;
            this.status = RemapStatus.FAIL;
        }
    }

    public static enum RemapStatus {
        SHIFT,
        REMAPPED,
        FAIL;

    }
}

