/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaClassDescriptor;
import org.jetbrains.kotlin.load.java.sam.SingleAbstractMethodUtils;
import org.jetbrains.kotlin.types.KotlinType;

public class SamType {
    private final KotlinType type;

    public static SamType create(@NotNull KotlinType originalType) {
        if (originalType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalType", "org/jetbrains/kotlin/codegen/SamType", "create"));
        }
        if (!SingleAbstractMethodUtils.isSamType(originalType)) {
            return null;
        }
        return new SamType(originalType);
    }

    private SamType(@NotNull KotlinType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/SamType", "<init>"));
        }
        this.type = type2;
    }

    @NotNull
    public KotlinType getType() {
        KotlinType kotlinType = this.type;
        if (kotlinType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/SamType", "getType"));
        }
        return kotlinType;
    }

    @NotNull
    public JavaClassDescriptor getJavaClassDescriptor() {
        ClassifierDescriptor classifier2 = this.type.getConstructor().getDeclarationDescriptor();
        assert (classifier2 instanceof JavaClassDescriptor) : "Sam interface not a Java class: " + classifier2;
        JavaClassDescriptor javaClassDescriptor = (JavaClassDescriptor)classifier2;
        if (javaClassDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/SamType", "getJavaClassDescriptor"));
        }
        return javaClassDescriptor;
    }

    @NotNull
    public KotlinType getKotlinFunctionType() {
        KotlinType kotlinType = this.getJavaClassDescriptor().getFunctionTypeForSamInterface();
        if (kotlinType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/SamType", "getKotlinFunctionType"));
        }
        return kotlinType;
    }

    @NotNull
    public SimpleFunctionDescriptor getAbstractMethod() {
        SimpleFunctionDescriptor simpleFunctionDescriptor = (SimpleFunctionDescriptor)SingleAbstractMethodUtils.getAbstractMembers(this.type).get(0);
        if (simpleFunctionDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/SamType", "getAbstractMethod"));
        }
        return simpleFunctionDescriptor;
    }

    public boolean equals(Object o) {
        return o instanceof SamType && this.type.equals(((SamType)o).type);
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public String toString() {
        return "SamType(" + this.type + ")";
    }
}

