/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.MutableAccessor;
import com.intellij.util.xmlb.SerializationFilter;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.relocated.org.jdom.Element;

class CompactCollectionBinding
extends Binding {
    private final String name;

    protected CompactCollectionBinding(@NotNull MutableAccessor accessor) {
        if (accessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessor", "com/intellij/util/xmlb/CompactCollectionBinding", "<init>"));
        }
        super(accessor);
        this.name = this.myAccessor.getName();
    }

    @Override
    @Nullable
    public Object serialize(@NotNull Object o, @Nullable Object context, @NotNull SerializationFilter filter2) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/util/xmlb/CompactCollectionBinding", "serialize"));
        }
        if (filter2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/util/xmlb/CompactCollectionBinding", "serialize"));
        }
        Element result2 = new Element(this.name);
        List list2 = (List)o;
        if (list2.isEmpty()) {
            return result2;
        }
        for (String item : list2) {
            result2.addContent(new Element("item").setAttribute("value", item));
        }
        return result2;
    }

    @Override
    @Nullable
    public Object deserialize(Object context, @NotNull Element element) {
        List list2;
        block5: {
            block4: {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xmlb/CompactCollectionBinding", "deserialize"));
                }
                list2 = (List)context;
                list2.clear();
                if (!element.getName().equals(this.name)) break block4;
                for (Element item : element.getChildren("item")) {
                    ContainerUtil.addIfNotNull(list2, item.getAttributeValue("value"));
                }
                break block5;
            }
            Element value = element.getChild("value");
            if (value != null) {
                value = value.getChild("list");
            }
            if (value == null) break block5;
            for (Element item : value.getChildren("item")) {
                ContainerUtil.addIfNotNull(list2, item.getAttributeValue("itemvalue"));
            }
        }
        return list2;
    }

    @Override
    public boolean isBoundTo(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xmlb/CompactCollectionBinding", "isBoundTo"));
        }
        String elementName = element.getName();
        if (this.isNameEqual(elementName)) {
            return true;
        }
        if (elementName.equals("option")) {
            return this.isNameEqual(element.getAttributeValue("name"));
        }
        return false;
    }

    private boolean isNameEqual(@Nullable String value) {
        if (value == null) {
            return false;
        }
        if (value.equals(this.name)) {
            return true;
        }
        if (value.length() == this.name.length() + 2 && value.startsWith("my")) {
            return Character.isUpperCase(value.charAt(2)) && value.regionMatches(true, 2, this.name, 0, this.name.length());
        }
        return false;
    }
}

