/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.java.ExpressionPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiSuperExpressionImpl
extends ExpressionPsiElement
implements PsiSuperExpression,
Constants {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiSuperExpressionImpl");

    public PsiSuperExpressionImpl() {
        super(SUPER_EXPRESSION);
    }

    @Override
    public PsiJavaCodeReferenceElement getQualifier() {
        return (PsiJavaCodeReferenceElement)this.findChildByRoleAsPsiElement(54);
    }

    @Override
    public PsiType getType() {
        PsiJavaCodeReferenceElement qualifier2 = this.getQualifier();
        if (qualifier2 != null) {
            PsiElement aClass2 = qualifier2.resolve();
            if (!(aClass2 instanceof PsiClass)) {
                return null;
            }
            return this.getSuperType((PsiClass)aClass2, PsiUtil.isLanguageLevel8OrHigher(this));
        }
        for (PsiElement scope = this.getContext(); scope != null; scope = scope.getContext()) {
            PsiType fragmentSuperType;
            if (scope instanceof PsiClass) {
                PsiClass aClass3 = (PsiClass)scope;
                return this.getSuperType(aClass3, false);
            }
            if (scope instanceof PsiExpressionList && scope.getParent() instanceof PsiAnonymousClass) {
                scope = scope.getParent();
                continue;
            }
            if (!(scope instanceof JavaCodeFragment) || (fragmentSuperType = ((JavaCodeFragment)scope).getSuperType()) == null) continue;
            return fragmentSuperType;
        }
        return null;
    }

    @Nullable
    private PsiType getSuperType(PsiClass aClass2, boolean checkImmediateSuperInterfaces) {
        PsiClassType[] superTypes2;
        PsiClass containingClass;
        if ("java.lang.Object".equals(aClass2.getQualifiedName())) {
            return null;
        }
        PsiClass psiClass = containingClass = checkImmediateSuperInterfaces ? PsiTreeUtil.getParentOfType((PsiElement)this, PsiClass.class) : null;
        if (containingClass != null) {
            superTypes2 = containingClass.isInterface() ? containingClass.getExtendsListTypes() : (containingClass instanceof PsiAnonymousClass ? new PsiClassType[]{((PsiAnonymousClass)containingClass).getBaseClassType()} : containingClass.getImplementsListTypes());
            for (PsiClassType superType : superTypes2) {
                PsiClass superClass = superType.resolve();
                if (superClass == null || !superClass.isInterface() || !aClass2.equals(superClass)) continue;
                return superType;
            }
        }
        if (aClass2.isInterface()) {
            return PsiType.getJavaLangObject(this.getManager(), this.getResolveScope());
        }
        if (aClass2 instanceof PsiAnonymousClass) {
            PsiClassType baseClassType = ((PsiAnonymousClass)aClass2).getBaseClassType();
            PsiClass psiClass2 = baseClassType.resolve();
            return psiClass2 != null && !psiClass2.isInterface() ? baseClassType : PsiType.getJavaLangObject(this.getManager(), this.getResolveScope());
        }
        superTypes2 = aClass2.getExtendsListTypes();
        return superTypes2.length == 0 ? PsiType.getJavaLangObject(this.getManager(), this.getResolveScope()) : superTypes2[0];
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 54: {
                return this.getFirstChildNode().getElementType() == JAVA_CODE_REFERENCE ? this.getFirstChildNode() : null;
            }
            case 55: {
                return this.findChildByType(DOT);
            }
            case 96: 
        }
        return this.getLastChildNode();
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == JAVA_CODE_REFERENCE) {
            return 54;
        }
        if (i == DOT) {
            return 55;
        }
        if (i == SUPER_KEYWORD) {
            return 96;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/tree/java/PsiSuperExpressionImpl", "accept"));
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitSuperExpression(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiSuperExpression:" + this.getText();
    }
}

