/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.java.parser.JavaParser;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLambdaExpressionType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethodReferenceType;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.GeneratedMarkerVisitor;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.JavaDummyElement;
import com.intellij.psi.impl.source.PsiJavaCodeReferenceElementImpl;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeGenerator;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.CharTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaTreeGenerator
implements TreeGenerator {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.JavaTreeGenerator");
    private static final JavaParserUtil.ParserWrapper MOD_LIST = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getDeclarationParser().parseModifierList(builder);
        }
    };
    static final Key<PsiClass> REFERENCED_CLASS_KEY = Key.create("REFERENCED_CLASS_KEY");
    static final Key<PsiMember> REFERENCED_MEMBER_KEY = Key.create("REFERENCED_MEMBER_KEY");

    @Override
    @Nullable
    public TreeElement generateTreeFor(@NotNull PsiElement original, @NotNull CharTable table, @NotNull PsiManager manager) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/psi/impl/source/tree/JavaTreeGenerator", "generateTreeFor"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/psi/impl/source/tree/JavaTreeGenerator", "generateTreeFor"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/source/tree/JavaTreeGenerator", "generateTreeFor"));
        }
        if (original instanceof PsiKeyword || original instanceof PsiIdentifier) {
            String text = original.getText();
            return JavaTreeGenerator.createLeafFromText(text, table, manager, original, ((PsiJavaToken)original).getTokenType());
        }
        if (original instanceof PsiModifierList) {
            String text = original.getText();
            assert (text != null) : "Text is null for " + original + "; " + original.getClass();
            LanguageLevel level = PsiUtil.getLanguageLevel(original);
            DummyHolder holder = DummyHolderFactory.createHolder(original.getManager(), new JavaDummyElement(text, MOD_LIST, level), null);
            TreeElement modifierListElement = holder.getTreeElement().getFirstChildNode();
            if (modifierListElement == null) {
                throw new AssertionError((Object)("No modifier list for \"" + text + '\"'));
            }
            return JavaTreeGenerator.markGeneratedIfNeeded(original, modifierListElement);
        }
        if (original instanceof PsiReferenceExpression) {
            TreeElement element = JavaTreeGenerator.createReferenceExpression(original.getProject(), original.getText(), original);
            PsiElement refElement = ((PsiJavaCodeReferenceElement)original).resolve();
            if (refElement instanceof PsiClass) {
                element.putCopyableUserData(REFERENCED_CLASS_KEY, (PsiClass)refElement);
            }
            return element;
        }
        if (original instanceof PsiJavaCodeReferenceElement) {
            boolean generated;
            PsiElement refElement = ((PsiJavaCodeReferenceElement)original).resolve();
            boolean bl = generated = refElement != null && CodeEditUtil.isNodeGenerated(refElement.getNode());
            if (refElement instanceof PsiClass) {
                if (refElement instanceof PsiAnonymousClass) {
                    PsiJavaCodeReferenceElement ref = ((PsiAnonymousClass)refElement).getBaseClassReference();
                    original = ref;
                    refElement = ref.resolve();
                }
                boolean isFQ = false;
                if (original instanceof PsiJavaCodeReferenceElementImpl) {
                    int kind = ((PsiJavaCodeReferenceElementImpl)original).getKind(original.getContainingFile());
                    switch (kind) {
                        case 1: 
                        case 3: 
                        case 6: {
                            isFQ = false;
                            break;
                        }
                        case 4: 
                        case 5: {
                            isFQ = true;
                            break;
                        }
                        default: {
                            LOG.assertTrue(false);
                        }
                    }
                }
                String text = isFQ ? ((PsiClass)refElement).getQualifiedName() : original.getText();
                TreeElement element = JavaTreeGenerator.createReference(original.getProject(), text, generated);
                element.putCopyableUserData(REFERENCED_CLASS_KEY, (PsiClass)refElement);
                return element;
            }
            return JavaTreeGenerator.createReference(original.getProject(), original.getText(), generated);
        }
        if (original instanceof PsiCompiledElement) {
            PsiElement sourceVersion = original.getNavigationElement();
            if (sourceVersion != original) {
                return ChangeUtil.generateTreeElement(sourceVersion, table, manager);
            }
            PsiElement mirror = ((PsiCompiledElement)original).getMirror();
            return ChangeUtil.generateTreeElement(mirror, table, manager);
        }
        if (original instanceof PsiTypeElement) {
            PsiTypeElement typeElement = (PsiTypeElement)original;
            PsiType type2 = typeElement.getType();
            if (type2 instanceof PsiIntersectionType) {
                type2 = ((PsiIntersectionType)type2).getRepresentative();
            } else if (type2 instanceof PsiMethodReferenceType || type2 instanceof PsiLambdaExpressionType) {
                type2 = PsiType.getJavaLangObject(manager, GlobalSearchScope.projectScope(manager.getProject()));
            }
            String text = type2.getCanonicalText(true);
            PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance(original.getProject()).getParserFacade();
            PsiTypeElement element = parserFacade.createTypeElementFromText(text, original);
            TreeElement result2 = (TreeElement)element.getNode();
            JavaTreeGenerator.markGeneratedIfNeeded(original, result2);
            JavaTreeGenerator.encodeInfoInTypeElement(result2, type2);
            return result2;
        }
        return null;
    }

    private static LeafElement createLeafFromText(String text, CharTable table, PsiManager manager, PsiElement original, IElementType type2) {
        return Factory.createSingleLeafElement(type2, (CharSequence)text, 0, text.length(), table, manager, CodeEditUtil.isNodeGenerated(original.getNode()));
    }

    private static TreeElement markGeneratedIfNeeded(@NotNull PsiElement original, @NotNull TreeElement copy) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/psi/impl/source/tree/JavaTreeGenerator", "markGeneratedIfNeeded"));
        }
        if (copy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copy", "com/intellij/psi/impl/source/tree/JavaTreeGenerator", "markGeneratedIfNeeded"));
        }
        if (CodeEditUtil.isNodeGenerated(original.getNode())) {
            copy.acceptTree(new GeneratedMarkerVisitor());
        }
        return copy;
    }

    private static TreeElement createReference(Project project, String text, boolean mark) {
        PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance(project).getParserFacade();
        TreeElement element = (TreeElement)parserFacade.createReferenceFromText(text, null).getNode();
        if (mark) {
            element.acceptTree(new GeneratedMarkerVisitor());
        }
        return element;
    }

    private static TreeElement createReferenceExpression(Project project, String text, PsiElement context) {
        PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance(project).getParserFacade();
        PsiExpression expression = parserFacade.createExpressionFromText(text, context);
        return (TreeElement)expression.getNode();
    }

    private static void encodeInfoInTypeElement(ASTNode typeElement, PsiType type2) {
        if (type2 instanceof PsiPrimitiveType) {
            return;
        }
        LOG.assertTrue(typeElement.getElementType() == JavaElementType.TYPE);
        if (type2 instanceof PsiArrayType) {
            ASTNode firstChild = typeElement.getFirstChildNode();
            LOG.assertTrue(firstChild.getElementType() == JavaElementType.TYPE);
            JavaTreeGenerator.encodeInfoInTypeElement(firstChild, ((PsiArrayType)type2).getComponentType());
        } else if (type2 instanceof PsiWildcardType) {
            PsiType bound = ((PsiWildcardType)type2).getBound();
            if (bound == null) {
                return;
            }
            ASTNode lastChild = typeElement.getLastChildNode();
            if (lastChild.getElementType() != JavaElementType.TYPE) {
                return;
            }
            JavaTreeGenerator.encodeInfoInTypeElement(lastChild, bound);
        } else if (type2 instanceof PsiCapturedWildcardType) {
            PsiType bound = ((PsiCapturedWildcardType)type2).getWildcard().getBound();
            if (bound == null) {
                return;
            }
            ASTNode lastChild = typeElement.getLastChildNode();
            if (lastChild.getElementType() != JavaElementType.TYPE) {
                return;
            }
            JavaTreeGenerator.encodeInfoInTypeElement(lastChild, bound);
        } else if (type2 instanceof PsiIntersectionType) {
            JavaTreeGenerator.encodeInfoInTypeElement(typeElement, ((PsiIntersectionType)type2).getRepresentative());
        } else if (type2 instanceof PsiClassType) {
            PsiClassType classType = (PsiClassType)type2;
            PsiClassType.ClassResolveResult resolveResult = classType.resolveGenerics();
            PsiClass referencedClass = resolveResult.getElement();
            if (referencedClass == null) {
                return;
            }
            if (referencedClass instanceof PsiAnonymousClass) {
                JavaTreeGenerator.encodeInfoInTypeElement(typeElement, ((PsiAnonymousClass)referencedClass).getBaseClassType());
            } else {
                ASTNode reference = typeElement.findChildByType(JavaElementType.JAVA_CODE_REFERENCE);
                if (reference instanceof CompositeElement) {
                    JavaTreeGenerator.encodeClassTypeInfoInReference((CompositeElement)reference, resolveResult.getElement(), resolveResult.getSubstitutor());
                }
            }
        }
    }

    private static void encodeClassTypeInfoInReference(@NotNull CompositeElement reference, PsiClass referencedClass, PsiSubstitutor substitutor2) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/psi/impl/source/tree/JavaTreeGenerator", "encodeClassTypeInfoInReference"));
        }
        reference.putCopyableUserData(REFERENCED_CLASS_KEY, referencedClass);
        PsiTypeParameter[] typeParameters = referencedClass.getTypeParameters();
        if (typeParameters.length == 0) {
            return;
        }
        ASTNode referenceParameterList = reference.findChildByRole(246);
        int index2 = 0;
        for (ASTNode child = referenceParameterList.getFirstChildNode(); child != null && index2 < typeParameters.length; child = child.getTreeNext()) {
            if (child.getElementType() != JavaElementType.TYPE) continue;
            PsiType substitutedType = substitutor2.substitute(typeParameters[index2]);
            if (substitutedType != null) {
                JavaTreeGenerator.encodeInfoInTypeElement(child, substitutedType);
            }
            ++index2;
        }
        ASTNode qualifier2 = reference.findChildByRole(54);
        if (qualifier2 != null) {
            if (referencedClass.hasModifierProperty("static")) {
                return;
            }
            PsiClass outerClass = referencedClass.getContainingClass();
            if (outerClass != null) {
                JavaTreeGenerator.encodeClassTypeInfoInReference((CompositeElement)qualifier2, outerClass, substitutor2);
            }
        }
    }
}

