/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.impl.compiled.ClsParsingUtil;
import com.intellij.psi.impl.compiled.InnerClassSourceStrategy;
import com.intellij.psi.impl.compiled.OutOfOrderInnerClassException;
import com.intellij.psi.impl.compiled.SignatureParsing;
import com.intellij.psi.impl.java.stubs.JavaClassReferenceListElementType;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.impl.java.stubs.PsiMethodStub;
import com.intellij.psi.impl.java.stubs.PsiModifierListStub;
import com.intellij.psi.impl.java.stubs.impl.PsiAnnotationStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiClassReferenceListStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiClassStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiFieldStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiMethodStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiModifierListStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiParameterListStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiParameterStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiTypeParameterListStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiTypeParameterStubImpl;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.cls.ClsFormatException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.StringRef;
import java.lang.reflect.Array;
import java.text.StringCharacterIterator;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;

public class StubBuildingVisitor<T>
extends ClassVisitor {
    private static final Logger LOG = Logger.getInstance(StubBuildingVisitor.class);
    private final T mySource;
    private final InnerClassSourceStrategy<T> myInnersStrategy;
    private final StubElement myParent;
    private final int myAccess;
    private final String myShortName;
    private final Function<String, String> myMapping;
    private String myInternalName;
    private PsiClassStub myResult;
    private PsiModifierListStub myModList;
    private static final String[] parameterNames = new String[]{"p1", "p2", "p3", "p4", "p5", "p6", "p7", "p8", "p9"};
    public static final Function<String, String> GUESSING_MAPPER = new Function<String, String>(){

        @Override
        public String fun(String internalName) {
            String canonicalText = internalName;
            if (canonicalText.indexOf(36) >= 0) {
                StringBuilder sb = new StringBuilder(canonicalText);
                boolean updated = false;
                for (int p = 0; p < sb.length(); ++p) {
                    char c = sb.charAt(p);
                    if (c != '$' || p <= 0 || sb.charAt(p - 1) == '/' || p >= sb.length() - 1 || sb.charAt(p + 1) == '$') continue;
                    sb.setCharAt(p, '.');
                    updated = true;
                }
                if (updated) {
                    canonicalText = sb.toString();
                }
            }
            return canonicalText.replace('/', '.');
        }
    };

    public StubBuildingVisitor(T classSource, InnerClassSourceStrategy<T> innersStrategy, StubElement parent2, int access, String shortName) {
        super(327680);
        this.mySource = classSource;
        this.myInnersStrategy = innersStrategy;
        this.myParent = parent2;
        this.myAccess = access;
        this.myShortName = shortName;
        this.myMapping = StubBuildingVisitor.createMapping(classSource);
    }

    public PsiClassStub<?> getResult() {
        return this.myResult;
    }

    @Override
    public void visit(int version, int access, String name, String signature2, String superName, String[] interfaces) {
        ClassInfo info;
        block11: {
            this.myInternalName = name;
            String parentName = this.myParent instanceof PsiClassStub ? ((PsiClassStub)this.myParent).getQualifiedName() : (this.myParent instanceof PsiJavaFileStub ? ((PsiJavaFileStub)this.myParent).getPackageName() : null);
            String fqn = this.getFqn(name, this.myShortName, parentName);
            String shortName = this.myShortName != null && name.endsWith(this.myShortName) ? this.myShortName : PsiNameHelper.getShortClassName(fqn);
            int flags = this.myAccess | access;
            boolean isDeprecated = (flags & 0x20000) != 0;
            boolean isInterface = (flags & 0x200) != 0;
            boolean isEnum = (flags & 0x4000) != 0;
            boolean isAnnotationType = (flags & 0x2000) != 0;
            byte stubFlags = PsiClassStubImpl.packFlags(isDeprecated, isInterface, isEnum, false, false, isAnnotationType, false, false);
            this.myResult = new PsiClassStubImpl(JavaStubElementTypes.CLASS, this.myParent, fqn, shortName, null, stubFlags);
            LanguageLevel languageLevel = ClsParsingUtil.getLanguageLevelByVersion(version);
            if (languageLevel == null) {
                languageLevel = LanguageLevel.HIGHEST;
            }
            ((PsiClassStubImpl)this.myResult).setLanguageLevel(languageLevel);
            this.myModList = new PsiModifierListStubImpl((StubElement)this.myResult, StubBuildingVisitor.packClassFlags(flags));
            info = null;
            if (signature2 != null) {
                try {
                    info = this.parseClassSignature(signature2);
                }
                catch (ClsFormatException e) {
                    if (!LOG.isDebugEnabled()) break block11;
                    LOG.debug("source=" + this.mySource + " signature=" + signature2, e);
                }
            }
        }
        if (info == null) {
            info = this.parseClassDescription(superName, interfaces);
        }
        PsiTypeParameterListStubImpl typeParameterList = new PsiTypeParameterListStubImpl(this.myResult);
        for (Pair parameter : info.typeParameters) {
            PsiTypeParameterStubImpl parameterStub = new PsiTypeParameterStubImpl((StubElement)typeParameterList, StringRef.fromString((String)parameter.first));
            StubBuildingVisitor.newReferenceList(JavaStubElementTypes.EXTENDS_BOUND_LIST, parameterStub, (String[])parameter.second);
        }
        if (this.myResult.isInterface()) {
            if (info.interfaceNames != null && this.myResult.isAnnotationType()) {
                info.interfaceNames.remove("java.lang.annotation.Annotation");
            }
            StubBuildingVisitor.newReferenceList(JavaStubElementTypes.EXTENDS_LIST, this.myResult, ArrayUtil.toStringArray(info.interfaceNames));
            StubBuildingVisitor.newReferenceList(JavaStubElementTypes.IMPLEMENTS_LIST, this.myResult, ArrayUtil.EMPTY_STRING_ARRAY);
        } else {
            if (info.superName == null || "java/lang/Object".equals(superName) || this.myResult.isEnum() && "java/lang/Enum".equals(superName)) {
                StubBuildingVisitor.newReferenceList(JavaStubElementTypes.EXTENDS_LIST, this.myResult, ArrayUtil.EMPTY_STRING_ARRAY);
            } else {
                StubBuildingVisitor.newReferenceList(JavaStubElementTypes.EXTENDS_LIST, this.myResult, new String[]{info.superName});
            }
            StubBuildingVisitor.newReferenceList(JavaStubElementTypes.IMPLEMENTS_LIST, this.myResult, ArrayUtil.toStringArray(info.interfaceNames));
        }
    }

    private String getFqn(@NotNull String internalName, @Nullable String shortName, @Nullable String parentName) {
        if (internalName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalName", "com/intellij/psi/impl/compiled/StubBuildingVisitor", "getFqn"));
        }
        if (shortName == null || !internalName.endsWith(shortName)) {
            return this.myMapping.fun(internalName);
        }
        if (internalName.length() == shortName.length()) {
            return shortName;
        }
        if (parentName == null) {
            parentName = this.myMapping.fun(internalName.substring(0, internalName.length() - shortName.length() - 1));
        }
        return parentName + '.' + shortName;
    }

    private ClassInfo parseClassSignature(String signature2) throws ClsFormatException {
        ClassInfo result2 = new ClassInfo();
        StringCharacterIterator iterator2 = new StringCharacterIterator(signature2);
        result2.typeParameters = SignatureParsing.parseTypeParametersDeclaration(iterator2, this.myMapping);
        result2.superName = SignatureParsing.parseTopLevelClassRefSignature(iterator2, this.myMapping);
        while (iterator2.current() != '\uffff') {
            String name = SignatureParsing.parseTopLevelClassRefSignature(iterator2, this.myMapping);
            if (name == null) {
                throw new ClsFormatException();
            }
            if (result2.interfaceNames == null) {
                result2.interfaceNames = ContainerUtil.newSmartList();
            }
            result2.interfaceNames.add(name);
        }
        return result2;
    }

    private ClassInfo parseClassDescription(String superClass, String[] superInterfaces) {
        ClassInfo result2 = new ClassInfo();
        result2.typeParameters = ContainerUtil.emptyList();
        result2.superName = superClass != null ? this.myMapping.fun(superClass) : null;
        result2.interfaceNames = superInterfaces == null ? null : ContainerUtil.map(superInterfaces, new Function<String, String>(){

            @Override
            public String fun(String name) {
                return (String)StubBuildingVisitor.this.myMapping.fun(name);
            }
        });
        return result2;
    }

    private static void newReferenceList(JavaClassReferenceListElementType type2, StubElement parent2, String[] types) {
        PsiReferenceList.Role role;
        if (type2 == JavaStubElementTypes.EXTENDS_LIST) {
            role = PsiReferenceList.Role.EXTENDS_LIST;
        } else if (type2 == JavaStubElementTypes.IMPLEMENTS_LIST) {
            role = PsiReferenceList.Role.IMPLEMENTS_LIST;
        } else if (type2 == JavaStubElementTypes.THROWS_LIST) {
            role = PsiReferenceList.Role.THROWS_LIST;
        } else if (type2 == JavaStubElementTypes.EXTENDS_BOUND_LIST) {
            role = PsiReferenceList.Role.EXTENDS_BOUNDS_LIST;
        } else {
            throw new IllegalArgumentException("Unknown type: " + type2);
        }
        new PsiClassReferenceListStubImpl(type2, parent2, types, role);
    }

    private static int packCommonFlags(int access) {
        int flags = 0;
        flags = (access & 2) != 0 ? (flags |= 2) : ((access & 4) != 0 ? (flags |= 4) : ((access & 1) != 0 ? (flags |= 1) : (flags |= 0x1000)));
        if ((access & 8) != 0) {
            flags |= 8;
        }
        if ((access & 0x10) != 0) {
            flags |= 0x10;
        }
        return flags;
    }

    private static int packClassFlags(int access) {
        int flags = StubBuildingVisitor.packCommonFlags(access);
        if ((access & 0x400) != 0) {
            flags |= 0x400;
        }
        return flags;
    }

    private static int packFieldFlags(int access) {
        int flags = StubBuildingVisitor.packCommonFlags(access);
        if ((access & 0x40) != 0) {
            flags |= 0x40;
        }
        if ((access & 0x80) != 0) {
            flags |= 0x80;
        }
        return flags;
    }

    private static int packMethodFlags(int access, boolean isInterface) {
        int flags = StubBuildingVisitor.packCommonFlags(access);
        if ((access & 0x20) != 0) {
            flags |= 0x20;
        }
        if ((access & 0x100) != 0) {
            flags |= 0x100;
        }
        if ((access & 0x800) != 0) {
            flags |= 0x800;
        }
        if ((access & 0x400) != 0) {
            flags |= 0x400;
        } else if (isInterface && (access & 8) == 0) {
            flags |= 0x200;
        }
        return flags;
    }

    @Override
    public void visitSource(String source, String debug) {
        ((PsiClassStubImpl)this.myResult).setSourceFileName(source);
    }

    @Override
    public void visitOuterClass(String owner, String name, String desc) {
        if (this.myParent instanceof PsiFileStub) {
            throw new OutOfOrderInnerClassException();
        }
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return new AnnotationTextCollector(desc, this.myMapping, new Consumer<String>(){

            @Override
            public void consume(String text) {
                new PsiAnnotationStubImpl((StubElement)StubBuildingVisitor.this.myModList, text);
            }
        });
    }

    @Override
    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        T innerClass;
        if ((access & 0x1000) != 0) {
            return;
        }
        if (innerName == null || outerName == null) {
            return;
        }
        if (this.myParent instanceof PsiFileStub && this.myInternalName.equals(name)) {
            throw new OutOfOrderInnerClassException();
        }
        if (this.myInternalName.equals(outerName) && (innerClass = this.myInnersStrategy.findInnerClass(innerName, this.mySource)) != null) {
            this.myInnersStrategy.accept(innerClass, new StubBuildingVisitor<T>(innerClass, this.myInnersStrategy, this.myResult, access, innerName));
        }
    }

    @Override
    @Nullable
    public FieldVisitor visitField(int access, String name, String desc, String signature2, Object value) {
        if ((access & 0x1000) != 0) {
            return null;
        }
        if (name == null) {
            return null;
        }
        byte flags = PsiFieldStubImpl.packFlags((access & 0x4000) != 0, (access & 0x20000) != 0, false, false);
        TypeInfo type2 = this.fieldType(desc, signature2);
        String initializer2 = StubBuildingVisitor.constToString(value, type2.text, false, this.myMapping);
        PsiFieldStubImpl stub = new PsiFieldStubImpl((StubElement)this.myResult, name, type2, initializer2, flags);
        PsiModifierListStubImpl modList = new PsiModifierListStubImpl((StubElement)stub, StubBuildingVisitor.packFieldFlags(access));
        return new AnnotationCollectingVisitor(modList, this.myMapping);
    }

    private TypeInfo fieldType(String desc, String signature2) {
        String type2;
        block4: {
            type2 = null;
            if (signature2 != null) {
                try {
                    type2 = SignatureParsing.parseTypeString(new StringCharacterIterator(signature2), this.myMapping);
                }
                catch (ClsFormatException e) {
                    if (!LOG.isDebugEnabled()) break block4;
                    LOG.debug("source=" + this.mySource + " signature=" + signature2, e);
                }
            }
        }
        if (type2 == null) {
            type2 = StubBuildingVisitor.toJavaType(Type.getType(desc), this.myMapping);
        }
        return TypeInfo.fromString(type2, false);
    }

    @Override
    @Nullable
    public MethodVisitor visitMethod(int access, String name, String desc, String signature2, String[] exceptions) {
        int localVarIgnoreCount;
        boolean generic;
        MethodInfo info;
        String canonicalMethodName;
        byte flags;
        boolean isStatic;
        boolean isVarargs;
        boolean isConstructor;
        boolean isEnum;
        block13: {
            if ((access & 0x1000) != 0) {
                return null;
            }
            if (name == null) {
                return null;
            }
            if ("<clinit>".equals(name)) {
                return null;
            }
            isEnum = this.myResult.isEnum();
            if (isEnum) {
                if ("values".equals(name) && desc.startsWith("()")) {
                    return null;
                }
                if ("valueOf".equals(name) && desc.startsWith("(Ljava/lang/String;)")) {
                    return null;
                }
            }
            isConstructor = "<init>".equals(name);
            boolean isDeprecated = (access & 0x20000) != 0;
            isVarargs = (access & 0x80) != 0;
            isStatic = (access & 8) != 0;
            boolean isAnnotationMethod = this.myResult.isAnnotationType();
            flags = PsiMethodStubImpl.packFlags(isConstructor, isAnnotationMethod, isVarargs, isDeprecated, false, false);
            canonicalMethodName = isConstructor ? this.myResult.getName() : name;
            info = null;
            generic = false;
            if (signature2 != null) {
                try {
                    info = this.parseMethodSignature(signature2, exceptions);
                    generic = true;
                }
                catch (ClsFormatException e) {
                    if (!LOG.isDebugEnabled()) break block13;
                    LOG.debug("source=" + this.mySource + " signature=" + signature2, e);
                }
            }
        }
        if (info == null) {
            info = this.parseMethodDescription(desc, exceptions);
        }
        PsiMethodStubImpl stub = new PsiMethodStubImpl(this.myResult, canonicalMethodName, TypeInfo.fromString(info.returnType, false), flags, null);
        PsiModifierListStubImpl modList = new PsiModifierListStubImpl((StubElement)stub, StubBuildingVisitor.packMethodFlags(access, this.myResult.isInterface()));
        PsiTypeParameterListStubImpl list2 = new PsiTypeParameterListStubImpl(stub);
        for (Pair parameter : info.typeParameters) {
            PsiTypeParameterStubImpl parameterStub = new PsiTypeParameterStubImpl((StubElement)list2, StringRef.fromString((String)parameter.first));
            StubBuildingVisitor.newReferenceList(JavaStubElementTypes.EXTENDS_BOUND_LIST, parameterStub, (String[])parameter.second);
        }
        boolean isEnumConstructor = isEnum && isConstructor;
        boolean isInnerClassConstructor = isConstructor && !(this.myParent instanceof PsiFileStub) && (this.myModList.getModifiersMask() & 8) == 0;
        List args = info.argTypes;
        if (!generic && isEnumConstructor && args.size() >= 2 && "java.lang.String".equals(args.get(0)) && "int".equals(args.get(1))) {
            args = args.subList(2, args.size());
        }
        PsiParameterListStubImpl parameterList = new PsiParameterListStubImpl(stub);
        int paramCount = args.size();
        PsiParameterStubImpl[] paramStubs = new PsiParameterStubImpl[paramCount];
        for (int i = 0; i < paramCount; ++i) {
            PsiParameterStubImpl parameterStub;
            if (i == 0 && !generic && isInnerClassConstructor) continue;
            String arg = (String)args.get(i);
            boolean isEllipsisParam = isVarargs && i == paramCount - 1;
            TypeInfo typeInfo = TypeInfo.fromString(arg, isEllipsisParam);
            String paramName = i < parameterNames.length ? parameterNames[i] : "p" + (i + 1);
            paramStubs[i] = parameterStub = new PsiParameterStubImpl((StubElement)parameterList, paramName, typeInfo, isEllipsisParam);
            new PsiModifierListStubImpl((StubElement)parameterStub, 0);
        }
        StubBuildingVisitor.newReferenceList(JavaStubElementTypes.THROWS_LIST, stub, ArrayUtil.toStringArray(info.throwTypes));
        int n = isStatic ? 0 : (localVarIgnoreCount = isEnumConstructor ? 3 : 1);
        int paramIgnoreCount = isEnumConstructor ? 2 : (isInnerClassConstructor ? 1 : 0);
        return new AnnotationParamCollectingVisitor(stub, modList, localVarIgnoreCount, paramIgnoreCount, paramCount, paramStubs, this.myMapping);
    }

    private MethodInfo parseMethodSignature(String signature2, String[] exceptions) throws ClsFormatException {
        MethodInfo result2 = new MethodInfo();
        StringCharacterIterator iterator2 = new StringCharacterIterator(signature2);
        result2.typeParameters = SignatureParsing.parseTypeParametersDeclaration(iterator2, this.myMapping);
        if (iterator2.current() != '(') {
            throw new ClsFormatException();
        }
        iterator2.next();
        if (iterator2.current() == ')') {
            result2.argTypes = ContainerUtil.emptyList();
        } else {
            result2.argTypes = ContainerUtil.newSmartList();
            while (iterator2.current() != ')' && iterator2.current() != '\uffff') {
                result2.argTypes.add(SignatureParsing.parseTypeString(iterator2, this.myMapping));
            }
            if (iterator2.current() != ')') {
                throw new ClsFormatException();
            }
        }
        iterator2.next();
        result2.returnType = SignatureParsing.parseTypeString(iterator2, this.myMapping);
        result2.throwTypes = null;
        while (iterator2.current() == '^') {
            iterator2.next();
            if (result2.throwTypes == null) {
                result2.throwTypes = ContainerUtil.newSmartList();
            }
            result2.throwTypes.add(SignatureParsing.parseTypeString(iterator2, this.myMapping));
        }
        if (exceptions != null && (result2.throwTypes == null || exceptions.length > result2.throwTypes.size())) {
            result2.throwTypes = ContainerUtil.map(exceptions, new Function<String, String>(){

                @Override
                public String fun(String name) {
                    return (String)StubBuildingVisitor.this.myMapping.fun(name);
                }
            });
        }
        return result2;
    }

    private MethodInfo parseMethodDescription(String desc, String[] exceptions) {
        MethodInfo result2 = new MethodInfo();
        result2.typeParameters = ContainerUtil.emptyList();
        result2.returnType = StubBuildingVisitor.toJavaType(Type.getReturnType(desc), this.myMapping);
        result2.argTypes = ContainerUtil.map(Type.getArgumentTypes(desc), new Function<Type, String>(){

            @Override
            public String fun(Type type2) {
                return StubBuildingVisitor.toJavaType(type2, StubBuildingVisitor.this.myMapping);
            }
        });
        result2.throwTypes = exceptions == null ? null : ContainerUtil.map(exceptions, new Function<String, String>(){

            @Override
            public String fun(String name) {
                return (String)StubBuildingVisitor.this.myMapping.fun(name);
            }
        });
        return result2;
    }

    @Nullable
    private static String constToString(@Nullable Object value, @Nullable String type2, boolean anno, Function<String, String> mapping) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return "\"" + StringUtil.escapeStringCharacters((String)value) + "\"";
        }
        if (value instanceof Boolean || value instanceof Short || value instanceof Byte) {
            return value.toString();
        }
        if (value instanceof Character) {
            return "'" + StringUtil.escapeCharCharacters(value.toString()) + "'";
        }
        if (value instanceof Long) {
            return value.toString() + 'L';
        }
        if (value instanceof Integer) {
            if ("boolean".equals(type2)) {
                if (value.equals(0)) {
                    return "false";
                }
                if (value.equals(1)) {
                    return "true";
                }
            }
            if ("char".equals(type2)) {
                char ch = (char)((Integer)value).intValue();
                return "'" + StringUtil.escapeCharCharacters(String.valueOf(ch)) + "'";
            }
            return value.toString();
        }
        if (value instanceof Double) {
            double d = (Double)value;
            if (Double.isInfinite(d)) {
                return d > 0.0 ? "1.0 / 0.0" : "-1.0 / 0.0";
            }
            if (Double.isNaN(d)) {
                return "0.0d / 0.0";
            }
            return Double.toString(d);
        }
        if (value instanceof Float) {
            float v = ((Float)value).floatValue();
            if (Float.isInfinite(v)) {
                return v > 0.0f ? "1.0f / 0.0" : "-1.0f / 0.0";
            }
            if (Float.isNaN(v)) {
                return "0.0f / 0.0";
            }
            return Float.toString(v) + 'f';
        }
        if (value.getClass().isArray()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append('{');
            int length = Array.getLength(value);
            for (int i = 0; i < length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(StubBuildingVisitor.constToString(Array.get(value, i), type2, anno, mapping));
            }
            buffer.append('}');
            return buffer.toString();
        }
        if (anno && value instanceof Type) {
            return StubBuildingVisitor.toJavaType((Type)value, mapping) + ".class";
        }
        return null;
    }

    private static String toJavaType(Type type2, Function<String, String> mapping) {
        String text;
        int dimensions = 0;
        if (type2.getSort() == 9) {
            dimensions = type2.getDimensions();
            type2 = type2.getElementType();
        }
        String string = text = type2.getSort() == 10 ? mapping.fun(type2.getInternalName()) : type2.getClassName();
        if (dimensions > 0) {
            text = text + StringUtil.repeat("[]", dimensions);
        }
        return text;
    }

    private static Function<String, String> createMapping(Object classSource) {
        if (classSource instanceof VirtualFile) {
            final HashMap mapping = ContainerUtil.newHashMap();
            try {
                byte[] bytes = ((VirtualFile)classSource).contentsToByteArray(false);
                new ClassReader(bytes).accept(new ClassVisitor(327680){

                    @Override
                    public void visitInnerClass(String name, String outerName, String innerName, int access) {
                        if (outerName != null && innerName != null) {
                            mapping.put(name, Pair.pair(outerName, innerName));
                        }
                    }
                }, ClsFileImpl.EMPTY_ATTRIBUTES, 7);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!mapping.isEmpty()) {
                return new Function<String, String>(){

                    @Override
                    public String fun(String internalName) {
                        String className2 = internalName;
                        if (className2.indexOf(36) >= 0) {
                            Pair p = (Pair)mapping.get(className2);
                            if (p == null) {
                                return GUESSING_MAPPER.fun(className2);
                            }
                            className2 = (String)p.first;
                            if (p.second != null) {
                                className2 = this.fun((String)p.first) + '.' + (String)p.second;
                                mapping.put(className2, Pair.pair(className2, null));
                            }
                        }
                        return className2.replace('/', '.');
                    }
                };
            }
        }
        return GUESSING_MAPPER;
    }

    private static class AnnotationParamCollectingVisitor
    extends MethodVisitor {
        private final PsiMethodStub myOwner;
        private final PsiModifierListStub myModList;
        private final int myIgnoreCount;
        private final int myParamIgnoreCount;
        private final int myParamCount;
        private final PsiParameterStubImpl[] myParamStubs;
        private final Function<String, String> myMapping;
        private int myUsedParamSize = 0;
        private int myUsedParamCount = 0;

        private AnnotationParamCollectingVisitor(PsiMethodStub owner, PsiModifierListStub modList, int ignoreCount, int paramIgnoreCount, int paramCount, PsiParameterStubImpl[] paramStubs, Function<String, String> mapping) {
            super(327680);
            this.myOwner = owner;
            this.myModList = modList;
            this.myIgnoreCount = ignoreCount;
            this.myParamIgnoreCount = paramIgnoreCount;
            this.myParamCount = paramCount;
            this.myParamStubs = paramStubs;
            this.myMapping = mapping;
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return new AnnotationTextCollector(desc, this.myMapping, new Consumer<String>(){

                @Override
                public void consume(String text) {
                    new PsiAnnotationStubImpl((StubElement)AnnotationParamCollectingVisitor.this.myModList, text);
                }
            });
        }

        @Override
        public AnnotationVisitor visitAnnotationDefault() {
            return new AnnotationTextCollector(null, this.myMapping, new Consumer<String>(){

                @Override
                public void consume(String text) {
                    ((PsiMethodStubImpl)AnnotationParamCollectingVisitor.this.myOwner).setDefaultValueText(text);
                }
            });
        }

        @Override
        public void visitLocalVariable(String name, String desc, String signature2, Label start, Label end, int index2) {
            if (index2 >= this.myIgnoreCount) {
                PsiParameterStubImpl parameterStub;
                int paramIndex;
                int n = paramIndex = index2 - this.myIgnoreCount == this.myUsedParamSize ? this.myUsedParamCount : index2 - this.myIgnoreCount;
                if (paramIndex >= this.myParamCount) {
                    return;
                }
                if (ClsParsingUtil.isJavaIdentifier(name, LanguageLevel.HIGHEST) && (parameterStub = this.myParamStubs[paramIndex]) != null) {
                    parameterStub.setName(name);
                }
                this.myUsedParamCount = paramIndex + 1;
                this.myUsedParamSize += "D".equals(desc) || "J".equals(desc) ? 2 : 1;
            }
        }

        @Override
        @Nullable
        public AnnotationVisitor visitParameterAnnotation(final int parameter, String desc, boolean visible) {
            return parameter < this.myParamIgnoreCount ? null : new AnnotationTextCollector(desc, this.myMapping, new Consumer<String>(){

                @Override
                public void consume(String text) {
                    new PsiAnnotationStubImpl((StubElement)AnnotationParamCollectingVisitor.this.myOwner.findParameter(parameter - AnnotationParamCollectingVisitor.this.myParamIgnoreCount).getModList(), text);
                }
            });
        }
    }

    private static class AnnotationCollectingVisitor
    extends FieldVisitor {
        private final PsiModifierListStub myModList;
        private final Function<String, String> myMapping;

        private AnnotationCollectingVisitor(PsiModifierListStub modList, Function<String, String> mapping) {
            super(327680);
            this.myModList = modList;
            this.myMapping = mapping;
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return new AnnotationTextCollector(desc, this.myMapping, new Consumer<String>(){

                @Override
                public void consume(String text) {
                    new PsiAnnotationStubImpl((StubElement)AnnotationCollectingVisitor.this.myModList, text);
                }
            });
        }
    }

    private static class AnnotationTextCollector
    extends AnnotationVisitor {
        private final StringBuilder myBuilder = new StringBuilder();
        private final Function<String, String> myMapping;
        private final Consumer<String> myCallback;
        private boolean hasPrefix = false;
        private boolean hasParams = false;

        public AnnotationTextCollector(@Nullable String desc, Function<String, String> mapping, Consumer<String> callback) {
            super(327680);
            this.myMapping = mapping;
            this.myCallback = callback;
            if (desc != null) {
                this.hasPrefix = true;
                this.myBuilder.append('@').append(StubBuildingVisitor.toJavaType(Type.getType(desc), this.myMapping));
            }
        }

        @Override
        public void visit(String name, Object value) {
            this.valuePairPrefix(name);
            this.myBuilder.append(StubBuildingVisitor.constToString(value, null, true, this.myMapping));
        }

        @Override
        public void visitEnum(String name, String desc, String value) {
            this.valuePairPrefix(name);
            this.myBuilder.append(StubBuildingVisitor.toJavaType(Type.getType(desc), this.myMapping)).append('.').append(value);
        }

        private void valuePairPrefix(String name) {
            if (!this.hasParams) {
                this.hasParams = true;
                if (this.hasPrefix) {
                    this.myBuilder.append('(');
                }
            } else {
                this.myBuilder.append(',');
            }
            if (name != null) {
                this.myBuilder.append(name).append('=');
            }
        }

        @Override
        public AnnotationVisitor visitAnnotation(String name, String desc) {
            this.valuePairPrefix(name);
            return new AnnotationTextCollector(desc, this.myMapping, new Consumer<String>(){

                @Override
                public void consume(String text) {
                    AnnotationTextCollector.this.myBuilder.append(text);
                }
            });
        }

        @Override
        public AnnotationVisitor visitArray(String name) {
            this.valuePairPrefix(name);
            this.myBuilder.append('{');
            return new AnnotationTextCollector(null, this.myMapping, new Consumer<String>(){

                @Override
                public void consume(String text) {
                    AnnotationTextCollector.this.myBuilder.append(text).append('}');
                }
            });
        }

        @Override
        public void visitEnd() {
            if (this.hasPrefix && this.hasParams) {
                this.myBuilder.append(')');
            }
            this.myCallback.consume(this.myBuilder.toString());
        }
    }

    private static class MethodInfo {
        private List<Pair<String, String[]>> typeParameters;
        private String returnType;
        private List<String> argTypes;
        private List<String> throwTypes;

        private MethodInfo() {
        }
    }

    private static class ClassInfo {
        private List<Pair<String, String[]>> typeParameters;
        private String superName;
        private List<String> interfaceNames;

        private ClassInfo() {
        }
    }
}

