/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resolve.result;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.resolve.ArtifactResolveException;
import org.gradle.internal.resolve.result.BuildableArtifactSetResolveResult;

public class DefaultBuildableArtifactSetResolveResult
implements BuildableArtifactSetResolveResult {
    private ArtifactResolveException failure;
    private Set<ComponentArtifactMetadata> artifacts;

    @Override
    public void resolved(Collection<? extends ComponentArtifactMetadata> artifacts) {
        this.artifacts = new LinkedHashSet<ComponentArtifactMetadata>(artifacts);
    }

    @Override
    public void failed(ArtifactResolveException failure) {
        this.failure = failure;
    }

    @Override
    public boolean hasResult() {
        return this.artifacts != null || this.failure != null;
    }

    @Override
    public ArtifactResolveException getFailure() {
        this.assertHasResult();
        return this.failure;
    }

    @Override
    public Set<ComponentArtifactMetadata> getArtifacts() {
        this.assertResolved();
        return this.artifacts;
    }

    private void assertResolved() {
        this.assertHasResult();
        if (this.failure != null) {
            throw this.failure;
        }
    }

    private void assertHasResult() {
        if (!this.hasResult()) {
            throw new IllegalStateException("No result has been specified.");
        }
    }
}

