/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.model;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentSelector;
import org.gradle.api.internal.artifacts.DefaultModuleVersionSelector;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.Exclude;
import org.gradle.internal.component.model.IvyArtifactName;

public class LocalComponentDependencyMetadata
implements DependencyMetadata {
    private final ComponentSelector selector;
    private final ModuleVersionSelector requested;
    private final String moduleConfiguration;
    private final String dependencyConfiguration;
    private final List<Exclude> excludes;
    private final Set<IvyArtifactName> artifactNames;
    private final boolean force;
    private final boolean changing;
    private final boolean transitive;

    public LocalComponentDependencyMetadata(ComponentSelector selector, ModuleVersionSelector requested, String moduleConfiguration, String dependencyConfiguration, Set<IvyArtifactName> artifactNames, List<Exclude> excludes, boolean force, boolean changing, boolean transitive) {
        this.selector = selector;
        this.requested = requested;
        this.moduleConfiguration = moduleConfiguration;
        this.dependencyConfiguration = dependencyConfiguration;
        this.artifactNames = artifactNames;
        this.excludes = excludes;
        this.force = force;
        this.changing = changing;
        this.transitive = transitive;
    }

    public String toString() {
        return "dependency: " + this.requested + " " + this.moduleConfiguration;
    }

    @Override
    public ModuleVersionSelector getRequested() {
        return this.requested;
    }

    @Override
    public ComponentSelector getSelector() {
        return this.selector;
    }

    @Override
    public String[] getModuleConfigurations() {
        return new String[]{this.moduleConfiguration};
    }

    @Override
    public String[] getDependencyConfigurations(String moduleConfiguration, String requestedConfiguration) {
        if (this.moduleConfiguration.equals(moduleConfiguration)) {
            return new String[]{this.dependencyConfiguration};
        }
        return new String[0];
    }

    @Override
    public List<Exclude> getExcludes(Collection<String> configurations) {
        if (configurations.contains(this.moduleConfiguration)) {
            return this.excludes;
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isChanging() {
        return this.changing;
    }

    @Override
    public boolean isTransitive() {
        return this.transitive;
    }

    @Override
    public boolean isForce() {
        return this.force;
    }

    @Override
    public String getDynamicConstraintVersion() {
        return this.requested.getVersion();
    }

    @Override
    public Set<ComponentArtifactMetadata> getArtifacts(ConfigurationMetadata fromConfiguration, ConfigurationMetadata toConfiguration) {
        if (this.artifactNames.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<ComponentArtifactMetadata> artifacts = new LinkedHashSet<ComponentArtifactMetadata>();
        for (IvyArtifactName artifactName : this.artifactNames) {
            artifacts.add(toConfiguration.artifact(artifactName));
        }
        return artifacts;
    }

    @Override
    public Set<IvyArtifactName> getArtifacts() {
        return this.artifactNames;
    }

    @Override
    public DependencyMetadata withRequestedVersion(String requestedVersion) {
        if (requestedVersion.equals(this.requested.getVersion())) {
            return this;
        }
        ModuleVersionSelector newRequested = DefaultModuleVersionSelector.newSelector(this.requested.getGroup(), this.requested.getName(), requestedVersion);
        ModuleComponentSelector newSelector = DefaultModuleComponentSelector.newSelector(newRequested);
        return this.copyWithTarget((ComponentSelector)newSelector, newRequested);
    }

    @Override
    public DependencyMetadata withTarget(ComponentSelector target) {
        if (target instanceof ModuleComponentSelector) {
            ModuleComponentSelector moduleTarget = (ModuleComponentSelector)target;
            ModuleVersionSelector requestedVersion = DefaultModuleVersionSelector.newSelector(moduleTarget.getGroup(), moduleTarget.getModule(), moduleTarget.getVersion());
            return this.copyWithTarget((ComponentSelector)moduleTarget, requestedVersion);
        }
        if (target instanceof ProjectComponentSelector) {
            return this.copyWithTarget(target, this.requested);
        }
        throw new AssertionError((Object)("Invalid component selector type for substitution: " + target));
    }

    private DependencyMetadata copyWithTarget(ComponentSelector selector, ModuleVersionSelector requested) {
        return new LocalComponentDependencyMetadata(selector, requested, this.moduleConfiguration, this.dependencyConfiguration, this.artifactNames, this.excludes, this.force, this.changing, this.transitive);
    }

    @Override
    public DependencyMetadata withChanging() {
        if (this.isChanging()) {
            return this;
        }
        return new LocalComponentDependencyMetadata(this.selector, this.requested, this.moduleConfiguration, this.dependencyConfiguration, this.artifactNames, this.excludes, this.force, true, this.transitive);
    }
}

