/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.gradle.api.Nullable;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.internal.component.external.descriptor.ModuleDescriptorState;
import org.gradle.internal.component.external.model.AbstractModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.MavenModuleResolveMetadata;
import org.gradle.internal.component.model.IvyArtifactName;

public class DefaultMavenModuleResolveMetadata
extends AbstractModuleComponentResolveMetadata
implements MavenModuleResolveMetadata {
    private static final String POM_PACKAGING = "pom";
    private static final Collection<String> JAR_PACKAGINGS = Arrays.asList("ejb", "bundle", "maven-plugin", "eclipse-plugin");
    private final String packaging;
    private final boolean relocated;
    private String snapshotTimestamp;

    public DefaultMavenModuleResolveMetadata(ModuleComponentIdentifier componentIdentifier, Set<IvyArtifactName> artifacts) {
        this(componentIdentifier, DefaultMavenModuleResolveMetadata.createModuleDescriptor(componentIdentifier, artifacts), "jar", false);
    }

    public DefaultMavenModuleResolveMetadata(ModuleDescriptorState moduleDescriptor, String packaging, boolean relocated) {
        this(moduleDescriptor.getComponentIdentifier(), moduleDescriptor, packaging, relocated);
    }

    public DefaultMavenModuleResolveMetadata(ModuleComponentIdentifier componentId, ModuleDescriptorState descriptor, String packaging, boolean relocated) {
        this(componentId, DefaultModuleVersionIdentifier.newId(componentId), descriptor, packaging, relocated);
    }

    private DefaultMavenModuleResolveMetadata(ModuleComponentIdentifier componentId, ModuleVersionIdentifier id, ModuleDescriptorState moduleDescriptor, String packaging, boolean relocated) {
        super(componentId, id, moduleDescriptor);
        this.packaging = packaging;
        this.relocated = relocated;
    }

    @Override
    public DefaultMavenModuleResolveMetadata copy() {
        DefaultMavenModuleResolveMetadata copy = new DefaultMavenModuleResolveMetadata(this.getComponentId(), this.getId(), this.getDescriptor(), this.packaging, this.relocated);
        this.copyTo(copy);
        copy.snapshotTimestamp = this.snapshotTimestamp;
        return copy;
    }

    @Override
    public String getPackaging() {
        return this.packaging;
    }

    @Override
    public boolean isRelocated() {
        return this.relocated;
    }

    @Override
    public boolean isPomPackaging() {
        return POM_PACKAGING.equals(this.packaging);
    }

    @Override
    public boolean isKnownJarPackaging() {
        return "jar".equals(this.packaging) || JAR_PACKAGINGS.contains(this.packaging);
    }

    public void setSnapshotTimestamp(@Nullable String snapshotTimestamp) {
        this.snapshotTimestamp = snapshotTimestamp;
    }

    @Override
    @Nullable
    public String getSnapshotTimestamp() {
        return this.snapshotTimestamp;
    }
}

