/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.descriptor;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.internal.component.external.descriptor.Artifact;
import org.gradle.internal.component.model.Exclude;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.util.CollectionUtils;

public class Dependency {
    private final ModuleVersionSelector requested;
    private final String dynamicConstraintVersion;
    private final boolean force;
    private final boolean changing;
    private final boolean transitive;
    private final Map<String, List<String>> confMappings = Maps.newLinkedHashMap();
    private final List<Artifact> dependencyArtifacts = Lists.newArrayList();
    private final List<Exclude> dependencyExcludes = Lists.newArrayList();

    public Dependency(ModuleVersionSelector requested, String dynamicConstraintVersion, boolean force, boolean changing, boolean transitive) {
        this.requested = requested;
        this.dynamicConstraintVersion = dynamicConstraintVersion;
        this.force = force;
        this.changing = changing;
        this.transitive = transitive;
    }

    public void addArtifact(IvyArtifactName newArtifact, Collection<String> configurations) {
        Artifact artifact = new Artifact(newArtifact, CollectionUtils.toSet(configurations));
        this.dependencyArtifacts.add(artifact);
    }

    public void addDependencyConfiguration(String from, String to) {
        ArrayList mappings = this.confMappings.get(from);
        if (mappings == null) {
            mappings = Lists.newArrayList();
            this.confMappings.put(from, mappings);
        }
        if (!mappings.contains(to)) {
            mappings.add(to);
        }
    }

    public void addDependencyConfiguration(String from, List<String> to) {
        this.confMappings.put(from, to);
    }

    public void addExcludeRule(Exclude rule) {
        this.dependencyExcludes.add(rule);
    }

    public ModuleVersionSelector getRequested() {
        return this.requested;
    }

    public boolean isForce() {
        return this.force;
    }

    public boolean isChanging() {
        return this.changing;
    }

    public boolean isTransitive() {
        return this.transitive;
    }

    public Map<String, List<String>> getConfMappings() {
        return this.confMappings;
    }

    public List<Artifact> getDependencyArtifacts() {
        return this.dependencyArtifacts;
    }

    public List<Exclude> getDependencyExcludes() {
        return this.dependencyExcludes;
    }

    public String getDynamicConstraintVersion() {
        return this.dynamicConstraintVersion;
    }
}

