/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.runtimeshaded;

import java.io.Closeable;
import java.io.File;
import java.util.Collection;
import org.gradle.api.internal.runtimeshaded.RuntimeShadedJarCreator;
import org.gradle.api.internal.runtimeshaded.RuntimeShadedJarType;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.FileLockManager;
import org.gradle.cache.internal.filelock.LockOptions;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeShadedJarFactory
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(RuntimeShadedJarFactory.class);
    public static final String CACHE_KEY = "generated-gradle-jars";
    public static final String CACHE_DISPLAY_NAME = "Generated Gradle JARs cache";
    private final String gradleVersion;
    private final PersistentCache cache;
    private final RuntimeShadedJarCreator creator;

    public RuntimeShadedJarFactory(CacheRepository cacheRepository, ProgressLoggerFactory progressLoggerFactory, String gradleVersion) {
        this.creator = new RuntimeShadedJarCreator(progressLoggerFactory);
        this.gradleVersion = gradleVersion;
        this.cache = cacheRepository.cache(CACHE_KEY).withDisplayName(CACHE_DISPLAY_NAME).withLockOptions((LockOptions)LockOptionsBuilder.mode((FileLockManager.LockMode)FileLockManager.LockMode.None)).open();
    }

    public File get(RuntimeShadedJarType type, final Collection<? extends File> classpath) {
        final File jarFile = this.jarFile(this.cache, type);
        if (!jarFile.exists()) {
            this.cache.useCache("Generating " + jarFile.getName(), new Runnable(){

                @Override
                public void run() {
                    if (!jarFile.exists()) {
                        RuntimeShadedJarFactory.this.creator.create(jarFile, classpath);
                    }
                }
            });
        }
        LOGGER.debug("Using Gradle runtime shaded JAR file: {}", (Object)jarFile);
        return jarFile;
    }

    @Override
    public void close() {
        this.cache.close();
    }

    private File jarFile(PersistentCache cache, RuntimeShadedJarType type) {
        return new File(cache.getBaseDir(), "gradle-" + type.getIdentifier() + "-" + this.gradleVersion + ".jar");
    }
}

