/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.result.ComponentSelectionReason;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.ResolveContext;
import org.gradle.api.internal.artifacts.ResolvedConfigurationIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ComponentResolutionState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.DependencyToConfigurationResolver;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ModuleConflictResolver;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleExclusion;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleExclusions;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphEdge;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphNode;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.CandidateModule;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.ConflictHandler;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.ConflictResolutionResult;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.PotentialConflict;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ModuleVersionSelection;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.VersionSelectionReasons;
import org.gradle.internal.Cast;
import org.gradle.internal.component.local.model.DslOriginDependencyMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.DefaultComponentOverrideMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.resolve.resolver.ComponentMetaDataResolver;
import org.gradle.internal.resolve.resolver.DependencyToComponentIdResolver;
import org.gradle.internal.resolve.resolver.ResolveContextToComponentResolver;
import org.gradle.internal.resolve.result.BuildableComponentIdResolveResult;
import org.gradle.internal.resolve.result.ComponentResolveResult;
import org.gradle.internal.resolve.result.DefaultBuildableComponentIdResolveResult;
import org.gradle.internal.resolve.result.DefaultBuildableComponentResolveResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependencyGraphBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(DependencyGraphBuilder.class);
    private final DependencyToConfigurationResolver dependencyToConfigurationResolver;
    private final ConflictHandler conflictHandler;
    private final ResolveContextToComponentResolver moduleResolver;
    private final DependencyToComponentIdResolver idResolver;
    private final ComponentMetaDataResolver metaDataResolver;

    public DependencyGraphBuilder(DependencyToComponentIdResolver componentIdResolver, ComponentMetaDataResolver componentMetaDataResolver, ResolveContextToComponentResolver resolveContextToComponentResolver, DependencyToConfigurationResolver dependencyToConfigurationResolver, ConflictHandler conflictHandler) {
        this.idResolver = componentIdResolver;
        this.metaDataResolver = componentMetaDataResolver;
        this.moduleResolver = resolveContextToComponentResolver;
        this.conflictHandler = conflictHandler;
        this.dependencyToConfigurationResolver = dependencyToConfigurationResolver;
    }

    public void resolve(ResolveContext resolveContext, DependencyGraphVisitor modelVisitor) {
        DefaultBuildableComponentResolveResult rootModule = new DefaultBuildableComponentResolveResult();
        this.moduleResolver.resolve(resolveContext, rootModule);
        ResolveState resolveState = new ResolveState(rootModule, resolveContext.getName(), this.idResolver, this.metaDataResolver, this.dependencyToConfigurationResolver);
        this.conflictHandler.registerResolver(new DirectDependencyForcingResolver(((ResolveState)resolveState).root.moduleRevision));
        this.traverseGraph(resolveState, this.conflictHandler);
        this.assembleResult(resolveState, modelVisitor);
    }

    private void traverseGraph(final ResolveState resolveState, ConflictHandler conflictHandler) {
        resolveState.onMoreSelected(resolveState.root);
        ArrayList<DependencyEdge> dependencies = new ArrayList<DependencyEdge>();
        while (resolveState.peek() != null || conflictHandler.hasConflicts()) {
            if (resolveState.peek() != null) {
                ConfigurationNode node = resolveState.pop();
                LOGGER.debug("Visiting configuration {}.", (Object)node);
                dependencies.clear();
                node.visitOutgoingDependencies(dependencies);
                for (DependencyEdge dependency : dependencies) {
                    LOGGER.debug("Visiting dependency {}", (Object)dependency);
                    ModuleVersionResolveState moduleRevision = dependency.resolveModuleRevisionId();
                    if (moduleRevision == null) continue;
                    ModuleIdentifier moduleId = moduleRevision.id.getModule();
                    if (moduleRevision.state == ModuleState.New) {
                        ModuleResolveState module = resolveState.getModule(moduleId);
                        PotentialConflict c = conflictHandler.registerModule(module);
                        if (!c.conflictExists()) {
                            LOGGER.debug("Selecting new module version {}", (Object)moduleRevision);
                            module.select(moduleRevision);
                        } else {
                            LOGGER.debug("Found new conflicting module version {}", (Object)moduleRevision);
                            c.withParticipatingModules(new Action<ModuleIdentifier>(){

                                public void execute(ModuleIdentifier module) {
                                    ModuleVersionResolveState previouslySelected = resolveState.getModule(module).clearSelection();
                                    if (previouslySelected != null) {
                                        for (ConfigurationNode configuration : previouslySelected.configurations) {
                                            configuration.deselect();
                                        }
                                    }
                                }
                            });
                        }
                    }
                    dependency.attachToTargetConfigurations();
                }
                continue;
            }
            conflictHandler.resolveNextConflict(new Action<ConflictResolutionResult>(){

                public void execute(final ConflictResolutionResult result) {
                    result.getConflict().withParticipatingModules(new Action<ModuleIdentifier>(){

                        public void execute(ModuleIdentifier moduleIdentifier) {
                            ModuleVersionResolveState selected = (ModuleVersionResolveState)result.getSelected();
                            resolveState.getModule(moduleIdentifier).restart(selected);
                        }
                    });
                }
            });
        }
    }

    private void assembleResult(ResolveState resolveState, DependencyGraphVisitor listener) {
        listener.start(resolveState.root);
        for (ConfigurationNode resolvedConfiguration : resolveState.getConfigurationNodes()) {
            if (!resolvedConfiguration.isSelected()) continue;
            resolvedConfiguration.validate();
            listener.visitNode(resolvedConfiguration);
        }
        for (ConfigurationNode resolvedConfiguration : resolveState.getConfigurationNodes()) {
            if (!resolvedConfiguration.isSelected()) continue;
            listener.visitEdge(resolvedConfiguration);
        }
        listener.finish(resolveState.root);
    }

    private static class DirectDependencyForcingResolver
    implements ModuleConflictResolver {
        private final ModuleVersionResolveState root;

        private DirectDependencyForcingResolver(ModuleVersionResolveState root) {
            this.root = root;
        }

        @Override
        public <T extends ComponentResolutionState> T select(Collection<? extends T> candidates) {
            for (ConfigurationNode configuration : this.root.configurations) {
                for (DependencyEdge outgoingEdge : configuration.outgoingEdges) {
                    if (!outgoingEdge.dependencyMetadata.isForce() || !candidates.contains(outgoingEdge.targetModuleRevision)) continue;
                    outgoingEdge.targetModuleRevision.selectionReason = VersionSelectionReasons.FORCED;
                    return (T)outgoingEdge.targetModuleRevision;
                }
            }
            return null;
        }
    }

    private static class ModuleVersionSelectorResolveState {
        final DependencyMetadata dependencyMetadata;
        final DependencyToComponentIdResolver resolver;
        final ResolveState resolveState;
        ModuleVersionResolveException failure;
        ModuleResolveState targetModule;
        ModuleVersionResolveState targetModuleRevision;
        BuildableComponentIdResolveResult idResolveResult;

        private ModuleVersionSelectorResolveState(DependencyMetadata dependencyMetadata, DependencyToComponentIdResolver resolver, ResolveState resolveState) {
            this.dependencyMetadata = dependencyMetadata;
            this.resolver = resolver;
            this.resolveState = resolveState;
            this.targetModule = resolveState.getModule(new DefaultModuleIdentifier(dependencyMetadata.getRequested().getGroup(), dependencyMetadata.getRequested().getName()));
        }

        public String toString() {
            return this.dependencyMetadata.toString();
        }

        private ModuleVersionResolveException getFailure() {
            return this.failure != null ? this.failure : this.targetModuleRevision.getFailure();
        }

        public ComponentSelectionReason getSelectionReason() {
            return this.targetModuleRevision == null ? this.idResolveResult.getSelectionReason() : this.targetModuleRevision.getSelectionReason();
        }

        public ModuleVersionResolveState getSelected() {
            return this.targetModule.selected;
        }

        public ModuleResolveState getSelectedModule() {
            return this.targetModule;
        }

        public ModuleVersionResolveState resolveModuleRevisionId() {
            if (this.targetModuleRevision != null) {
                return this.targetModuleRevision;
            }
            if (this.failure != null) {
                return null;
            }
            this.idResolveResult = new DefaultBuildableComponentIdResolveResult();
            this.resolver.resolve(this.dependencyMetadata, this.idResolveResult);
            if (this.idResolveResult.getFailure() != null) {
                this.failure = this.idResolveResult.getFailure();
                return null;
            }
            this.targetModuleRevision = this.resolveState.getRevision(this.idResolveResult.getModuleVersionId());
            this.targetModuleRevision.addResolver(this);
            this.targetModuleRevision.selectionReason = this.idResolveResult.getSelectionReason();
            this.targetModule = this.targetModuleRevision.module;
            this.targetModule.addSelector(this);
            return this.targetModuleRevision;
        }

        public void restart(ModuleVersionResolveState moduleRevision) {
            this.targetModuleRevision = moduleRevision;
            this.targetModule = moduleRevision.module;
        }
    }

    private static class RootConfigurationNode
    extends ConfigurationNode {
        private RootConfigurationNode(ModuleVersionResolveState moduleRevision, ResolvedConfigurationIdentifier id, ResolveState resolveState) {
            super(id, moduleRevision, resolveState);
        }

        @Override
        public boolean isSelected() {
            return true;
        }

        @Override
        public void deselect() {
        }
    }

    static class ConfigurationNode
    implements DependencyGraphNode {
        public final ModuleVersionResolveState moduleRevision;
        public final Set<DependencyEdge> incomingEdges = new LinkedHashSet<DependencyEdge>();
        public final Set<DependencyEdge> outgoingEdges = new LinkedHashSet<DependencyEdge>();
        public final ResolvedConfigurationIdentifier id;
        private final ConfigurationMetadata metaData;
        private final ResolveState resolveState;
        private ModuleExclusion previousTraversalExclusions;

        private ConfigurationNode(ResolvedConfigurationIdentifier id, ModuleVersionResolveState moduleRevision, ResolveState resolveState) {
            this.id = id;
            this.moduleRevision = moduleRevision;
            this.resolveState = resolveState;
            this.metaData = moduleRevision.metaData.getConfiguration(id.getConfiguration());
            moduleRevision.addConfiguration(this);
        }

        @Override
        public ResolvedConfigurationIdentifier getNodeId() {
            return this.id;
        }

        @Override
        public ModuleVersionIdentifier toId() {
            return this.moduleRevision.id;
        }

        @Override
        public ComponentIdentifier getComponentId() {
            return this.moduleRevision.getComponentId();
        }

        @Override
        public ModuleVersionSelection getSelection() {
            return this.moduleRevision;
        }

        @Override
        public Set<DependencyGraphEdge> getIncomingEdges() {
            return (Set)Cast.uncheckedCast(this.incomingEdges);
        }

        @Override
        public Set<DependencyGraphEdge> getOutgoingEdges() {
            return (Set)Cast.uncheckedCast(this.outgoingEdges);
        }

        @Override
        public ConfigurationMetadata getMetaData() {
            return this.metaData;
        }

        public String toString() {
            return String.format("%s(%s)", this.id.getId(), this.id.getConfiguration());
        }

        public boolean isTransitive() {
            return this.metaData.isTransitive();
        }

        public void visitOutgoingDependencies(Collection<DependencyEdge> target) {
            if (this.moduleRevision.state != ModuleState.Selected) {
                LOGGER.debug("version for {} is not selected. ignoring.", (Object)this);
                return;
            }
            ArrayList<DependencyEdge> transitiveIncoming = new ArrayList<DependencyEdge>();
            for (DependencyEdge edge : this.incomingEdges) {
                if (!edge.isTransitive()) continue;
                transitiveIncoming.add(edge);
            }
            if (transitiveIncoming.isEmpty() && this != this.resolveState.root) {
                if (this.previousTraversalExclusions != null) {
                    this.removeOutgoingEdges();
                }
                if (this.incomingEdges.isEmpty()) {
                    LOGGER.debug("{} has no incoming edges. ignoring.", (Object)this);
                } else {
                    LOGGER.debug("{} has no transitive incoming edges. ignoring outgoing edges.", (Object)this);
                }
                return;
            }
            ModuleExclusion resolutionFilter = this.getModuleResolutionFilter(transitiveIncoming);
            if (this.previousTraversalExclusions != null) {
                if (this.previousTraversalExclusions.excludesSameModulesAs(resolutionFilter)) {
                    LOGGER.debug("Changed edges for {} selects same versions as previous traversal. ignoring", (Object)this);
                    this.previousTraversalExclusions = resolutionFilter;
                    return;
                }
                this.removeOutgoingEdges();
            }
            for (DependencyMetadata dependency : this.metaData.getDependencies()) {
                ModuleIdentifier targetModuleId = DefaultModuleIdentifier.newId(dependency.getRequested().getGroup(), dependency.getRequested().getName());
                if (this.isExcluded(resolutionFilter, targetModuleId)) continue;
                DependencyEdge dependencyEdge = new DependencyEdge(this, dependency, resolutionFilter, this.resolveState);
                this.outgoingEdges.add(dependencyEdge);
                target.add(dependencyEdge);
            }
            this.previousTraversalExclusions = resolutionFilter;
        }

        private boolean isExcluded(ModuleExclusion selector, ModuleIdentifier targetModuleId) {
            if (selector.excludeModule(targetModuleId)) {
                LOGGER.debug("{} is excluded from {}.", (Object)targetModuleId, (Object)this);
                return true;
            }
            return false;
        }

        public void addIncomingEdge(DependencyEdge dependencyEdge) {
            this.incomingEdges.add(dependencyEdge);
            this.resolveState.onMoreSelected(this);
        }

        public void removeIncomingEdge(DependencyEdge dependencyEdge) {
            this.incomingEdges.remove(dependencyEdge);
            this.resolveState.onFewerSelected(this);
        }

        public boolean isSelected() {
            return this.moduleRevision.state == ModuleState.Selected;
        }

        private ModuleExclusion getModuleResolutionFilter(List<DependencyEdge> transitiveEdges) {
            ModuleExclusion resolutionFilter;
            if (transitiveEdges.isEmpty()) {
                resolutionFilter = ModuleExclusions.excludeNone();
            } else {
                resolutionFilter = transitiveEdges.get(0).getExclusions();
                for (int i = 1; i < transitiveEdges.size(); ++i) {
                    DependencyEdge dependencyEdge = transitiveEdges.get(i);
                    resolutionFilter = ModuleExclusions.union(resolutionFilter, dependencyEdge.getExclusions());
                }
            }
            resolutionFilter = ModuleExclusions.intersect(resolutionFilter, ModuleExclusions.excludeAny(this.metaData.getExcludes()));
            return resolutionFilter;
        }

        public void removeOutgoingEdges() {
            for (DependencyEdge outgoingDependency : this.outgoingEdges) {
                outgoingDependency.removeFromTargetConfigurations();
            }
            this.outgoingEdges.clear();
            this.previousTraversalExclusions = null;
        }

        public void restart(ModuleVersionResolveState selected) {
            if (this.moduleRevision == selected) {
                this.resolveState.onMoreSelected(this);
            } else {
                for (DependencyEdge dependency : this.incomingEdges) {
                    dependency.restart(selected);
                }
                this.incomingEdges.clear();
            }
        }

        public void validate() {
            for (DependencyEdge incomingEdge : this.incomingEdges) {
                ConfigurationNode fromNode = incomingEdge.from;
                if (fromNode.isSelected()) continue;
                throw new IllegalStateException(String.format("Unexpected state %s for parent node for dependency from %s to %s.", new Object[]{fromNode.moduleRevision.state, fromNode, this}));
            }
        }

        public void deselect() {
            this.removeOutgoingEdges();
        }
    }

    public static class ModuleVersionResolveState
    implements ComponentResolutionState,
    ModuleVersionSelection {
        public final ModuleVersionIdentifier id;
        private final ComponentMetaDataResolver resolver;
        private final Set<ConfigurationNode> configurations = new LinkedHashSet<ConfigurationNode>();
        private final ModuleResolveState module;
        private ComponentResolveMetadata metaData;
        private ModuleState state = ModuleState.New;
        private ComponentSelectionReason selectionReason = VersionSelectionReasons.REQUESTED;
        private ModuleVersionResolveException failure;
        private ModuleVersionSelectorResolveState firstReference;

        private ModuleVersionResolveState(ModuleResolveState module, ModuleVersionIdentifier id, ComponentMetaDataResolver resolver) {
            this.module = module;
            this.id = id;
            this.resolver = resolver;
        }

        public String toString() {
            return this.id.toString();
        }

        @Override
        public String getVersion() {
            return this.id.getVersion();
        }

        @Override
        public ModuleVersionIdentifier getId() {
            return this.id;
        }

        public ModuleVersionResolveException getFailure() {
            return this.failure;
        }

        public void restart(ModuleVersionResolveState selected) {
            for (ConfigurationNode configuration : this.configurations) {
                configuration.restart(selected);
            }
        }

        public void addResolver(ModuleVersionSelectorResolveState resolver) {
            if (this.firstReference == null) {
                this.firstReference = resolver;
            }
        }

        public void resolve() {
            if (this.metaData != null || this.failure != null) {
                return;
            }
            BuildableComponentIdResolveResult idResolveResult = this.firstReference.idResolveResult;
            if (idResolveResult.getFailure() != null) {
                this.failure = idResolveResult.getFailure();
                return;
            }
            if (idResolveResult.getMetaData() != null) {
                this.metaData = idResolveResult.getMetaData();
                return;
            }
            DefaultBuildableComponentResolveResult result = new DefaultBuildableComponentResolveResult();
            this.resolver.resolve(idResolveResult.getId(), DefaultComponentOverrideMetadata.forDependency(this.firstReference.dependencyMetadata), result);
            if (result.getFailure() != null) {
                this.failure = result.getFailure();
                return;
            }
            this.metaData = result.getMetaData();
        }

        @Override
        public ComponentResolveMetadata getMetaData() {
            if (this.metaData == null) {
                this.resolve();
            }
            return this.metaData;
        }

        public void setMetaData(ComponentResolveMetadata metaData) {
            this.metaData = metaData;
            this.failure = null;
        }

        public void addConfiguration(ConfigurationNode configurationNode) {
            this.configurations.add(configurationNode);
        }

        @Override
        public ComponentSelectionReason getSelectionReason() {
            return this.selectionReason;
        }

        @Override
        public void setSelectionReason(ComponentSelectionReason reason) {
            this.selectionReason = reason;
        }

        @Override
        public ComponentIdentifier getComponentId() {
            return this.getMetaData().getComponentId();
        }

        public List<ModuleVersionResolveState> getIncoming() {
            ArrayList<ModuleVersionResolveState> incoming = new ArrayList<ModuleVersionResolveState>();
            for (ConfigurationNode configuration : this.configurations) {
                for (DependencyEdge dependencyEdge : configuration.incomingEdges) {
                    incoming.add(dependencyEdge.from.moduleRevision);
                }
            }
            return incoming;
        }
    }

    private static class ModuleResolveState
    implements CandidateModule {
        final ComponentMetaDataResolver metaDataResolver;
        final ModuleIdentifier id;
        final Set<DependencyEdge> unattachedDependencies = new LinkedHashSet<DependencyEdge>();
        final Map<ModuleVersionIdentifier, ModuleVersionResolveState> versions = new LinkedHashMap<ModuleVersionIdentifier, ModuleVersionResolveState>();
        final Set<ModuleVersionSelectorResolveState> selectors = new HashSet<ModuleVersionSelectorResolveState>();
        final ResolveState resolveState;
        ModuleVersionResolveState selected;

        private ModuleResolveState(ModuleIdentifier id, ResolveState resolveState, ComponentMetaDataResolver metaDataResolver) {
            this.id = id;
            this.resolveState = resolveState;
            this.metaDataResolver = metaDataResolver;
        }

        public String toString() {
            return this.id.toString();
        }

        @Override
        public ModuleIdentifier getId() {
            return this.id;
        }

        public Collection<ModuleVersionResolveState> getVersions() {
            return this.versions.values();
        }

        public void select(ModuleVersionResolveState selected) {
            assert (this.selected == null);
            this.selected = selected;
            for (ModuleVersionResolveState version : this.versions.values()) {
                version.state = ModuleState.Evicted;
            }
            selected.state = ModuleState.Selected;
        }

        public ModuleVersionResolveState clearSelection() {
            ModuleVersionResolveState previousSelection = this.selected;
            this.selected = null;
            for (ModuleVersionResolveState version : this.versions.values()) {
                version.state = ModuleState.Conflict;
            }
            return previousSelection;
        }

        public void restart(ModuleVersionResolveState selected) {
            this.select(selected);
            for (ModuleVersionResolveState version : this.versions.values()) {
                version.restart(selected);
            }
            for (ModuleVersionSelectorResolveState selector : this.selectors) {
                selector.restart(selected);
            }
            for (DependencyEdge dependency : new ArrayList<DependencyEdge>(this.unattachedDependencies)) {
                dependency.restart(selected);
            }
            this.unattachedDependencies.clear();
        }

        public void addUnattachedDependency(DependencyEdge edge) {
            this.unattachedDependencies.add(edge);
        }

        public void removeUnattachedDependency(DependencyEdge edge) {
            this.unattachedDependencies.remove(edge);
        }

        public ModuleVersionResolveState getVersion(ModuleVersionIdentifier id) {
            ModuleVersionResolveState moduleRevision = this.versions.get(id);
            if (moduleRevision == null) {
                moduleRevision = new ModuleVersionResolveState(this, id, this.metaDataResolver);
                this.versions.put(id, moduleRevision);
            }
            return moduleRevision;
        }

        public void addSelector(ModuleVersionSelectorResolveState selector) {
            this.selectors.add(selector);
        }
    }

    static enum ModuleState {
        New,
        Selected,
        Conflict,
        Evicted;

    }

    private static class ResolveState {
        private final Map<ModuleIdentifier, ModuleResolveState> modules = new LinkedHashMap<ModuleIdentifier, ModuleResolveState>();
        private final Map<ResolvedConfigurationIdentifier, ConfigurationNode> nodes = new LinkedHashMap<ResolvedConfigurationIdentifier, ConfigurationNode>();
        private final Map<ModuleVersionSelector, ModuleVersionSelectorResolveState> selectors = new LinkedHashMap<ModuleVersionSelector, ModuleVersionSelectorResolveState>();
        private final RootConfigurationNode root;
        private final DependencyToComponentIdResolver idResolver;
        private final ComponentMetaDataResolver metaDataResolver;
        private final DependencyToConfigurationResolver dependencyToConfigurationResolver;
        private final Set<ConfigurationNode> queued = new HashSet<ConfigurationNode>();
        private final LinkedList<ConfigurationNode> queue = new LinkedList();

        public ResolveState(ComponentResolveResult rootResult, String rootConfigurationName, DependencyToComponentIdResolver idResolver, ComponentMetaDataResolver metaDataResolver, DependencyToConfigurationResolver dependencyToConfigurationResolver) {
            this.idResolver = idResolver;
            this.metaDataResolver = metaDataResolver;
            this.dependencyToConfigurationResolver = dependencyToConfigurationResolver;
            ModuleVersionResolveState rootVersion = this.getRevision(rootResult.getId());
            rootVersion.setMetaData(rootResult.getMetaData());
            this.root = new RootConfigurationNode(rootVersion, new ResolvedConfigurationIdentifier(rootVersion.id, rootConfigurationName), this);
            this.nodes.put(this.root.id, this.root);
            this.root.moduleRevision.module.select(this.root.moduleRevision);
        }

        public ModuleResolveState getModule(ModuleIdentifier id) {
            ModuleResolveState module = this.modules.get(id);
            if (module == null) {
                module = new ModuleResolveState(id, this, this.metaDataResolver);
                this.modules.put(id, module);
            }
            return module;
        }

        public ModuleVersionResolveState getRevision(ModuleVersionIdentifier id) {
            return this.getModule(id.getModule()).getVersion(id);
        }

        public Collection<ConfigurationNode> getConfigurationNodes() {
            return this.nodes.values();
        }

        public ConfigurationNode getConfigurationNode(ModuleVersionResolveState module, String configurationName) {
            ResolvedConfigurationIdentifier id = new ResolvedConfigurationIdentifier(module.id, configurationName);
            ConfigurationNode configuration = this.nodes.get(id);
            if (configuration == null) {
                configuration = new ConfigurationNode(id, module, this);
                this.nodes.put(id, configuration);
            }
            return configuration;
        }

        public ModuleVersionSelectorResolveState getSelector(DependencyMetadata dependencyMetadata) {
            ModuleVersionSelector requested = dependencyMetadata.getRequested();
            ModuleVersionSelectorResolveState resolveState = this.selectors.get(requested);
            if (resolveState == null) {
                resolveState = new ModuleVersionSelectorResolveState(dependencyMetadata, this.idResolver, this);
                this.selectors.put(requested, resolveState);
            }
            return resolveState;
        }

        public ConfigurationNode peek() {
            return this.queue.isEmpty() ? null : this.queue.getFirst();
        }

        public ConfigurationNode pop() {
            ConfigurationNode next = this.queue.removeFirst();
            this.queued.remove(next);
            return next;
        }

        public void onMoreSelected(ConfigurationNode configuration) {
            if (this.queued.add(configuration)) {
                this.queue.addLast(configuration);
            }
        }

        public void onFewerSelected(ConfigurationNode configuration) {
            if (this.queued.add(configuration)) {
                this.queue.addFirst(configuration);
            }
        }
    }

    private static class DependencyEdge
    implements DependencyGraphEdge {
        public final ConfigurationNode from;
        public final ModuleVersionSelectorResolveState selector;
        private final DependencyMetadata dependencyMetadata;
        private final ResolveState resolveState;
        private final ModuleExclusion moduleExclusion;
        private final Set<ConfigurationNode> targetConfigurations = new LinkedHashSet<ConfigurationNode>();
        private ModuleVersionResolveState targetModuleRevision;

        public DependencyEdge(ConfigurationNode from, DependencyMetadata dependencyMetadata, ModuleExclusion moduleExclusion, ResolveState resolveState) {
            this.from = from;
            this.dependencyMetadata = dependencyMetadata;
            this.moduleExclusion = moduleExclusion;
            this.resolveState = resolveState;
            this.selector = resolveState.getSelector(dependencyMetadata);
        }

        public String toString() {
            return String.format("%s -> %s(%s)", this.from.toString(), this.dependencyMetadata.getRequested(), Joiner.on((char)',').join((Object[])this.dependencyMetadata.getModuleConfigurations()));
        }

        @Override
        public DependencyGraphNode getFrom() {
            return this.from;
        }

        public ModuleVersionResolveState resolveModuleRevisionId() {
            if (this.targetModuleRevision == null) {
                this.targetModuleRevision = this.selector.resolveModuleRevisionId();
                this.selector.getSelectedModule().addUnattachedDependency(this);
            }
            return this.targetModuleRevision;
        }

        public boolean isTransitive() {
            return this.from.isTransitive() && this.dependencyMetadata.isTransitive();
        }

        public void attachToTargetConfigurations() {
            if (this.targetModuleRevision.state != ModuleState.Selected) {
                return;
            }
            this.calculateTargetConfigurations();
            for (ConfigurationNode targetConfiguration : this.targetConfigurations) {
                targetConfiguration.addIncomingEdge(this);
            }
            if (!this.targetConfigurations.isEmpty()) {
                this.selector.getSelectedModule().removeUnattachedDependency(this);
            }
        }

        public void removeFromTargetConfigurations() {
            for (ConfigurationNode targetConfiguration : this.targetConfigurations) {
                targetConfiguration.removeIncomingEdge(this);
            }
            this.targetConfigurations.clear();
            if (this.targetModuleRevision != null) {
                this.selector.getSelectedModule().removeUnattachedDependency(this);
            }
        }

        public void restart(ModuleVersionResolveState selected) {
            this.targetModuleRevision = selected;
            this.attachToTargetConfigurations();
        }

        private void calculateTargetConfigurations() {
            this.targetConfigurations.clear();
            ComponentResolveMetadata targetModuleVersion = this.targetModuleRevision.getMetaData();
            if (targetModuleVersion == null) {
                return;
            }
            Set<ConfigurationMetadata> targetConfigurations = this.resolveState.dependencyToConfigurationResolver.resolveTargetConfigurations(this.dependencyMetadata, this.from.metaData, targetModuleVersion);
            for (ConfigurationMetadata targetConfiguration : targetConfigurations) {
                ConfigurationNode targetConfigurationNode = this.resolveState.getConfigurationNode(this.targetModuleRevision, targetConfiguration.getName());
                this.targetConfigurations.add(targetConfigurationNode);
            }
        }

        @Override
        public ModuleExclusion getExclusions() {
            Set<String> hierarchy = this.from.metaData.getHierarchy();
            ModuleExclusion edgeExclusions = ModuleExclusions.excludeAny(this.dependencyMetadata.getExcludes(hierarchy));
            return ModuleExclusions.intersect(edgeExclusions, this.moduleExclusion);
        }

        @Override
        public ComponentSelector getRequested() {
            return this.dependencyMetadata.getSelector();
        }

        @Override
        public ModuleVersionSelector getRequestedModuleVersion() {
            return this.dependencyMetadata.getRequested();
        }

        @Override
        public ModuleVersionResolveException getFailure() {
            return this.selector.getFailure();
        }

        @Override
        public ModuleVersionIdentifier getSelected() {
            return this.selector.getSelected().getId();
        }

        @Override
        public ComponentSelectionReason getReason() {
            return this.selector.getSelectionReason();
        }

        @Override
        public ModuleDependency getModuleDependency() {
            if (this.dependencyMetadata instanceof DslOriginDependencyMetadata) {
                return ((DslOriginDependencyMetadata)this.dependencyMetadata).getSource();
            }
            return null;
        }

        @Override
        public Set<ComponentArtifactMetadata> getArtifacts(ConfigurationMetadata metaData1) {
            return this.dependencyMetadata.getArtifacts(this.from.metaData, metaData1);
        }
    }
}

