/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.projectmodule;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectComponentProvider;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectComponentRegistry;
import org.gradle.internal.component.local.model.LocalComponentMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;

public class DefaultProjectComponentRegistry
implements ProjectComponentRegistry {
    private final List<ProjectComponentProvider> providers;
    private final ConcurrentMap<ProjectComponentIdentifier, LocalComponentMetadata> projects = new ConcurrentHashMap<ProjectComponentIdentifier, LocalComponentMetadata>();

    public DefaultProjectComponentRegistry(List<ProjectComponentProvider> providers) {
        this.providers = providers;
    }

    @Override
    public LocalComponentMetadata getProject(ProjectComponentIdentifier projectIdentifier) {
        LocalComponentMetadata metaData = (LocalComponentMetadata)this.projects.get(projectIdentifier);
        if (metaData != null) {
            return metaData;
        }
        for (ProjectComponentProvider provider : this.providers) {
            LocalComponentMetadata componentMetaData = provider.getProject(projectIdentifier);
            if (componentMetaData == null) continue;
            this.projects.putIfAbsent(projectIdentifier, componentMetaData);
            return componentMetaData;
        }
        return null;
    }

    @Override
    public Iterable<ComponentArtifactMetadata> getAdditionalArtifacts(ProjectComponentIdentifier project) {
        for (ProjectComponentProvider provider : this.providers) {
            Iterable<ComponentArtifactMetadata> artifacts = provider.getAdditionalArtifacts(project);
            if (artifacts == null) continue;
            return artifacts;
        }
        return Collections.emptyList();
    }
}

