/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.projectmodule;

import org.gradle.api.Action;
import org.gradle.api.artifacts.DependencySubstitution;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.DependencySubstitutionInternal;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DependencySubstitutionRuleProvider;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.CompositeBuildContext;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.VersionSelectionReasons;
import org.gradle.internal.component.local.model.DefaultProjectComponentSelector;

public class CompositeBuildDependencySubstitutions
implements DependencySubstitutionRuleProvider {
    private final CompositeBuildContext projectComponentRegistry;

    public CompositeBuildDependencySubstitutions(CompositeBuildContext projectComponentRegistry) {
        this.projectComponentRegistry = projectComponentRegistry;
    }

    @Override
    public Action<DependencySubstitution> getDependencySubstitutionRule() {
        return new Action<DependencySubstitution>(){

            public void execute(DependencySubstitution sub) {
                DependencySubstitutionInternal dependencySubstitution = (DependencySubstitutionInternal)sub;
                ComponentSelector requested = dependencySubstitution.getTarget();
                if (requested instanceof ModuleComponentSelector) {
                    ModuleComponentSelector selector = (ModuleComponentSelector)requested;
                    ProjectComponentIdentifier replacement = CompositeBuildDependencySubstitutions.this.projectComponentRegistry.getReplacementProject(selector);
                    if (replacement != null) {
                        dependencySubstitution.useTarget((Object)DefaultProjectComponentSelector.newSelector(replacement.getProjectPath()), VersionSelectionReasons.COMPOSITE_BUILD);
                    }
                }
            }
        };
    }
}

