/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.modulecache;

import java.math.BigInteger;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.IvyModuleCacheEntry;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.MavenModuleCacheEntry;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.MissingModuleCacheEntry;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.ModuleDescriptorCacheEntry;
import org.gradle.internal.component.model.ModuleSource;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.DefaultSerializer;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;

class ModuleDescriptorCacheEntrySerializer
implements Serializer<ModuleDescriptorCacheEntry> {
    private final DefaultSerializer<ModuleSource> moduleSourceSerializer = new DefaultSerializer(ModuleSource.class.getClassLoader());

    ModuleDescriptorCacheEntrySerializer() {
    }

    public void write(Encoder encoder, ModuleDescriptorCacheEntry value) throws Exception {
        encoder.writeByte(value.type);
        switch (value.type) {
            case 0: {
                encoder.writeLong(value.createTimestamp);
                break;
            }
            case 1: {
                encoder.writeBoolean(value.isChanging);
                encoder.writeLong(value.createTimestamp);
                this.moduleSourceSerializer.write(encoder, (Object)value.moduleSource);
                byte[] hash = value.moduleDescriptorHash.toByteArray();
                encoder.writeBinary(hash);
                break;
            }
            case 2: {
                MavenModuleCacheEntry mavenCacheEntry = (MavenModuleCacheEntry)value;
                encoder.writeBoolean(value.isChanging);
                encoder.writeNullableString((CharSequence)mavenCacheEntry.packaging);
                encoder.writeNullableString((CharSequence)mavenCacheEntry.snapshotTimestamp);
                encoder.writeLong(value.createTimestamp);
                this.moduleSourceSerializer.write(encoder, (Object)value.moduleSource);
                byte[] hash = value.moduleDescriptorHash.toByteArray();
                encoder.writeBinary(hash);
                break;
            }
            default: {
                throw new IllegalArgumentException("Don't know how to serialize meta-data entry: " + value);
            }
        }
    }

    public ModuleDescriptorCacheEntry read(Decoder decoder) throws Exception {
        byte type = decoder.readByte();
        switch (type) {
            case 0: {
                long createTimestamp = decoder.readLong();
                return new MissingModuleCacheEntry(createTimestamp);
            }
            case 1: {
                boolean isChanging = decoder.readBoolean();
                long createTimestamp = decoder.readLong();
                ModuleSource moduleSource = (ModuleSource)this.moduleSourceSerializer.read(decoder);
                byte[] encodedHash = decoder.readBinary();
                BigInteger hash = new BigInteger(encodedHash);
                return new IvyModuleCacheEntry(isChanging, createTimestamp, hash, moduleSource);
            }
            case 2: {
                boolean isChanging = decoder.readBoolean();
                String packaging = decoder.readNullableString();
                String snapshotTimestamp = decoder.readNullableString();
                long createTimestamp = decoder.readLong();
                ModuleSource moduleSource = (ModuleSource)this.moduleSourceSerializer.read(decoder);
                byte[] encodedHash = decoder.readBinary();
                BigInteger hash = new BigInteger(encodedHash);
                return new MavenModuleCacheEntry(isChanging, packaging, snapshotTimestamp, createTimestamp, hash, moduleSource);
            }
        }
        throw new IllegalArgumentException("Don't know how to deserialize meta-data entry of type " + type);
    }
}

