/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ExcludeRule;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ArtifactId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleVersionSelector;
import org.gradle.internal.Cast;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.component.external.descriptor.DefaultExclude;
import org.gradle.internal.component.external.descriptor.Dependency;
import org.gradle.internal.component.external.descriptor.ModuleDescriptorState;
import org.gradle.internal.component.external.descriptor.MutableModuleDescriptorState;
import org.gradle.internal.component.external.model.DefaultModuleComponentIdentifier;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.Exclude;

public class IvyModuleDescriptorConverter {
    private static final String CLASSIFIER = "classifier";
    private static final Field DEPENDENCY_CONFIG_FIELD;

    public static ModuleDescriptorState forIvyModuleDescriptor(ModuleDescriptor ivyDescriptor) {
        ModuleRevisionId moduleRevisionId = ivyDescriptor.getModuleRevisionId();
        ModuleComponentIdentifier componentIdentifier = DefaultModuleComponentIdentifier.newId(moduleRevisionId.getOrganisation(), moduleRevisionId.getName(), moduleRevisionId.getRevision());
        MutableModuleDescriptorState state = new MutableModuleDescriptorState(componentIdentifier, ivyDescriptor.getStatus(), ivyDescriptor.isDefault());
        state.setBranch(moduleRevisionId.getBranch());
        state.setDescription(ivyDescriptor.getDescription());
        state.setPublicationDate(ivyDescriptor.getPublicationDate());
        Map extraInfo = (Map)Cast.uncheckedCast((Object)ivyDescriptor.getExtraInfo());
        state.getExtraInfo().putAll(extraInfo);
        for (Configuration configuration : ivyDescriptor.getConfigurations()) {
            IvyModuleDescriptorConverter.addConfiguration(state, configuration);
        }
        for (Configuration configuration : ivyDescriptor.getAllExcludeRules()) {
            IvyModuleDescriptorConverter.addExcludeRule(state, (ExcludeRule)configuration);
        }
        for (Configuration configuration : ivyDescriptor.getDependencies()) {
            IvyModuleDescriptorConverter.addDependency(state, (DependencyDescriptor)configuration);
        }
        return state;
    }

    private static void addConfiguration(MutableModuleDescriptorState state, Configuration configuration) {
        String name = configuration.getName();
        boolean transitive = configuration.isTransitive();
        boolean visible = configuration.getVisibility() == Configuration.Visibility.PUBLIC;
        ArrayList extendsFrom = Lists.newArrayList((Object[])configuration.getExtends());
        state.addConfiguration(name, transitive, visible, extendsFrom);
    }

    private static void addExcludeRule(MutableModuleDescriptorState state, ExcludeRule excludeRule) {
        state.addExclude(IvyModuleDescriptorConverter.forIvyExclude(excludeRule));
    }

    private static void addDependency(MutableModuleDescriptorState state, DependencyDescriptor dependencyDescriptor) {
        ModuleRevisionId revisionId = dependencyDescriptor.getDependencyRevisionId();
        ModuleVersionSelector requested = DefaultModuleVersionSelector.newSelector(revisionId.getOrganisation(), revisionId.getName(), revisionId.getRevision());
        Dependency dep = state.addDependency(requested, dependencyDescriptor.getDynamicConstraintDependencyRevisionId().getRevision(), false, dependencyDescriptor.isChanging(), dependencyDescriptor.isTransitive());
        Map<String, List<String>> configMappings = IvyModuleDescriptorConverter.readConfigMappings(dependencyDescriptor);
        for (String from : configMappings.keySet()) {
            for (String string : configMappings.get(from)) {
                dep.addDependencyConfiguration(from, string);
            }
        }
        for (DependencyArtifactDescriptor dependencyArtifactDescriptor : dependencyDescriptor.getAllDependencyArtifacts()) {
            DefaultIvyArtifactName ivyArtifactName = new DefaultIvyArtifactName(dependencyArtifactDescriptor.getName(), dependencyArtifactDescriptor.getType(), dependencyArtifactDescriptor.getExt(), (String)dependencyArtifactDescriptor.getExtraAttributes().get(CLASSIFIER));
            dep.addArtifact(ivyArtifactName, Sets.newHashSet((Object[])dependencyArtifactDescriptor.getConfigurations()));
        }
        for (DependencyArtifactDescriptor dependencyArtifactDescriptor : dependencyDescriptor.getAllExcludeRules()) {
            dep.addExcludeRule(IvyModuleDescriptorConverter.forIvyExclude((ExcludeRule)dependencyArtifactDescriptor));
        }
    }

    private static Exclude forIvyExclude(ExcludeRule excludeRule) {
        ArtifactId id = excludeRule.getId();
        return new DefaultExclude(id.getModuleId().getOrganisation(), id.getModuleId().getName(), id.getName(), id.getType(), id.getExt(), excludeRule.getConfigurations(), excludeRule.getMatcher().getName());
    }

    private static Map<String, List<String>> readConfigMappings(DependencyDescriptor dependencyDescriptor) {
        if (dependencyDescriptor instanceof DefaultDependencyDescriptor) {
            try {
                return (Map)DEPENDENCY_CONFIG_FIELD.get(dependencyDescriptor);
            }
            catch (IllegalAccessException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }
        String[] modConfs = dependencyDescriptor.getModuleConfigurations();
        LinkedHashMap results = Maps.newLinkedHashMap();
        for (String modConf : modConfs) {
            results.put(modConf, Arrays.asList(dependencyDescriptor.getDependencyConfigurations(modConfs)));
        }
        return results;
    }

    static {
        try {
            DEPENDENCY_CONFIG_FIELD = DefaultDependencyDescriptor.class.getDeclaredField("confs");
            DEPENDENCY_CONFIG_FIELD.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }
}

