/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser;

import java.io.File;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.DescriptorParseContext;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.MetaDataParseException;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.MetaDataParser;
import org.gradle.internal.component.external.model.MutableModuleComponentResolveMetadata;
import org.gradle.internal.resource.ExternalResource;
import org.gradle.internal.resource.local.DefaultLocallyAvailableExternalResource;
import org.gradle.internal.resource.local.DefaultLocallyAvailableResource;
import org.gradle.internal.resource.local.LocallyAvailableExternalResource;
import org.gradle.internal.resource.local.LocallyAvailableResource;

public abstract class AbstractModuleDescriptorParser<T extends MutableModuleComponentResolveMetadata>
implements MetaDataParser<T> {
    @Override
    public T parseMetaData(DescriptorParseContext ivySettings, File descriptorFile, boolean validate) throws MetaDataParseException {
        DefaultLocallyAvailableResource localResource = new DefaultLocallyAvailableResource(descriptorFile);
        DefaultLocallyAvailableExternalResource resource = new DefaultLocallyAvailableExternalResource(descriptorFile.toURI(), (LocallyAvailableResource)localResource);
        return this.parseDescriptor(ivySettings, (LocallyAvailableExternalResource)resource, validate);
    }

    @Override
    public T parseMetaData(DescriptorParseContext ivySettings, File descriptorFile) throws MetaDataParseException {
        return this.parseMetaData(ivySettings, descriptorFile, true);
    }

    @Override
    public T parseMetaData(DescriptorParseContext ivySettings, LocallyAvailableExternalResource resource) throws MetaDataParseException {
        return this.parseDescriptor(ivySettings, resource, true);
    }

    protected T parseDescriptor(DescriptorParseContext ivySettings, LocallyAvailableExternalResource resource, boolean validate) throws MetaDataParseException {
        try {
            return this.doParseDescriptor(ivySettings, resource, validate);
        }
        catch (MetaDataParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MetaDataParseException(this.getTypeName(), (ExternalResource)resource, e);
        }
        catch (AssertionError e) {
            throw new MetaDataParseException(this.getTypeName(), (ExternalResource)resource, (Throwable)((Object)e));
        }
    }

    protected abstract String getTypeName();

    protected abstract T doParseDescriptor(DescriptorParseContext var1, LocallyAvailableExternalResource var2, boolean var3) throws Exception;
}

