/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve;

import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.CacheLockingManager;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.BaseModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepositoryAccess;
import org.gradle.api.internal.component.ArtifactType;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentOverrideMetadata;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ComponentUsage;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.ModuleSource;
import org.gradle.internal.resolve.result.BuildableArtifactResolveResult;
import org.gradle.internal.resolve.result.BuildableArtifactSetResolveResult;
import org.gradle.internal.resolve.result.BuildableModuleComponentMetaDataResolveResult;
import org.gradle.internal.resolve.result.BuildableModuleVersionListingResolveResult;

public class CacheLockReleasingModuleComponentsRepository
extends BaseModuleComponentRepository {
    private final ModuleComponentRepositoryAccess remoteAccess;

    public CacheLockReleasingModuleComponentsRepository(ModuleComponentRepository repository, CacheLockingManager cacheLockingManager) {
        super(repository);
        this.remoteAccess = new LockReleasingRepositoryAccess(repository.getName(), repository.getRemoteAccess(), cacheLockingManager);
    }

    @Override
    public ModuleComponentRepositoryAccess getRemoteAccess() {
        return this.remoteAccess;
    }

    private static class LockReleasingRepositoryAccess
    implements ModuleComponentRepositoryAccess {
        private final String name;
        private final ModuleComponentRepositoryAccess delegate;
        private final CacheLockingManager cacheLockingManager;

        public String toString() {
            return "unlocking > " + this.delegate.toString();
        }

        private LockReleasingRepositoryAccess(String name, ModuleComponentRepositoryAccess delegate, CacheLockingManager cacheLockingManager) {
            this.name = name;
            this.delegate = delegate;
            this.cacheLockingManager = cacheLockingManager;
        }

        @Override
        public void listModuleVersions(final DependencyMetadata dependency, final BuildableModuleVersionListingResolveResult result) {
            this.cacheLockingManager.longRunningOperation("List " + dependency + " using repository " + this.name, new Runnable(){

                @Override
                public void run() {
                    LockReleasingRepositoryAccess.this.delegate.listModuleVersions(dependency, result);
                }
            });
        }

        @Override
        public void resolveComponentMetaData(final ModuleComponentIdentifier moduleComponentIdentifier, final ComponentOverrideMetadata requestMetaData, final BuildableModuleComponentMetaDataResolveResult result) {
            this.cacheLockingManager.longRunningOperation("Resolve " + moduleComponentIdentifier + " using repository " + this.name, new Runnable(){

                @Override
                public void run() {
                    LockReleasingRepositoryAccess.this.delegate.resolveComponentMetaData(moduleComponentIdentifier, requestMetaData, result);
                }
            });
        }

        @Override
        public void resolveModuleArtifacts(final ComponentResolveMetadata component, final ArtifactType artifactType, final BuildableArtifactSetResolveResult result) {
            this.cacheLockingManager.longRunningOperation("Resolve " + artifactType + " for " + component + " using repository " + this.name, new Runnable(){

                @Override
                public void run() {
                    LockReleasingRepositoryAccess.this.delegate.resolveModuleArtifacts(component, artifactType, result);
                }
            });
        }

        @Override
        public void resolveModuleArtifacts(final ComponentResolveMetadata component, final ComponentUsage componentUsage, final BuildableArtifactSetResolveResult result) {
            this.cacheLockingManager.longRunningOperation("Resolve " + componentUsage + " for " + component + " using repository " + this.name, new Runnable(){

                @Override
                public void run() {
                    LockReleasingRepositoryAccess.this.delegate.resolveModuleArtifacts(component, componentUsage, result);
                }
            });
        }

        @Override
        public void resolveArtifact(final ComponentArtifactMetadata artifact, final ModuleSource moduleSource, final BuildableArtifactResolveResult result) {
            this.cacheLockingManager.longRunningOperation("Download " + artifact + " using repository " + this.name, new Runnable(){

                @Override
                public void run() {
                    LockReleasingRepositoryAccess.this.delegate.resolveArtifact(artifact, moduleSource, result);
                }
            });
        }
    }
}

