/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.script.lang.kotlin.provider;

import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.initialization.dsl.ScriptHandler;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.api.internal.file.collections.SimpleFileCollection;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.initialization.ScriptHandlerInternal;
import org.gradle.configuration.ScriptPlugin;
import org.gradle.configuration.ScriptPluginFactory;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.script.lang.kotlin.KotlinBuildScript;
import org.gradle.script.lang.kotlin.provider.KotlinCompilerKt;
import org.gradle.script.lang.kotlin.provider.KotlinScriptPlugin;
import org.gradle.script.lang.kotlin.support.KotlinScriptDefinitionProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.script.KotlinConfigurableScriptDefinition;
import org.jetbrains.kotlin.script.KotlinScriptDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J$\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J0\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0019\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001f"}, d2={"Lorg/gradle/script/lang/kotlin/provider/KotlinScriptPluginFactory;", "Lorg/gradle/configuration/ScriptPluginFactory;", "classPathRegistry", "Lorg/gradle/api/internal/ClassPathRegistry;", "(Lorg/gradle/api/internal/ClassPathRegistry;)V", "getClassPathRegistry", "()Lorg/gradle/api/internal/ClassPathRegistry;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLogger", "()Lorg/slf4j/Logger;", "classLoaderFor", "Ljava/lang/ClassLoader;", "classPath", "", "Ljava/io/File;", "scriptHandler", "Lorg/gradle/api/internal/initialization/ScriptHandlerInternal;", "targetScope", "Lorg/gradle/api/internal/initialization/ClassLoaderScope;", "compile", "Ljava/lang/Class;", "scriptSource", "Lorg/gradle/groovy/scripts/ScriptSource;", "create", "Lorg/gradle/configuration/ScriptPlugin;", "Lorg/gradle/api/initialization/dsl/ScriptHandler;", "baseScope", "topLevelScript", "", "gradle-script-kotlin-compileKotlin"})
public final class KotlinScriptPluginFactory
implements ScriptPluginFactory {
    private final Logger logger;
    @NotNull
    private final ClassPathRegistry classPathRegistry;

    public final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public ScriptPlugin create(@NotNull ScriptSource scriptSource, @NotNull ScriptHandler scriptHandler, @NotNull ClassLoaderScope targetScope, @NotNull ClassLoaderScope baseScope, boolean topLevelScript) {
        Intrinsics.checkParameterIsNotNull((Object)scriptSource, (String)"scriptSource");
        Intrinsics.checkParameterIsNotNull((Object)scriptHandler, (String)"scriptHandler");
        Intrinsics.checkParameterIsNotNull((Object)targetScope, (String)"targetScope");
        Intrinsics.checkParameterIsNotNull((Object)baseScope, (String)"baseScope");
        ScriptHandler scriptHandler2 = scriptHandler;
        if (scriptHandler2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.internal.initialization.ScriptHandlerInternal");
        }
        return new KotlinScriptPlugin(scriptSource, this.compile(scriptSource, (ScriptHandlerInternal)scriptHandler2, targetScope));
    }

    private final Class<?> compile(ScriptSource scriptSource, ScriptHandlerInternal scriptHandler, ClassLoaderScope targetScope) {
        File scriptFile = scriptSource.getResource().getFile();
        List<File> classPath2 = KotlinScriptDefinitionProvider.INSTANCE.selectGradleApiJars(this.classPathRegistry);
        KotlinConfigurableScriptDefinition scriptDef = KotlinScriptDefinitionProvider.INSTANCE.scriptDefinitionFor(classPath2);
        ClassLoader classLoader = this.classLoaderFor(classPath2, scriptHandler, targetScope);
        File file = scriptFile;
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"scriptFile");
        KotlinScriptDefinition kotlinScriptDefinition = (KotlinScriptDefinition)scriptDef;
        Logger logger = this.logger;
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"logger");
        return KotlinCompilerKt.compileKotlinScript(file, kotlinScriptDefinition, classLoader, logger);
    }

    private final ClassLoader classLoaderFor(List<? extends File> classPath2, ScriptHandlerInternal scriptHandler, ClassLoaderScope targetScope) {
        scriptHandler.getDependencies().add("classpath", (Object)new SimpleFileCollection((Collection)classPath2));
        targetScope.export(scriptHandler.getScriptClassPath());
        targetScope.export(KotlinBuildScript.class.getClassLoader());
        targetScope.lock();
        ClassLoader classLoader = targetScope.getLocalClassLoader();
        Intrinsics.checkExpressionValueIsNotNull((Object)classLoader, (String)"targetScope.localClassLoader");
        return classLoader;
    }

    @NotNull
    public final ClassPathRegistry getClassPathRegistry() {
        return this.classPathRegistry;
    }

    public KotlinScriptPluginFactory(@NotNull ClassPathRegistry classPathRegistry) {
        Logger logger;
        Intrinsics.checkParameterIsNotNull((Object)classPathRegistry, (String)"classPathRegistry");
        this.classPathRegistry = classPathRegistry;
        KotlinScriptPluginFactory kotlinScriptPluginFactory = this;
        kotlinScriptPluginFactory.logger = logger = LoggerFactory.getLogger(KotlinScriptPluginFactory.class);
    }
}

