/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.script.lang.kotlin.provider;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageUtil;
import org.jetbrains.kotlin.cli.common.messages.OutputMessageUtil;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinToJVMBytecodeCompiler;
import org.jetbrains.kotlin.cli.jvm.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.codegen.CompilationException;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.ContentRootsKt;
import org.jetbrains.kotlin.script.KotlinScriptDefinition;
import org.jetbrains.kotlin.script.KotlinScriptExtraImport;
import org.jetbrains.kotlin.utils.PathUtil;
import org.slf4j.Logger;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a*\u0010\u0000\u001a\u0006\u0012\u0002\b\u00030\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a*\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0017"}, d2={"compileKotlinScript", "Ljava/lang/Class;", "scriptFile", "Ljava/io/File;", "scriptDef", "Lorg/jetbrains/kotlin/script/KotlinScriptDefinition;", "classLoader", "Ljava/lang/ClassLoader;", "log", "Lorg/slf4j/Logger;", "compilerConfigFor", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "sourceFile", "extraImport", "Lorg/jetbrains/kotlin/script/KotlinScriptExtraImport;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "kotlinCoreEnvironmentFor", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "configuration", "rootDisposable", "Lcom/intellij/openapi/Disposable;", "messageCollectorFor", "gradle-script-kotlin-compileKotlin"})
public final class KotlinCompilerKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final Class<?> compileKotlinScript(@NotNull File scriptFile, @NotNull KotlinScriptDefinition scriptDef, @NotNull ClassLoader classLoader, @NotNull Logger log) {
        Intrinsics.checkParameterIsNotNull((Object)scriptFile, (String)"scriptFile");
        Intrinsics.checkParameterIsNotNull((Object)scriptDef, (String)"scriptDef");
        Intrinsics.checkParameterIsNotNull((Object)classLoader, (String)"classLoader");
        Intrinsics.checkParameterIsNotNull((Object)log, (String)"log");
        MessageCollector messageCollector = KotlinCompilerKt.messageCollectorFor(log);
        Disposable rootDisposable = Disposer.newDisposable();
        try {
            CompilerConfiguration configuration = KotlinCompilerKt.compilerConfigFor(scriptFile, scriptDef, null, messageCollector);
            Disposable disposable = rootDisposable;
            Intrinsics.checkExpressionValueIsNotNull((Object)disposable, (String)"rootDisposable");
            KotlinCoreEnvironment environment = KotlinCompilerKt.kotlinCoreEnvironmentFor(configuration, disposable);
            Class clazz = KotlinToJVMBytecodeCompiler.INSTANCE.compileScript(classLoader, environment);
            if (clazz == null) {
                throw (Throwable)new IllegalStateException("Internal error: unable to compile script, see log for details");
            }
            Class clazz2 = clazz;
            return clazz2;
        }
        catch (CompilationException ex) {
            messageCollector.report(CompilerMessageSeverity.EXCEPTION, OutputMessageUtil.renderException((Throwable)ex), MessageUtil.psiElementToMessageLocation((PsiElement)ex.getElement()));
            throw (Throwable)new IllegalStateException("Internal error: " + OutputMessageUtil.renderException((Throwable)ex));
        }
        finally {
            rootDisposable.dispose();
        }
    }

    private static final CompilerConfiguration compilerConfigFor(File sourceFile, KotlinScriptDefinition scriptDef, KotlinScriptExtraImport extraImport, MessageCollector messageCollector) {
        CompilerConfiguration compilerConfiguration = new CompilerConfiguration();
        CompilerConfiguration $receiver = compilerConfiguration;
        ContentRootsKt.addKotlinSourceRoots((CompilerConfiguration)$receiver, (List)CollectionsKt.listOf((Object)sourceFile.getCanonicalPath()));
        List list = PathUtil.getJdkClassesRoots();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"PathUtil.getJdkClassesRoots()");
        JvmContentRootsKt.addJvmClasspathRoots((CompilerConfiguration)$receiver, (List)list);
        KotlinScriptExtraImport kotlinScriptExtraImport = extraImport;
        if (kotlinScriptExtraImport != null) {
            KotlinScriptExtraImport kotlinScriptExtraImport2 = kotlinScriptExtraImport;
            KotlinScriptExtraImport it = kotlinScriptExtraImport2;
            $receiver.put(CommonConfigurationKeys.SCRIPTS_EXTRA_IMPORTS_KEY, (Object)sourceFile.getAbsolutePath(), (Object)extraImport);
        }
        $receiver.add(CommonConfigurationKeys.SCRIPT_DEFINITIONS_KEY, (Object)scriptDef);
        $receiver.put(JVMConfigurationKeys.MODULE_NAME, (Object)"buildscript");
        $receiver.put(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY, (Object)messageCollector);
        return compilerConfiguration;
    }

    private static final KotlinCoreEnvironment kotlinCoreEnvironmentFor(CompilerConfiguration configuration, Disposable rootDisposable) {
        List list = EnvironmentConfigFiles.JVM_CONFIG_FILES;
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"EnvironmentConfigFiles.JVM_CONFIG_FILES");
        return KotlinCoreEnvironment.Companion.createForProduction(rootDisposable, configuration, list);
    }

    private static final MessageCollector messageCollectorFor(Logger log) {
        return new MessageCollector(log){
            final /* synthetic */ Logger $log;

            public final void report(@NotNull CompilerMessageSeverity severity, @NotNull String message, @NotNull CompilerMessageLocation location) {
                Intrinsics.checkParameterIsNotNull((Object)severity, (String)"severity");
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
                Function0<String> msg$ = new Function0<String>(location, message){
                    final /* synthetic */ CompilerMessageLocation $location;
                    final /* synthetic */ String $message;

                    @NotNull
                    public final String invoke() {
                        return Intrinsics.areEqual((Object)this.$location, (Object)CompilerMessageLocation.NO_LOCATION) ? String.valueOf(this.$message) : this.$message + " (" + this.$location + ")";
                    }
                    {
                        this.$location = compilerMessageLocation;
                        this.$message = string;
                        super(0);
                    }
                };
                CompilerMessageSeverity compilerMessageSeverity = severity;
                if (CompilerMessageSeverity.ERRORS.contains(compilerMessageSeverity)) {
                    this.$log.error("Error: " + (String)msg$.invoke());
                } else if (Intrinsics.areEqual((Object)compilerMessageSeverity, (Object)CompilerMessageSeverity.ERROR)) {
                    this.$log.error((String)msg$.invoke());
                } else if (Intrinsics.areEqual((Object)compilerMessageSeverity, (Object)CompilerMessageSeverity.WARNING)) {
                    this.$log.info("Warning: " + (String)msg$.invoke());
                } else if (Intrinsics.areEqual((Object)compilerMessageSeverity, (Object)CompilerMessageSeverity.LOGGING)) {
                    this.$log.info((String)msg$.invoke());
                } else if (Intrinsics.areEqual((Object)compilerMessageSeverity, (Object)CompilerMessageSeverity.INFO)) {
                    this.$log.info((String)msg$.invoke());
                }
            }
            {
                this.$log = logger;
            }
        };
    }
}

