/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import org.gradle.TaskExecutionRequest;
import org.gradle.api.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTaskExecutionRequest
implements TaskExecutionRequest,
Serializable {
    private final List<String> args;
    private final String projectPath;

    public DefaultTaskExecutionRequest(Iterable<String> args) {
        this(args, null);
    }

    public DefaultTaskExecutionRequest(Iterable<String> args, @Nullable String projectPath) {
        this.args = Lists.newArrayList(args);
        this.projectPath = projectPath;
    }

    @Override
    public List<String> getArgs() {
        return this.args;
    }

    @Override
    public String getProjectPath() {
        return this.projectPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultTaskExecutionRequest that = (DefaultTaskExecutionRequest)o;
        if (!Objects.equal((Object)this.projectPath, (Object)that.projectPath)) {
            return false;
        }
        return Objects.equal(this.args, that.args);
    }

    public int hashCode() {
        int result = this.getArgs().hashCode();
        result = 31 * result + (this.projectPath != null ? this.projectPath.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "DefaultTaskExecutionRequest{args=" + this.args + ",projectPath='" + this.projectPath + '\'' + '}';
    }
}

