/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.gradle.api.InvalidUserDataException;
import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.internal.typeconversion.NotationConvertResult;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.NotationParserBuilder;
import org.gradle.internal.typeconversion.TypeConversionException;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class UriNotationConverter
implements NotationConverter<Object, URI> {
    public static NotationParser<Object, URI> parser() {
        return NotationParserBuilder.toType(URI.class).typeDisplayName("a URI").noImplicitConverters().converter((NotationConverter)new UriNotationConverter()).toComposite();
    }

    public void describe(DiagnosticsVisitor visitor) {
        visitor.candidate("A URI or URL instance.");
        visitor.candidate("A String or CharSequence URI").example("\"https://www.gradle.org\"");
    }

    public void convert(Object notation, NotationConvertResult<? super URI> result) throws TypeConversionException {
        if (notation instanceof URL) {
            try {
                notation = ((URL)notation).toURI();
            }
            catch (URISyntaxException e) {
                throw UriNotationConverter.invalidUserDataException(notation, e);
            }
        }
        if (notation instanceof URI) {
            URI uri = (URI)notation;
            result.converted((Object)uri);
            return;
        }
        if (notation instanceof CharSequence) {
            String notationString = notation.toString();
            if (notationString.startsWith("file:")) {
                return;
            }
            if (notationString.startsWith("http://") || notationString.startsWith("https://")) {
                try {
                    result.converted((Object)new URI(notationString));
                }
                catch (URISyntaxException e) {
                    throw UriNotationConverter.invalidUserDataException(notationString, e);
                }
                return;
            }
            try {
                URI uri = new URI(notationString);
                if (uri.getScheme() == null || UriNotationConverter.isWindowsRootDirectory(uri.getScheme())) {
                    return;
                }
                result.converted((Object)uri);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
    }

    private static @NonNull InvalidUserDataException invalidUserDataException(Object notation, URISyntaxException e) {
        return new InvalidUserDataException(String.format("Cannot convert '%s' to a URI.", notation), (Throwable)e);
    }

    private static boolean isWindowsRootDirectory(@Nullable String scheme) {
        return scheme != null && scheme.length() == 1 && Character.isLetter(scheme.charAt(0)) && OperatingSystem.current().isWindows();
    }
}

