/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.reporting.dependencies.internal;

import com.googlecode.jatl.Html;
import java.io.Writer;
import java.util.Date;
import java.util.Set;
import org.gradle.api.Transformer;
import org.gradle.api.tasks.diagnostics.internal.ProjectDetails;
import org.gradle.reporting.HtmlPageBuilder;
import org.gradle.reporting.ReportRenderer;
import org.gradle.util.GradleVersion;

public class ProjectsPageRenderer
extends ReportRenderer<Set<ProjectDetails.ProjectNameAndPath>, HtmlPageBuilder<Writer>> {
    private final Transformer<String, ProjectDetails.ProjectNameAndPath> namingScheme;

    public ProjectsPageRenderer(Transformer<String, ProjectDetails.ProjectNameAndPath> namingScheme) {
        this.namingScheme = namingScheme;
    }

    public void render(final Set<ProjectDetails.ProjectNameAndPath> projects, final HtmlPageBuilder<Writer> builder) {
        final String baseCssLink = builder.requireResource(((Object)((Object)this)).getClass().getResource("/org/gradle/reporting/base-style.css"));
        final String cssLink = builder.requireResource(((Object)((Object)this)).getClass().getResource("/org/gradle/api/tasks/diagnostics/htmldependencyreport/style.css"));
        new Html((Writer)builder.getOutput()){
            {
                super(writer);
                this.html();
                this.head();
                ((Html)((Html)this.meta()).httpEquiv("Content-Type")).content("text/html; charset=utf-8");
                ((Html)((Html)this.meta()).httpEquiv("x-ua-compatible")).content("IE=edge");
                ((Html)((Html)((Html)((Html)this.link()).rel("stylesheet")).type("text/css")).href(baseCssLink)).end();
                ((Html)((Html)((Html)((Html)this.link()).rel("stylesheet")).type("text/css")).href(cssLink)).end();
                ((Html)((Html)this.title()).text("Dependency reports")).end();
                this.end();
                this.body();
                ((Html)this.div()).id("content");
                ((Html)((Html)this.h1()).text("Dependency Reports")).end();
                ((Html)this.div()).classAttr("tab");
                this.table();
                this.thead();
                this.tr();
                ((Html)((Html)this.th()).text("Project")).end();
                ((Html)((Html)this.th()).text("Description")).end();
                this.end();
                this.end();
                this.tbody();
                for (ProjectDetails.ProjectNameAndPath project : projects) {
                    this.tr();
                    ((Html)((Html)((Html)((Html)((Html)this.td()).a()).href((String)ProjectsPageRenderer.this.namingScheme.transform((Object)project))).text(project.getDisplayName())).end()).end();
                    ((Html)((Html)this.td()).text(project.getDescription())).end();
                    this.end();
                }
                this.end();
                this.end();
                this.end();
                ((Html)this.div()).id("footer");
                this.p();
                this.text("Generated by ");
                ((Html)((Html)((Html)this.a()).href("https://www.gradle.org")).text(GradleVersion.current().toString())).end();
                this.text(" at " + builder.formatDate(new Date()));
                this.end();
                this.end();
                this.end();
                this.end();
                this.endAll();
            }
        };
    }
}

