/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.kotlin.dsl.normalization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.internal.tools.api.ApiClassExtractionException;
import org.gradle.internal.tools.api.impl.AnnotationMember;
import org.gradle.internal.tools.api.impl.AnnotationValue;
import org.gradle.internal.tools.api.impl.ArrayAnnotationValue;
import org.gradle.internal.tools.api.impl.ClassMember;
import org.gradle.internal.tools.api.impl.FieldMember;
import org.gradle.internal.tools.api.impl.InnerClassMember;
import org.gradle.internal.tools.api.impl.JavaApiMemberWriter;
import org.gradle.internal.tools.api.impl.MethodMember;
import org.gradle.internal.tools.api.impl.SimpleAnnotationValue;
import org.gradle.kotlin.dsl.internal.relocated.kotlin.metadata.Attributes;
import org.gradle.kotlin.dsl.internal.relocated.kotlin.metadata.KmDeclarationContainer;
import org.gradle.kotlin.dsl.internal.relocated.kotlin.metadata.KmFunction;
import org.gradle.kotlin.dsl.internal.relocated.kotlin.metadata.Visibility;
import org.gradle.kotlin.dsl.internal.relocated.kotlin.metadata.jvm.JvmExtensionsKt;
import org.gradle.kotlin.dsl.internal.relocated.kotlin.metadata.jvm.JvmMetadataUtil;
import org.gradle.kotlin.dsl.internal.relocated.kotlin.metadata.jvm.JvmMethodSignature;
import org.gradle.kotlin.dsl.internal.relocated.kotlin.metadata.jvm.KotlinClassMetadata;
import org.gradle.kotlin.dsl.normalization.KotlinApiMemberWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassVisitor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 *2\u00020\u0001:\u0001*B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J:\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00102\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0010H\u0016J\u0016\u0010\u0016\u001a\u00020\f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0010H\u0016J\"\u0010\u0019\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u001a\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001b\u001a\u00020\u0011H\u0016J\f\u0010\u001c\u001a\u00020\f*\u00020\u001dH\u0002J\f\u0010\u001e\u001a\u00020\f*\u00020\u001dH\u0002J\f\u0010\u001f\u001a\u00020\f*\u00020\u001dH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0018H\u0002J\f\u0010#\u001a\u00020\u0007*\u00020\u0011H\u0002J\f\u0010$\u001a\u00020%*\u00020\u0011H\u0002J\f\u0010&\u001a\u00020%*\u00020\u0011H\u0002J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0011H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/gradle/kotlin/dsl/normalization/KotlinApiMemberWriter;", "Lorg/gradle/internal/tools/api/impl/JavaApiMemberWriter;", "apiMemberAdapter", "Lorg/objectweb/asm/ClassVisitor;", "<init>", "(Lorg/objectweb/asm/ClassVisitor;)V", "kotlinMetadataAnnotationSignature", "", "inlineFunctions", "", "internalFunctions", "writeClass", "", "classMember", "Lorg/gradle/internal/tools/api/impl/ClassMember;", "methods", "", "Lorg/gradle/internal/tools/api/impl/MethodMember;", "fields", "Lorg/gradle/internal/tools/api/impl/FieldMember;", "innerClasses", "Lorg/gradle/internal/tools/api/impl/InnerClassMember;", "writeClassAnnotations", "annotationMembers", "Lorg/gradle/internal/tools/api/impl/AnnotationMember;", "writeMethod", "declaringInnerClass", "method", "extractFunctionMetadata", "Lorg/gradle/kotlin/dsl/internal/relocated/kotlin/metadata/KmDeclarationContainer;", "extractInlineFunctions", "extractInternalFunctions", "parseKotlinClassHeader", "Lkotlin/Metadata;", "kotlinMetadataAnnotation", "binarySignature", "isInternal", "", "isInline", "publicInlineFunction", "Lorg/gradle/internal/tools/api/ApiClassExtractionException;", "inlineFunction", "Companion", "kotlin-dsl"})
@SourceDebugExtension(value={"SMAP\nKotlinApiMemberWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinApiMemberWriter.kt\norg/gradle/kotlin/dsl/normalization/KotlinApiMemberWriter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,169:1\n296#2,2:170\n777#2:172\n873#2,2:173\n1915#2:175\n1916#2:188\n11705#3:176\n12052#3,3:177\n11705#3:182\n12052#3,3:183\n37#4,2:180\n37#4,2:186\n*S KotlinDebug\n*F\n+ 1 KotlinApiMemberWriter.kt\norg/gradle/kotlin/dsl/normalization/KotlinApiMemberWriter\n*L\n57#1:170,2\n86#1:172\n86#1:173,2\n134#1:175\n134#1:188\n148#1:176\n148#1:177,3\n149#1:182\n149#1:183,3\n148#1:180,2\n149#1:186,2\n*E\n"})
public final class KotlinApiMemberWriter
extends JavaApiMemberWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String kotlinMetadataAnnotationSignature;
    @NotNull
    private final Set<String> inlineFunctions = new HashSet();
    @NotNull
    private final Set<String> internalFunctions = new HashSet();

    private KotlinApiMemberWriter(ClassVisitor apiMemberAdapter) {
        super(apiMemberAdapter);
        this.kotlinMetadataAnnotationSignature = "Lkotlin/Metadata;";
    }

    public void writeClass(@NotNull ClassMember classMember, @NotNull Set<? extends MethodMember> methods, @NotNull Set<? extends FieldMember> fields, @NotNull Set<? extends InnerClassMember> innerClasses) {
        Object v1;
        block10: {
            Intrinsics.checkNotNullParameter((Object)classMember, (String)"classMember");
            Intrinsics.checkNotNullParameter(methods, (String)"methods");
            Intrinsics.checkNotNullParameter(fields, (String)"fields");
            Intrinsics.checkNotNullParameter(innerClasses, (String)"innerClasses");
            SortedSet sortedSet = classMember.getAnnotations();
            Intrinsics.checkNotNullExpressionValue((Object)sortedSet, (String)"getAnnotations(...)");
            Iterable $this$firstOrNull$iv = sortedSet;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                AnnotationMember it = (AnnotationMember)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)this.kotlinMetadataAnnotationSignature)) continue;
                v1 = element$iv;
                break block10;
            }
            v1 = null;
        }
        AnnotationMember annotationMember = v1;
        if (annotationMember != null) {
            AnnotationMember it = annotationMember;
            boolean bl = false;
            KotlinClassMetadata kotlinMetadata = KotlinClassMetadata.Companion.readLenient(this.parseKotlinClassHeader(it));
            if (kotlinMetadata instanceof KotlinClassMetadata.Class) {
                this.extractFunctionMetadata(((KotlinClassMetadata.Class)kotlinMetadata).getKmClass());
            } else if (kotlinMetadata instanceof KotlinClassMetadata.FileFacade) {
                this.extractFunctionMetadata(((KotlinClassMetadata.FileFacade)kotlinMetadata).getKmPackage());
            } else if (kotlinMetadata instanceof KotlinClassMetadata.MultiFileClassPart) {
                this.extractFunctionMetadata(((KotlinClassMetadata.MultiFileClassPart)kotlinMetadata).getKmPackage());
            } else if (!(kotlinMetadata instanceof KotlinClassMetadata.MultiFileClassFacade) && !(kotlinMetadata instanceof KotlinClassMetadata.SyntheticClass)) {
                if (kotlinMetadata instanceof KotlinClassMetadata.Unknown) {
                    throw new ApiClassExtractionException("Unknown Kotlin metadata: " + kotlinMetadata + " on class " + classMember.getName() + " - this can happen if this class is compiled with a later Kotlin version than the Kotlin compiler used by Gradle");
                }
                throw new NoWhenBranchMatchedException();
            }
        }
        super.writeClass(classMember, methods, fields, innerClasses);
    }

    /*
     * WARNING - void declaration
     */
    public void writeClassAnnotations(@NotNull Set<? extends AnnotationMember> annotationMembers) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter(annotationMembers, (String)"annotationMembers");
        Iterable iterable = annotationMembers;
        KotlinApiMemberWriter kotlinApiMemberWriter = this;
        boolean $i$f$filter = false;
        void var4_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            AnnotationMember it = (AnnotationMember)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it.getName(), (Object)this.kotlinMetadataAnnotationSignature))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        super.writeClassAnnotations(CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
    }

    public void writeMethod(@NotNull ClassMember classMember, @Nullable InnerClassMember declaringInnerClass, @NotNull MethodMember method) {
        Intrinsics.checkNotNullParameter((Object)classMember, (String)"classMember");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (this.isInternal(method)) {
            return;
        }
        if (this.isInline(method)) {
            throw this.publicInlineFunction(method);
        }
        super.writeMethod(classMember, declaringInnerClass, method);
    }

    private final void extractFunctionMetadata(KmDeclarationContainer $this$extractFunctionMetadata) {
        this.extractInternalFunctions($this$extractFunctionMetadata);
        this.extractInlineFunctions($this$extractFunctionMetadata);
    }

    private final void extractInlineFunctions(KmDeclarationContainer $this$extractInlineFunctions) {
        CollectionsKt.addAll((Collection)this.inlineFunctions, (Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)$this$extractInlineFunctions.getFunctions()), KotlinApiMemberWriter::extractInlineFunctions$lambda$0), KotlinApiMemberWriter::extractInlineFunctions$lambda$1));
    }

    private final void extractInternalFunctions(KmDeclarationContainer $this$extractInternalFunctions) {
        CollectionsKt.addAll((Collection)this.internalFunctions, (Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)$this$extractInternalFunctions.getFunctions()), KotlinApiMemberWriter::extractInternalFunctions$lambda$0), KotlinApiMemberWriter::extractInternalFunctions$lambda$1));
    }

    /*
     * WARNING - void declaration
     */
    private final Metadata parseKotlinClassHeader(AnnotationMember kotlinMetadataAnnotation) {
        Integer kind2 = null;
        int[] metadataVersion = null;
        Ref.ObjectRef data1 = new Ref.ObjectRef();
        Ref.ObjectRef data2 = new Ref.ObjectRef();
        String extraString = null;
        String packageName = null;
        Integer extraInt = null;
        SortedSet sortedSet = kotlinMetadataAnnotation.getValues();
        Intrinsics.checkNotNullExpressionValue((Object)sortedSet, (String)"getValues(...)");
        Iterable $this$forEach$iv = sortedSet;
        boolean $i$f$forEach = false;
        block15: for (Object element$iv : $this$forEach$iv) {
            AnnotationValue annotationValue;
            AnnotationValue it;
            block24: {
                block25: {
                    block28: {
                        block27: {
                            block26: {
                                it = (AnnotationValue)element$iv;
                                boolean bl = false;
                                annotationValue = it;
                                if (!(annotationValue instanceof SimpleAnnotationValue)) break block24;
                                String string = ((SimpleAnnotationValue)it).getName();
                                switch (string.hashCode()) {
                                    case 3825: {
                                        if (!string.equals("xi")) {
                                            continue block15;
                                        }
                                        break block25;
                                    }
                                    case 3497: {
                                        if (!string.equals("mv")) {
                                            continue block15;
                                        }
                                        break block26;
                                    }
                                    case 107: {
                                        if (string.equals("k")) break;
                                        continue block15;
                                    }
                                    case 3835: {
                                        if (!string.equals("xs")) {
                                            continue block15;
                                        }
                                        break block27;
                                    }
                                    case 3582: {
                                        if (!string.equals("pn")) {
                                            continue block15;
                                        }
                                        break block28;
                                    }
                                }
                                Object object = ((SimpleAnnotationValue)it).getValue();
                                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
                                kind2 = (Integer)object;
                                continue;
                            }
                            Object object = ((SimpleAnnotationValue)it).getValue();
                            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.IntArray");
                            metadataVersion = (int[])object;
                            continue;
                        }
                        Object object = ((SimpleAnnotationValue)it).getValue();
                        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                        extraString = (String)object;
                        continue;
                    }
                    Object object = ((SimpleAnnotationValue)it).getValue();
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                    packageName = (String)object;
                    continue;
                }
                Object object = ((SimpleAnnotationValue)it).getValue();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
                extraInt = (Integer)object;
                continue;
            }
            if (!(annotationValue instanceof ArrayAnnotationValue)) continue;
            switch (((ArrayAnnotationValue)it).getName()) {
                case "d1": {
                    Object[] $this$toTypedArray$iv;
                    AnnotationValue arrayItem;
                    Collection collection;
                    void $this$mapTo$iv$iv;
                    Collection $this$map$iv;
                    Object object = ((ArrayAnnotationValue)it).getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
                    Object[] objectArray = (Object[])object;
                    Ref.ObjectRef objectRef = data1;
                    boolean $i$f$map = false;
                    void var20_20 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
                    boolean $i$f$mapTo = false;
                    for (void item$iv$iv : $this$mapTo$iv$iv) {
                        AnnotationValue annotationValue2 = (AnnotationValue)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        Object object2 = arrayItem.getValue();
                        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.String");
                        collection.add((String)object2);
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    boolean $i$f$toTypedArray = false;
                    Object[] thisCollection$iv = $this$toTypedArray$iv;
                    objectRef.element = thisCollection$iv.toArray(new String[0]);
                    break;
                }
                case "d2": {
                    AnnotationValue arrayItem;
                    Collection collection;
                    void $this$mapTo$iv$iv;
                    Collection $this$map$iv;
                    Object object = ((ArrayAnnotationValue)it).getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
                    Object[] $this$toTypedArray$iv = (Object[])object;
                    Ref.ObjectRef objectRef = data2;
                    boolean $i$f$map = false;
                    Object[] thisCollection$iv = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
                    boolean $i$f$mapTo = false;
                    int n = ((void)$this$mapTo$iv$iv).length;
                    for (int j = 0; j < n; ++j) {
                        void item$iv$iv;
                        item$iv$iv = $this$mapTo$iv$iv[j];
                        arrayItem = (AnnotationValue)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        Object object3 = arrayItem.getValue();
                        Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.String");
                        collection.add((String)object3);
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    boolean $i$f$toTypedArray = false;
                    thisCollection$iv = $this$toTypedArray$iv;
                    objectRef.element = thisCollection$iv.toArray(new String[0]);
                }
            }
        }
        return JvmMetadataUtil.Metadata(kind2, metadataVersion, (String[])data1.element, (String[])data2.element, extraString, packageName, extraInt);
    }

    private final String binarySignature(MethodMember $this$binarySignature) {
        return $this$binarySignature.getName() + $this$binarySignature.getTypeDesc();
    }

    private final boolean isInternal(MethodMember $this$isInternal) {
        return this.internalFunctions.contains(this.binarySignature($this$isInternal));
    }

    private final boolean isInline(MethodMember $this$isInline) {
        return this.inlineFunctions.contains(this.binarySignature($this$isInline));
    }

    private final ApiClassExtractionException publicInlineFunction(MethodMember inlineFunction) {
        return new ApiClassExtractionException("inline fun " + inlineFunction.getName() + "(): compile avoidance is not supported with public inline functions");
    }

    private static final boolean extractInlineFunctions$lambda$0(KmFunction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Attributes.isInline(it);
    }

    private static final String extractInlineFunctions$lambda$1(KmFunction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        JvmMethodSignature jvmMethodSignature = JvmExtensionsKt.getSignature(it);
        return jvmMethodSignature != null ? jvmMethodSignature.toString() : null;
    }

    private static final boolean extractInternalFunctions$lambda$0(KmFunction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Attributes.getVisibility(it) == Visibility.INTERNAL;
    }

    private static final String extractInternalFunctions$lambda$1(KmFunction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        JvmMethodSignature jvmMethodSignature = JvmExtensionsKt.getSignature(it);
        return jvmMethodSignature != null ? jvmMethodSignature.toString() : null;
    }

    public /* synthetic */ KotlinApiMemberWriter(ClassVisitor apiMemberAdapter, DefaultConstructorMarker $constructor_marker) {
        this(apiMemberAdapter);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a8\u0006\b"}, d2={"Lorg/gradle/kotlin/dsl/normalization/KotlinApiMemberWriter$Companion;", "", "<init>", "()V", "adapter", "Lkotlin/Function1;", "Lorg/objectweb/asm/ClassVisitor;", "Lorg/gradle/kotlin/dsl/normalization/KotlinApiMemberWriter;", "kotlin-dsl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Function1<ClassVisitor, KotlinApiMemberWriter> adapter() {
            return adapter.1.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

