/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal.filelock;

import com.google.common.base.Preconditions;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockOptions;

public class DefaultLockOptions
implements LockOptions {
    private final FileLockManager.LockMode mode;
    private final boolean crossVersion;
    private final boolean ensureAcquiredLockRepresentsStateOnFileSystem;

    private DefaultLockOptions(FileLockManager.LockMode mode, boolean crossVersion, boolean ensureAcquiredLockRepresentsStateOnFileSystem) {
        this.mode = mode;
        this.crossVersion = crossVersion;
        this.ensureAcquiredLockRepresentsStateOnFileSystem = ensureAcquiredLockRepresentsStateOnFileSystem;
    }

    public static DefaultLockOptions mode(FileLockManager.LockMode lockMode) {
        return new DefaultLockOptions(lockMode, false, false);
    }

    public DefaultLockOptions useCrossVersionImplementation() {
        return new DefaultLockOptions(this.mode, true, this.ensureAcquiredLockRepresentsStateOnFileSystem);
    }

    public DefaultLockOptions ensureAcquiredLockRepresentsStateOnFileSystem() {
        Preconditions.checkArgument((this.mode != FileLockManager.LockMode.Shared && !this.crossVersion ? 1 : 0) != 0, (Object)"Shared or cross-version locks are not supported with ensureAcquiredLockRepresentsStateOnFileSystem() option.");
        return new DefaultLockOptions(this.mode, this.crossVersion, true);
    }

    @Override
    public FileLockManager.LockMode getMode() {
        return this.mode;
    }

    @Override
    public boolean isUseCrossVersionImplementation() {
        return this.crossVersion;
    }

    @Override
    public boolean isEnsureAcquiredLockRepresentsStateOnFileSystem() {
        return this.ensureAcquiredLockRepresentsStateOnFileSystem;
    }

    @Override
    public LockOptions copyWithMode(FileLockManager.LockMode mode) {
        return new DefaultLockOptions(mode, this.crossVersion, this.ensureAcquiredLockRepresentsStateOnFileSystem);
    }

    public String toString() {
        return "DefaultLockOptions{mode=" + (Object)((Object)this.mode) + ", crossVersion=" + this.crossVersion + ", ensureAcquiredLockRepresentsStateOnFileSystem=" + this.ensureAcquiredLockRepresentsStateOnFileSystem + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultLockOptions)) {
            return false;
        }
        DefaultLockOptions that = (DefaultLockOptions)o;
        return this.crossVersion == that.crossVersion && this.ensureAcquiredLockRepresentsStateOnFileSystem == that.ensureAcquiredLockRepresentsStateOnFileSystem && this.mode == that.mode;
    }

    public int hashCode() {
        int result = this.mode.hashCode();
        result = 31 * result + (this.crossVersion ? 1 : 0);
        result = 31 * result + (this.ensureAcquiredLockRepresentsStateOnFileSystem ? 1 : 0);
        return result;
    }
}

