/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.console;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;
import org.gradle.internal.logging.events.StyledTextOutputEvent;
import org.gradle.internal.logging.format.TersePrettyDurationFormatter;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.nativeintegration.console.ConsoleMetaData;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgressBar {
    public static final int PROGRESS_BAR_WIDTH = 13;
    public static final String UNICODE_PROGRESS_BAR_PREFIX = "\u2502";
    public static final String UNICODE_PROGRESS_BAR_SUFFIX = "\u2502";
    public static final String ASCII_PROGRESS_BAR_PREFIX = "[";
    public static final char ASCII_PROGRESS_BAR_COMPLETE_CHAR = '#';
    public static final char ASCII_PROGRESS_BAR_INCOMPLETE_CHAR = '.';
    public static final String ASCII_PROGRESS_BAR_SUFFIX = "]";
    private static final Logger LOGGER = LoggerFactory.getLogger(ProgressBar.class);
    private static final char[] UNICODE_BLOCKS = new char[]{'\u00b7', '\u258f', '\u258e', '\u258d', '\u258c', '\u258b', '\u258a', '\u2589', '\u2588'};
    private final TersePrettyDurationFormatter elapsedTimeFormatter = new TersePrettyDurationFormatter();
    private final ConsoleMetaData consoleMetaData;
    private final String progressBarPrefix;
    private final int progressBarWidth;
    private final String progressBarSuffix;
    private final char fillerChar;
    private final char incompleteChar;
    private final String suffix;
    private int current;
    private int total;
    private @Nullable ExecutorService deadlockPreventer;
    private boolean failing;
    private @Nullable String lastElapsedTimeStr;
    private @Nullable List<StyledTextOutputEvent.Span> formatted;

    public ProgressBar(ConsoleMetaData consoleMetaData, String progressBarPrefix, int progressBarWidth, String progressBarSuffix, char completeChar, char incompleteChar, String suffix, int initialProgress, int totalProgress) {
        this.consoleMetaData = consoleMetaData;
        this.progressBarPrefix = progressBarPrefix;
        this.progressBarWidth = progressBarWidth;
        this.progressBarSuffix = progressBarSuffix;
        this.fillerChar = completeChar;
        this.incompleteChar = incompleteChar;
        this.suffix = suffix;
        this.current = initialProgress;
        this.total = totalProgress;
    }

    static ProgressBar createProgressBar(ConsoleMetaData consoleMetaData, String initialSuffix, int totalProgress) {
        if (consoleMetaData.supportsUnicode()) {
            return new ProgressBar(consoleMetaData, "\u2502", 13, "\u2502", ' ', ' ', initialSuffix, 0, totalProgress);
        }
        return new ProgressBar(consoleMetaData, ASCII_PROGRESS_BAR_PREFIX, 13, ASCII_PROGRESS_BAR_SUFFIX, '#', '.', initialSuffix, 0, totalProgress);
    }

    public void moreProgress(int totalProgress) {
        this.total += totalProgress;
        this.formatted = null;
    }

    public void update(boolean failing) {
        ++this.current;
        if (this.current > this.total) {
            if (this.deadlockPreventer == null) {
                this.deadlockPreventer = Executors.newSingleThreadExecutor();
            }
            Future<?> future = this.deadlockPreventer.submit(() -> LOGGER.warn("More progress was logged than there should be ({} > {})", (Object)this.current, (Object)this.total));
        }
        this.failing = this.failing || failing;
        this.formatted = null;
    }

    public List<StyledTextOutputEvent.Span> formatProgress(boolean timerEnabled, long elapsedTime) {
        String elapsedTimeStr = this.elapsedTimeFormatter.format(elapsedTime);
        if (this.formatted != null && elapsedTimeStr.equals(this.lastElapsedTimeStr)) {
            return this.formatted;
        }
        int consoleCols = this.consoleMetaData.getCols();
        int progressPercent = (int)((double)this.current * 100.0 / (double)this.total);
        String taskbarSequence = this.buildTaskbarProgressSequence(progressPercent, this.failing);
        String statusPrefix = ProgressBar.trimToConsole(consoleCols, 0, taskbarSequence + this.progressBarPrefix);
        if (this.consoleMetaData.supportsUnicode()) {
            return this.getUnicodeFormatted(timerEnabled, consoleCols, statusPrefix, progressPercent, elapsedTimeStr);
        }
        return this.getAsciiFormatted(timerEnabled, consoleCols, statusPrefix, progressPercent, elapsedTimeStr);
    }

    private List<StyledTextOutputEvent.Span> getAsciiFormatted(boolean timerEnabled, int consoleCols, String statusPrefix, int progressPercent, String elapsedTimeStr) {
        int completedWidth = this.getCompletedWidth();
        int remainingWidth = this.progressBarWidth - completedWidth;
        String coloredProgress = ProgressBar.trimToConsole(consoleCols, statusPrefix.length(), StringUtils.repeat((char)this.fillerChar, (int)completedWidth));
        String statusSuffix = ProgressBar.trimToConsole(consoleCols, statusPrefix.length() + coloredProgress.length(), StringUtils.repeat((char)this.incompleteChar, (int)remainingWidth) + this.renderProgressStatus(timerEnabled, progressPercent, elapsedTimeStr));
        this.lastElapsedTimeStr = elapsedTimeStr;
        this.formatted = this.createFormattedList(statusPrefix, coloredProgress, statusSuffix);
        return this.formatted;
    }

    private List<StyledTextOutputEvent.Span> createFormattedList(String statusPrefix, String coloredProgress, String statusSuffix) {
        return ImmutableList.of((Object)new StyledTextOutputEvent.Span(StyledTextOutput.Style.Header, statusPrefix), (Object)new StyledTextOutputEvent.Span(this.failing ? StyledTextOutput.Style.FailureHeader : StyledTextOutput.Style.SuccessHeader, coloredProgress), (Object)new StyledTextOutputEvent.Span(StyledTextOutput.Style.Header, statusSuffix));
    }

    private List<StyledTextOutputEvent.Span> getUnicodeFormatted(boolean timerEnabled, int consoleCols, String statusPrefix, int progressPercent, String elapsedTimeStr) {
        String progress = this.getProgressString();
        String coloredProgress = ProgressBar.trimToConsole(consoleCols, statusPrefix.length(), progress);
        String statusSuffix = ProgressBar.trimToConsole(consoleCols, statusPrefix.length() + coloredProgress.length(), this.renderProgressStatus(timerEnabled, progressPercent, elapsedTimeStr));
        this.lastElapsedTimeStr = elapsedTimeStr;
        this.formatted = this.createFormattedList(statusPrefix, coloredProgress, statusSuffix);
        return this.formatted;
    }

    private String renderProgressStatus(boolean timerEnabled, int progressPercent, String elapsedTimeStr) {
        return this.progressBarSuffix + " " + progressPercent + '%' + ' ' + this.suffix + (timerEnabled ? " [" + elapsedTimeStr + ASCII_PROGRESS_BAR_SUFFIX : "");
    }

    private String getProgressString() {
        double progressRatio = this.getProgressRatio();
        double totalEighths = (double)this.progressBarWidth * 8.0;
        int completedEighths = (int)(progressRatio * totalEighths);
        StringBuilder progress = new StringBuilder(this.progressBarWidth);
        for (int i = 0; i < this.progressBarWidth; ++i) {
            int eighthsAtPosition = i * 8;
            int remainingEighths = Math.min(8, Math.max(0, completedEighths - eighthsAtPosition));
            progress.append(UNICODE_BLOCKS[remainingEighths]);
        }
        return progress.toString();
    }

    private int getCompletedWidth() {
        if (this.current > this.total) {
            return this.progressBarWidth - 1;
        }
        return (int)((double)this.current / (double)this.total * (double)this.progressBarWidth);
    }

    private double getProgressRatio() {
        if (this.current > this.total) {
            return ((double)this.progressBarWidth - 1.0) / (double)this.progressBarWidth;
        }
        return (double)this.current / (double)this.total;
    }

    private static String trimToConsole(int cols, int prefixLength, String str) {
        int consoleWidth = cols - 1;
        int remainingWidth = consoleWidth - prefixLength;
        if (consoleWidth < 0) {
            return str;
        }
        if (remainingWidth <= 0) {
            return "";
        }
        if (consoleWidth < str.length()) {
            return str.substring(0, consoleWidth);
        }
        return str;
    }

    private String buildTaskbarProgressSequence(int progressPercent, boolean isError) {
        if (!this.consoleMetaData.supportsTaskbarProgress()) {
            return "";
        }
        int state = isError ? 2 : 1;
        return "\u001b]9;4;" + state + ";" + progressPercent + "\u0007";
    }
}

