/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.scala;

import java.io.File;
import java.util.Collections;
import java.util.Set;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.api.internal.tasks.compile.BaseForkOptionsConverter;
import org.gradle.api.internal.tasks.compile.MinimalJavaCompilerDaemonForkOptions;
import org.gradle.api.internal.tasks.compile.daemon.AbstractDaemonCompiler;
import org.gradle.api.internal.tasks.compile.daemon.CompilerParameters;
import org.gradle.api.internal.tasks.compile.daemon.CompilerWorkerExecutor;
import org.gradle.api.internal.tasks.scala.HashedClasspath;
import org.gradle.api.internal.tasks.scala.MinimalScalaCompileOptions;
import org.gradle.api.internal.tasks.scala.MinimalScalaCompilerDaemonForkOptions;
import org.gradle.api.internal.tasks.scala.ScalaCompilerParameters;
import org.gradle.api.internal.tasks.scala.ScalaJavaJointCompileSpec;
import org.gradle.api.internal.tasks.scala.ZincScalaCompilerFacade;
import org.gradle.api.tasks.compile.BaseForkOptions;
import org.gradle.cache.scopes.GlobalScopedCacheBuilderFactory;
import org.gradle.initialization.ClassLoaderRegistry;
import org.gradle.internal.classloader.ClassLoaderSpec;
import org.gradle.internal.classloader.FilteringClassLoader;
import org.gradle.internal.classloader.VisitableURLClassLoader;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.process.JavaForkOptions;
import org.gradle.process.internal.JavaForkOptionsFactory;
import org.gradle.workers.internal.ClassLoaderStructure;
import org.gradle.workers.internal.DaemonForkOptions;
import org.gradle.workers.internal.DaemonForkOptionsBuilder;
import org.gradle.workers.internal.HierarchicalClassLoaderStructure;
import org.gradle.workers.internal.KeepAliveMode;

public class DaemonScalaCompiler<T extends ScalaJavaJointCompileSpec>
extends AbstractDaemonCompiler<T> {
    private final HashedClasspath hashedScalaClasspath;
    private final Iterable<File> zincClasspath;
    private final JavaForkOptionsFactory forkOptionsFactory;
    private final File daemonWorkingDir;
    private final ClassPathRegistry classPathRegistry;
    private final ClassLoaderRegistry classLoaderRegistry;

    public DaemonScalaCompiler(File daemonWorkingDir, HashedClasspath hashedScalaClasspath, CompilerWorkerExecutor compilerWorkerExecutor, Iterable<File> zincClasspath, JavaForkOptionsFactory forkOptionsFactory, ClassPathRegistry classPathRegistry, ClassLoaderRegistry classLoaderRegistry) {
        super(compilerWorkerExecutor);
        this.hashedScalaClasspath = hashedScalaClasspath;
        this.zincClasspath = zincClasspath;
        this.forkOptionsFactory = forkOptionsFactory;
        this.daemonWorkingDir = daemonWorkingDir;
        this.classPathRegistry = classPathRegistry;
        this.classLoaderRegistry = classLoaderRegistry;
    }

    protected CompilerParameters getCompilerParameters(T spec) {
        return new ScalaCompilerParameters(ZincScalaCompilerFacade.class.getName(), new Object[]{this.hashedScalaClasspath}, spec);
    }

    protected Set<Class<?>> getAdditionalCompilerServices() {
        return Collections.singleton(GlobalScopedCacheBuilderFactory.class);
    }

    protected DaemonForkOptions toDaemonForkOptions(T spec) {
        MinimalJavaCompilerDaemonForkOptions javaOptions = spec.getCompileOptions().getForkOptions();
        MinimalScalaCompileOptions compileOptions = spec.getScalaCompileOptions();
        MinimalScalaCompilerDaemonForkOptions forkOptions = compileOptions.getForkOptions();
        JavaForkOptions javaForkOptions = new BaseForkOptionsConverter(this.forkOptionsFactory).transform(this.mergeForkOptions((BaseForkOptions)javaOptions, (BaseForkOptions)forkOptions));
        javaForkOptions.systemProperty("xsbt.skip.cp.lookup", (Object)true);
        javaForkOptions.setWorkingDir(this.daemonWorkingDir);
        javaForkOptions.setExecutable(spec.getJavaExecutable().getAbsolutePath());
        ClassPath compilerClasspath = this.classPathRegistry.getClassPath("SCALA-COMPILER").plus(DefaultClassPath.of(this.zincClasspath));
        HierarchicalClassLoaderStructure classLoaderStructure = new HierarchicalClassLoaderStructure((ClassLoaderSpec)this.classLoaderRegistry.getGradleWorkerExtensionSpec()).withChild((ClassLoaderSpec)this.getScalaFilterSpec()).withChild((ClassLoaderSpec)new VisitableURLClassLoader.Spec("compiler", compilerClasspath.getAsURLs()));
        return new DaemonForkOptionsBuilder(this.forkOptionsFactory).javaForkOptions(javaForkOptions).withClassLoaderStructure((ClassLoaderStructure)classLoaderStructure).keepAliveMode(KeepAliveMode.valueOf((String)compileOptions.getKeepAliveMode().name())).build();
    }

    private FilteringClassLoader.Spec getScalaFilterSpec() {
        FilteringClassLoader.Spec gradleApiAndScalaSpec = this.classLoaderRegistry.getGradleApiFilterSpec();
        gradleApiAndScalaSpec.disallowPackage("org.gradle.api.internal.tasks.scala");
        gradleApiAndScalaSpec.allowPackage("com.google");
        return gradleApiAndScalaSpec;
    }
}

