/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.report.generic;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gradle.api.internal.tasks.testing.results.serializable.OutputEntry;
import org.gradle.api.internal.tasks.testing.results.serializable.OutputRanges;
import org.gradle.api.internal.tasks.testing.results.serializable.SerializableTestResult;
import org.gradle.api.tasks.testing.TestMetadataEvent;
import org.gradle.api.tasks.testing.TestResult;

public abstract class PerRootInfo {
    private final long id;

    private PerRootInfo(long id) {
        this.id = id;
    }

    public abstract boolean isLeaf();

    public abstract List<SerializableTestResult> getResults();

    public long getId() {
        return this.id;
    }

    public abstract List<OutputEntry> getOutputEntries();

    public abstract int getTotalLeafCount();

    public abstract int getFailedLeafCount();

    public abstract int getSkippedLeafCount();

    public abstract Iterable<TestMetadataEvent> getMetadatas();

    private static final class MultiResultContainer
    extends PerRootInfo {
        private final List<SerializableTestResult> results;
        private final List<OutputEntry> outputEntries;
        private final int totalLeafCount;
        private final int failedLeafCount;
        private final int skippedLeafCount;

        private MultiResultContainer(long id, List<SerializableTestResult> results, List<OutputEntry> outputEntries, int totalLeafCount, int failedLeafCount, int skippedLeafCount) {
            super(id);
            this.results = results;
            this.outputEntries = outputEntries;
            this.totalLeafCount = totalLeafCount;
            this.failedLeafCount = failedLeafCount;
            this.skippedLeafCount = skippedLeafCount;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public List<SerializableTestResult> getResults() {
            return this.results;
        }

        @Override
        public List<OutputEntry> getOutputEntries() {
            return this.outputEntries;
        }

        @Override
        public int getTotalLeafCount() {
            return this.totalLeafCount;
        }

        @Override
        public int getFailedLeafCount() {
            return this.failedLeafCount;
        }

        @Override
        public int getSkippedLeafCount() {
            return this.skippedLeafCount;
        }

        @Override
        public Iterable<TestMetadataEvent> getMetadatas() {
            return Iterables.concat((Iterable)Iterables.transform(this.getResults(), SerializableTestResult::getMetadatas));
        }
    }

    private static final class SingleResultContainer
    extends PerRootInfo {
        private final SerializableTestResult result;
        private final OutputRanges outputRanges;
        private final int totalLeafCount;
        private final int failedLeafCount;
        private final int skippedLeafCount;

        private SingleResultContainer(long id, SerializableTestResult result, OutputRanges outputRanges, int totalLeafCount, int failedLeafCount, int skippedLeafCount) {
            super(id);
            this.result = result;
            this.outputRanges = outputRanges;
            this.totalLeafCount = totalLeafCount;
            this.failedLeafCount = failedLeafCount;
            this.skippedLeafCount = skippedLeafCount;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public List<SerializableTestResult> getResults() {
            return Collections.singletonList(this.result);
        }

        @Override
        public List<OutputEntry> getOutputEntries() {
            return Collections.singletonList(new OutputEntry(this.getId(), this.outputRanges));
        }

        @Override
        public int getTotalLeafCount() {
            return this.totalLeafCount;
        }

        @Override
        public int getFailedLeafCount() {
            return this.failedLeafCount;
        }

        @Override
        public int getSkippedLeafCount() {
            return this.skippedLeafCount;
        }

        @Override
        public Iterable<TestMetadataEvent> getMetadatas() {
            return this.result.getMetadatas();
        }
    }

    private static final class SingleResultLeaf
    extends PerRootInfo {
        private final SerializableTestResult result;
        private final OutputRanges outputRanges;

        private SingleResultLeaf(long id, SerializableTestResult result, OutputRanges outputRanges) {
            super(id);
            this.result = result;
            this.outputRanges = outputRanges;
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        public List<SerializableTestResult> getResults() {
            return Collections.singletonList(this.result);
        }

        @Override
        public List<OutputEntry> getOutputEntries() {
            return Collections.singletonList(new OutputEntry(this.getId(), this.outputRanges));
        }

        @Override
        public int getTotalLeafCount() {
            return 1;
        }

        @Override
        public int getFailedLeafCount() {
            return this.result.getResultType() == TestResult.ResultType.FAILURE ? 1 : 0;
        }

        @Override
        public int getSkippedLeafCount() {
            return this.result.getResultType() == TestResult.ResultType.SKIPPED ? 1 : 0;
        }

        @Override
        public Iterable<TestMetadataEvent> getMetadatas() {
            return this.result.getMetadatas();
        }
    }

    public static final class Builder {
        private final long id;
        private final List<SerializableTestResult> results;
        private final List<OutputEntry> outputEntries;
        private boolean isLeaf;
        private int totalLeafCount;
        private int failedLeafCount;
        private int skippedLeafCount;

        public Builder(long id, SerializableTestResult result, OutputRanges ranges, boolean isLeaf, int totalLeafCount, int failedLeafCount, int skippedLeafCount) {
            this.id = id;
            this.results = new ArrayList<SerializableTestResult>(Collections.singletonList(result));
            this.outputEntries = new ArrayList<OutputEntry>(Collections.singletonList(new OutputEntry(id, ranges)));
            this.isLeaf = isLeaf;
            this.totalLeafCount = totalLeafCount;
            this.failedLeafCount = failedLeafCount;
            this.skippedLeafCount = skippedLeafCount;
        }

        public String getName() {
            return this.results.get(0).getName();
        }

        public boolean isLeaf() {
            return this.isLeaf;
        }

        public int getTotalLeafCount() {
            return this.totalLeafCount;
        }

        public int getFailedLeafCount() {
            return this.failedLeafCount;
        }

        public int getSkippedLeafCount() {
            return this.skippedLeafCount;
        }

        public void merge(Builder otherBuilder) {
            this.totalLeafCount += otherBuilder.totalLeafCount;
            this.failedLeafCount += otherBuilder.failedLeafCount;
            this.skippedLeafCount += otherBuilder.skippedLeafCount;
            if (!otherBuilder.getName().equals(this.getName())) {
                throw new IllegalArgumentException("Cannot merge PerRootInfo.Builder with different names: " + this.getName() + " and " + otherBuilder.getName());
            }
            this.results.addAll(otherBuilder.results);
            this.outputEntries.addAll(otherBuilder.outputEntries);
            if (!otherBuilder.isLeaf) {
                this.isLeaf = false;
            }
        }

        public PerRootInfo build() {
            if (this.isLeaf) {
                if (this.results.size() > 1) {
                    throw new IllegalStateException("Cannot build a leaf PerRootInfo with multiple results");
                }
                if (this.totalLeafCount != 1 || this.failedLeafCount > 1 || this.skippedLeafCount > 1) {
                    throw new IllegalStateException("Inconsistent leaf counts for leaf PerRootInfo: total=" + this.totalLeafCount + ", failed=" + this.failedLeafCount + ", skipped=" + this.skippedLeafCount);
                }
                return new SingleResultLeaf(this.id, this.results.get(0), this.outputEntries.get(0).getOutputRanges());
            }
            if (this.results.size() == 1) {
                return new SingleResultContainer(this.id, this.results.get(0), this.outputEntries.get(0).getOutputRanges(), this.totalLeafCount, this.failedLeafCount, this.skippedLeafCount);
            }
            return new MultiResultContainer(this.id, (List)ImmutableList.copyOf(this.results), (List)ImmutableList.copyOf(this.outputEntries), this.totalLeafCount, this.failedLeafCount, this.skippedLeafCount);
        }
    }
}

