/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.component.Artifact;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.result.DefaultResolvedArtifactResult;
import org.gradle.api.internal.attributes.AttributeDesugaring;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.DisplayName;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.model.VariantIdentifier;

public class ResolvedArtifactCollectingVisitor
implements ArtifactVisitor {
    private final Set<ResolvedArtifactResult> artifacts = new LinkedHashSet<ResolvedArtifactResult>();
    private final Set<Throwable> failures = new LinkedHashSet<Throwable>();
    private final Set<ComponentArtifactIdentifier> seenArtifacts = new HashSet<ComponentArtifactIdentifier>();
    private final AttributeDesugaring attributeDesugaring;

    public ResolvedArtifactCollectingVisitor(AttributeDesugaring attributeDesugaring) {
        this.attributeDesugaring = attributeDesugaring;
    }

    @Override
    public void visitFailure(Throwable failure) {
        this.failures.add(failure);
    }

    @Override
    public void visitArtifact(DisplayName artifactSetName, VariantIdentifier sourceVariantId, ImmutableAttributes attributes, ImmutableCapabilities capabilities, ResolvableArtifact artifact) {
        try {
            if (this.seenArtifacts.add(artifact.getId())) {
                File file = artifact.getFile();
                this.artifacts.add(new DefaultResolvedArtifactResult(artifact.getId(), (AttributeContainer)this.attributeDesugaring.desugar(attributes), (ImmutableList<Capability>)ImmutableList.copyOf(capabilities.asSet()), artifactSetName, Artifact.class, file));
            }
        }
        catch (Exception t) {
            this.failures.add(t);
        }
    }

    @Override
    public boolean requireArtifactFiles() {
        return true;
    }

    public Set<ResolvedArtifactResult> getArtifacts() {
        return this.artifacts;
    }

    public Set<Throwable> getFailures() {
        return this.failures;
    }
}

