/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.software.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.NamedDomainObjectCollectionSchema;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.initialization.Settings;
import org.gradle.api.internal.plugins.BindsProjectFeature;
import org.gradle.api.internal.plugins.BindsProjectType;
import org.gradle.api.internal.plugins.BuildModel;
import org.gradle.api.internal.plugins.Definition;
import org.gradle.api.internal.plugins.ProjectFeatureApplyAction;
import org.gradle.api.internal.plugins.ProjectFeatureBinding;
import org.gradle.api.internal.plugins.ProjectFeatureBindingBuilder;
import org.gradle.api.internal.plugins.ProjectFeatureBindingDeclaration;
import org.gradle.api.internal.plugins.ProjectTypeBinding;
import org.gradle.api.internal.plugins.ProjectTypeBindingBuilder;
import org.gradle.api.internal.plugins.TargetTypeInformation;
import org.gradle.api.internal.tasks.properties.InspectionScheme;
import org.gradle.api.problems.Severity;
import org.gradle.api.problems.internal.GradleCoreProblemGroup;
import org.gradle.api.problems.internal.InternalProblem;
import org.gradle.api.problems.internal.InternalProblemReporter;
import org.gradle.api.reflect.TypeOf;
import org.gradle.api.tasks.Nested;
import org.gradle.internal.Cast;
import org.gradle.internal.Pair;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.internal.properties.annotations.TypeMetadata;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.reflect.annotations.TypeAnnotationMetadata;
import org.gradle.internal.reflect.validation.TypeValidationProblemRenderer;
import org.gradle.plugin.software.internal.DefaultProjectFeatureBindingBuilder;
import org.gradle.plugin.software.internal.DefaultProjectFeatureImplementation;
import org.gradle.plugin.software.internal.DefaultProjectTypeBindingBuilder;
import org.gradle.plugin.software.internal.ProjectFeatureDeclarations;
import org.gradle.plugin.software.internal.ProjectFeatureImplementation;
import org.gradle.plugin.software.internal.TargetTypeInformationChecks;
import org.jspecify.annotations.Nullable;

public class DefaultProjectFeatureDeclarations
implements ProjectFeatureDeclarations {
    private final Map<RegisteringPluginKey, Set<Class<? extends Plugin<Project>>>> pluginClasses = new LinkedHashMap<RegisteringPluginKey, Set<Class<? extends Plugin<Project>>>>();
    private @Nullable Map<String, Set<ProjectFeatureImplementation<?, ?>>> projectFeatureImplementations;
    private final InspectionScheme inspectionScheme;
    private final Instantiator instantiator;
    private final InternalProblemReporter problemReporter;

    public DefaultProjectFeatureDeclarations(InspectionScheme inspectionScheme, Instantiator instantiator, InternalProblemReporter problemReporter) {
        this.inspectionScheme = inspectionScheme;
        this.instantiator = instantiator;
        this.problemReporter = problemReporter;
    }

    public void addDeclaration(@Nullable String pluginId, Class<? extends Plugin<Project>> pluginClass, Class<? extends Plugin<Settings>> registeringPluginClass) {
        if (this.projectFeatureImplementations != null) {
            throw new IllegalStateException("Cannot register a plugin after project types have been discovered");
        }
        RegisteringPluginKey pluginKey = new RegisteringPluginKey(registeringPluginClass, pluginId);
        this.pluginClasses.computeIfAbsent(pluginKey, k -> new LinkedHashSet()).add(pluginClass);
    }

    private Map<String, Set<ProjectFeatureImplementation<?, ?>>> discoverProjectFeatureImplementations() {
        LinkedHashMap projectFeatureDeclarations = new LinkedHashMap();
        this.pluginClasses.forEach((registeringPluginClass, registeredPluginClasses) -> registeredPluginClasses.forEach(pluginClass -> {
            TypeMetadata pluginClassTypeMetadata = this.inspectionScheme.getMetadataStore().getTypeMetadata(pluginClass);
            TypeAnnotationMetadata pluginClassAnnotationMetadata = pluginClassTypeMetadata.getTypeAnnotationMetadata();
            this.registerTypeIfPresent((RegisteringPluginKey)registeringPluginClass, (Class<? extends Plugin<Project>>)pluginClass, pluginClassAnnotationMetadata, projectFeatureDeclarations);
            this.registerFeaturesIfPresent((RegisteringPluginKey)registeringPluginClass, (Class<? extends Plugin<Project>>)pluginClass, pluginClassAnnotationMetadata, projectFeatureDeclarations);
        }));
        return ImmutableMap.copyOf(projectFeatureDeclarations);
    }

    private <T extends Definition<V>, V extends BuildModel> void registerFeature(RegisteringPluginKey registeringPlugin, Class<? extends Plugin<Project>> pluginClass, ProjectFeatureBindingDeclaration<T, V> binding, Map<String, Set<ProjectFeatureImplementation<?, ?>>> projectFeatureDeclarations) {
        Set implementations;
        List<Class> existingPluginClasses;
        String projectFeatureName = binding.getName();
        if (binding.getDefinitionSafety() == ProjectFeatureBindingDeclaration.Safety.SAFE) {
            this.validateDefinitionSafety(binding);
        }
        if (binding.targetDefinitionType() instanceof TargetTypeInformation.BuildModelTargetTypeInformation && ((TargetTypeInformation.BuildModelTargetTypeInformation)binding.targetDefinitionType()).buildModelType.equals(BuildModel.None.class)) {
            InternalProblem bindingTypeProblem = this.problemReporter.internalCreate(builder -> builder.id("bind=to-build-model-none", "Project features binds to BuildModel.None", GradleCoreProblemGroup.configurationUsage()).details("A project feature cannot bind to 'BuildModel.None' as its target build model type.").contextualLabel("Project feature '" + projectFeatureName + "' is bound to 'BuildModel.None'").solution("Bind to a target definition type instead.").solution("Bind to a concrete build model type other than 'BuildModel.None'.").severity(Severity.ERROR));
            DefaultProjectFeatureDeclarations.throwTypeValidationException("Project feature '" + projectFeatureName + "' is bound to an invalid type:", Collections.singletonList(bindingTypeProblem));
        }
        if (!(existingPluginClasses = (implementations = projectFeatureDeclarations.computeIfAbsent(projectFeatureName, k -> new LinkedHashSet())).stream().filter(existingFeature -> existingFeature.getFeatureName().equals(binding.getName()) && TargetTypeInformationChecks.isOverlappingBindingType((TargetTypeInformation)existingFeature.getTargetDefinitionType(), (TargetTypeInformation)binding.targetDefinitionType())).map(ProjectFeatureImplementation::getPluginClass).collect(Collectors.toList())).isEmpty()) {
            ArrayList<InternalProblem> problems = new ArrayList<InternalProblem>();
            existingPluginClasses.forEach(existingPluginClass -> problems.add(this.problemReporter.internalCreate(builder -> builder.id("duplicate-project-feature-registration", "Duplicate project feature registration", GradleCoreProblemGroup.configurationUsage()).details("A project feature or type with a given name must bind to a unique target type.").contextualLabel("Project feature '" + projectFeatureName + "' is registered by both '" + pluginClass.getName() + "' and '" + existingPluginClass.getName() + "' but their bindings have overlapping target types.").solution("Remove one of the plugins from the build.").severity(Severity.ERROR))));
            DefaultProjectFeatureDeclarations.throwTypeValidationException("Project feature '" + projectFeatureName + "' is registered by multiple plugins:", problems);
        }
        implementations.add(new DefaultProjectFeatureImplementation(projectFeatureName, binding.getDefinitionType(), binding.getDefinitionImplementationType().orElse(binding.getDefinitionType()), binding.getDefinitionSafety(), binding.targetDefinitionType(), binding.getBuildModelType(), binding.getBuildModelImplementationType().orElse(binding.getBuildModelType()), pluginClass, registeringPlugin.pluginClass, registeringPlugin.pluginId, (ProjectFeatureApplyAction)Cast.uncheckedCast((Object)binding.getTransform())));
    }

    private void registerFeaturesIfPresent(RegisteringPluginKey registeringPluginClass, Class<? extends Plugin<Project>> pluginClass, TypeAnnotationMetadata pluginClassAnnotationMetadata, Map<String, Set<ProjectFeatureImplementation<?, ?>>> projectFeatureDeclarations) {
        Optional bindsProjectFeatureAnnotation = pluginClassAnnotationMetadata.getAnnotation(BindsProjectFeature.class);
        if (bindsProjectFeatureAnnotation.isPresent()) {
            BindsProjectFeature bindsSoftwareType = (BindsProjectFeature)bindsProjectFeatureAnnotation.get();
            Class bindingRegistrationClass = bindsSoftwareType.value();
            ProjectFeatureBinding bindingRegistration = (ProjectFeatureBinding)this.instantiator.newInstance(bindingRegistrationClass, new Object[0]);
            DefaultProjectFeatureBindingBuilder builder = new DefaultProjectFeatureBindingBuilder();
            bindingRegistration.bind((ProjectFeatureBindingBuilder)builder);
            builder.build().forEach(binding -> this.registerFeature(registeringPluginClass, pluginClass, (ProjectFeatureBindingDeclaration)binding, projectFeatureDeclarations));
        }
    }

    private void registerTypeIfPresent(RegisteringPluginKey registeringPluginKey, Class<? extends Plugin<Project>> pluginClass, TypeAnnotationMetadata pluginClassAnnotationMetadata, Map<String, Set<ProjectFeatureImplementation<?, ?>>> projectFeatureDeclarations) {
        Optional bindsProjectTypeAnnotation = pluginClassAnnotationMetadata.getAnnotation(BindsProjectType.class);
        if (bindsProjectTypeAnnotation.isPresent()) {
            BindsProjectType bindsProjectType = (BindsProjectType)bindsProjectTypeAnnotation.get();
            Class bindingRegistrationClass = bindsProjectType.value();
            ProjectTypeBinding bindingRegistration = (ProjectTypeBinding)this.instantiator.newInstance(bindingRegistrationClass, new Object[0]);
            DefaultProjectTypeBindingBuilder builder = new DefaultProjectTypeBindingBuilder();
            bindingRegistration.bind((ProjectTypeBindingBuilder)builder);
            builder.build().forEach(binding -> this.registerFeature(registeringPluginKey, pluginClass, (ProjectFeatureBindingDeclaration)binding, projectFeatureDeclarations));
        }
    }

    private void validateDefinitionSafety(ProjectFeatureBindingDeclaration<?, ?> binding) {
        ArrayList<InternalProblem> problems = new ArrayList<InternalProblem>();
        if (binding.getDefinitionImplementationType().isPresent() && !((Class)binding.getDefinitionImplementationType().get()).equals(binding.getDefinitionType())) {
            problems.add(this.problemReporter.internalCreate(builder -> builder.id("unsafe-definition-implementation-type", "Definition implementation type specified for safe definition", GradleCoreProblemGroup.configurationUsage()).details("Safe definitions must not specify an implementation type.").contextualLabel("Project feature '" + binding.getName() + "' has a definition with type '" + binding.getDefinitionType().getSimpleName() + "' which was declared safe but has an implementation type '" + ((Class)binding.getDefinitionImplementationType().get()).getSimpleName() + "'").solution("Mark the definition as unsafe.").solution("Remove the implementation type specification.").severity(Severity.ERROR)));
        }
        if (!binding.getDefinitionType().isInterface()) {
            problems.add(this.problemReporter.internalCreate(builder -> builder.id("unsafe-definition-type-not-interface", "Definition type not an interface for safe definition", GradleCoreProblemGroup.configurationUsage()).details("Safe definition types must be an interface.").contextualLabel("Project feature '" + binding.getName() + "' has a definition with type '" + binding.getDefinitionType().getSimpleName() + "' which was declared safe but is not an interface").solution("Mark the definition as unsafe.").solution("Refactor the type as an interface.").severity(Severity.ERROR)));
        }
        this.validateDefinition(binding.getDefinitionType(), problems);
        this.problemReporter.report(problems);
        DefaultProjectFeatureDeclarations.throwTypeValidationException("Project feature '" + binding.getName() + "' has a definition type which was declared safe but has the following issues:", problems);
    }

    private static void throwTypeValidationException(String summary, List<InternalProblem> problems) {
        List<String> formattedErrors = problems.stream().filter(problem -> problem.getDefinition().getSeverity().equals((Object)Severity.ERROR)).map(TypeValidationProblemRenderer::renderMinimalInformationAbout).collect(Collectors.toList());
        if (!formattedErrors.isEmpty()) {
            TreeFormatter formatter = new TreeFormatter(true);
            formatter.node(summary);
            formatter.startChildren();
            formattedErrors.forEach(arg_0 -> ((TreeFormatter)formatter).node(arg_0));
            formatter.endChildren();
            throw new IllegalArgumentException(formatter.toString());
        }
    }

    private void validateDefinition(Class<?> definitionType, List<InternalProblem> problems) {
        TypeMetadata definitionTypeMetadata = this.inspectionScheme.getMetadataStore().getTypeMetadata(definitionType);
        definitionTypeMetadata.getTypeAnnotationMetadata().getPropertiesAnnotationMetadata().forEach(propertyMetadata -> {
            if (propertyMetadata.isAnnotationPresent(Inject.class)) {
                problems.add(this.problemReporter.internalCreate(builder -> builder.id("unsafe-definition-inject-property", "Property annotated with @Inject in safe definition", GradleCoreProblemGroup.configurationUsage()).details("Safe definition types cannot inject services.").contextualLabel("The definition type has @Inject annotated property '" + propertyMetadata.getPropertyName() + "' in type '" + definitionType.getSimpleName() + "'").solution("Mark the definition as unsafe.").solution("Remove the @Inject annotation from the '" + propertyMetadata.getPropertyName() + "' property.").severity(Severity.ERROR)));
            }
            if (propertyMetadata.isAnnotationPresent(Nested.class)) {
                this.validateDefinition(propertyMetadata.getDeclaredReturnType().getRawType(), problems);
            }
        });
    }

    public Map<String, Set<ProjectFeatureImplementation<?, ?>>> getProjectFeatureImplementations() {
        if (this.projectFeatureImplementations == null) {
            this.projectFeatureImplementations = this.discoverProjectFeatureImplementations();
        }
        return this.projectFeatureImplementations;
    }

    public NamedDomainObjectCollectionSchema getSchema() {
        return () -> Iterables.transform(() -> this.getProjectFeatureImplementations().entrySet().stream().flatMap(entry -> ((Set)entry.getValue()).stream().map(impl -> Pair.of((Object)((String)entry.getKey()), (Object)impl))).iterator(), pair -> new ProjectFeatureSchema((String)pair.left, ((ProjectFeatureImplementation)pair.right).getDefinitionPublicType()));
    }

    public static class RegisteringPluginKey {
        public final Class<? extends Plugin<Settings>> pluginClass;
        public final @Nullable String pluginId;

        public RegisteringPluginKey(Class<? extends Plugin<Settings>> pluginClass, @Nullable String pluginId) {
            this.pluginClass = pluginClass;
            this.pluginId = pluginId;
        }

        public boolean equals(Object o) {
            if (!(o instanceof RegisteringPluginKey)) {
                return false;
            }
            RegisteringPluginKey pluginKey = (RegisteringPluginKey)o;
            return Objects.equals(this.pluginClass, pluginKey.pluginClass) && Objects.equals(this.pluginId, pluginKey.pluginId);
        }

        public int hashCode() {
            return Objects.hash(this.pluginClass, this.pluginId);
        }
    }

    private static class ProjectFeatureSchema
    implements NamedDomainObjectCollectionSchema.NamedDomainObjectSchema {
        private final String name;
        private final Class<?> modelPublicType;

        public ProjectFeatureSchema(String name, Class<?> modelPublicType) {
            this.name = name;
            this.modelPublicType = modelPublicType;
        }

        public String getName() {
            return this.name;
        }

        public TypeOf<?> getPublicType() {
            return TypeOf.typeOf(this.modelPublicType);
        }
    }
}

