/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.jline.reader.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import org.jetbrains.kotlin.org.jline.reader.Binding;
import org.jetbrains.kotlin.org.jline.reader.LineReader;
import org.jetbrains.kotlin.org.jline.reader.Macro;
import org.jetbrains.kotlin.org.jline.reader.Reference;
import org.jetbrains.kotlin.org.jline.utils.Log;

public final class InputRC {
    private final LineReader reader;

    public static void configure(LineReader reader, InputStream is) throws IOException {
        try (InputStreamReader r2 = new InputStreamReader(is);){
            InputRC.configure(reader, r2);
        }
    }

    public static void configure(LineReader reader, Reader r2) throws IOException {
        BufferedReader br2 = r2 instanceof BufferedReader ? (BufferedReader)r2 : new BufferedReader(r2);
        reader.getVariables().putIfAbsent("editing-mode", "emacs");
        reader.setKeyMap("main");
        if ("vi".equals(reader.getVariable("editing-mode"))) {
            reader.getKeyMaps().put("main", reader.getKeyMaps().get("viins"));
        } else if ("emacs".equals(reader.getVariable("editing-mode"))) {
            reader.getKeyMaps().put("main", reader.getKeyMaps().get("emacs"));
        }
        new InputRC(reader).parse(br2);
        if ("vi".equals(reader.getVariable("editing-mode"))) {
            reader.getKeyMaps().put("main", reader.getKeyMaps().get("viins"));
        } else if ("emacs".equals(reader.getVariable("editing-mode"))) {
            reader.getKeyMaps().put("main", reader.getKeyMaps().get("emacs"));
        }
    }

    private InputRC(LineReader reader) {
        this.reader = reader;
    }

    private void parse(BufferedReader br2) throws IOException, IllegalArgumentException {
        String line;
        boolean parsing = true;
        ArrayList<Boolean> ifsStack = new ArrayList<Boolean>();
        while ((line = br2.readLine()) != null) {
            try {
                String val;
                if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') continue;
                int i2 = 0;
                if (line.charAt(i2) == '$') {
                    ++i2;
                    while (i2 < line.length() && (line.charAt(i2) == ' ' || line.charAt(i2) == '\t')) {
                        ++i2;
                    }
                    int s2 = i2;
                    while (i2 < line.length() && line.charAt(i2) != ' ' && line.charAt(i2) != '\t') {
                        ++i2;
                    }
                    String cmd = line.substring(s2, i2);
                    while (i2 < line.length() && (line.charAt(i2) == ' ' || line.charAt(i2) == '\t')) {
                        ++i2;
                    }
                    s2 = i2;
                    while (i2 < line.length() && line.charAt(i2) != ' ' && line.charAt(i2) != '\t') {
                        ++i2;
                    }
                    String args = line.substring(s2, i2);
                    if ("if".equalsIgnoreCase(cmd)) {
                        ifsStack.add(parsing);
                        if (!parsing || args.startsWith("term=")) continue;
                        if (args.startsWith("mode=")) {
                            String mode = (String)this.reader.getVariable("editing-mode");
                            parsing = args.substring("mode=".length()).equalsIgnoreCase(mode);
                            continue;
                        }
                        parsing = args.equalsIgnoreCase(this.reader.getAppName());
                        continue;
                    }
                    if ("else".equalsIgnoreCase(cmd)) {
                        if (ifsStack.isEmpty()) {
                            throw new IllegalArgumentException("$else found without matching $if");
                        }
                        boolean invert = true;
                        Iterator iterator2 = ifsStack.iterator();
                        while (iterator2.hasNext()) {
                            boolean b2 = (Boolean)iterator2.next();
                            if (b2) continue;
                            invert = false;
                            break;
                        }
                        if (!invert) continue;
                        parsing = !parsing;
                        continue;
                    }
                    if ("endif".equalsIgnoreCase(cmd)) {
                        if (ifsStack.isEmpty()) {
                            throw new IllegalArgumentException("endif found without matching $if");
                        }
                        parsing = (Boolean)ifsStack.remove(ifsStack.size() - 1);
                        continue;
                    }
                    if (!"include".equalsIgnoreCase(cmd)) continue;
                }
                if (!parsing) continue;
                if (line.charAt(i2++) == '\"') {
                    boolean esc = false;
                    while (true) {
                        if (i2 >= line.length()) {
                            throw new IllegalArgumentException("Missing closing quote on line '" + line + "'");
                        }
                        if (esc) {
                            esc = false;
                        } else if (line.charAt(i2) == '\\') {
                            esc = true;
                        } else if (line.charAt(i2) == '\"') break;
                        ++i2;
                    }
                }
                while (i2 < line.length() && line.charAt(i2) != ':' && line.charAt(i2) != ' ' && line.charAt(i2) != '\t') {
                    ++i2;
                }
                String keySeq = line.substring(0, i2);
                boolean equivalency = i2 + 1 < line.length() && line.charAt(i2) == ':' && line.charAt(i2 + 1) == '=';
                ++i2;
                if (equivalency) {
                    ++i2;
                }
                if (keySeq.equalsIgnoreCase("set")) {
                    while (i2 < line.length() && (line.charAt(i2) == ' ' || line.charAt(i2) == '\t')) {
                        ++i2;
                    }
                    int s3 = i2;
                    while (i2 < line.length() && line.charAt(i2) != ' ' && line.charAt(i2) != '\t') {
                        ++i2;
                    }
                    String key = line.substring(s3, i2);
                    while (i2 < line.length() && (line.charAt(i2) == ' ' || line.charAt(i2) == '\t')) {
                        ++i2;
                    }
                    s3 = i2;
                    while (i2 < line.length() && line.charAt(i2) != ' ' && line.charAt(i2) != '\t') {
                        ++i2;
                    }
                    val = line.substring(s3, i2);
                    InputRC.setVar(this.reader, key, val);
                    continue;
                }
                while (i2 < line.length() && (line.charAt(i2) == ' ' || line.charAt(i2) == '\t')) {
                    ++i2;
                }
                int start = i2;
                if (i2 < line.length() && (line.charAt(i2) == '\'' || line.charAt(i2) == '\"')) {
                    char delim = line.charAt(i2++);
                    boolean esc = false;
                    while (i2 < line.length()) {
                        if (esc) {
                            esc = false;
                        } else if (line.charAt(i2) == '\\') {
                            esc = true;
                        } else if (line.charAt(i2) == delim) break;
                        ++i2;
                    }
                }
                while (i2 < line.length() && line.charAt(i2) != ' ' && line.charAt(i2) != '\t') {
                    ++i2;
                }
                val = line.substring(Math.min(start, line.length()), Math.min(i2, line.length()));
                if (keySeq.charAt(0) == '\"') {
                    keySeq = InputRC.translateQuoted(keySeq);
                } else {
                    String keyName = keySeq.lastIndexOf(45) > 0 ? keySeq.substring(keySeq.lastIndexOf(45) + 1) : keySeq;
                    char key = InputRC.getKeyFromName(keyName);
                    keyName = keySeq.toLowerCase();
                    keySeq = "";
                    if (keyName.contains("meta-") || keyName.contains("m-")) {
                        keySeq = keySeq + "\u001b";
                    }
                    if (keyName.contains("control-") || keyName.contains("c-") || keyName.contains("ctrl-")) {
                        key = (char)(Character.toUpperCase(key) & 0x1F);
                    }
                    keySeq = keySeq + key;
                }
                if (val.length() > 0 && (val.charAt(0) == '\'' || val.charAt(0) == '\"')) {
                    this.reader.getKeys().bind((Binding)new Macro(InputRC.translateQuoted(val)), (CharSequence)keySeq);
                    continue;
                }
                this.reader.getKeys().bind((Binding)new Reference(val), (CharSequence)keySeq);
            }
            catch (IllegalArgumentException e2) {
                Log.warn("Unable to parse user configuration: ", e2);
            }
        }
    }

    private static String translateQuoted(String keySeq) {
        String str = keySeq.substring(1, keySeq.length() - 1);
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < str.length(); ++i2) {
            int c2 = str.charAt(i2);
            if (c2 == 92) {
                boolean meta;
                boolean ctrl = str.regionMatches(i2, "\\C-", 0, 3) || str.regionMatches(i2, "\\M-\\C-", 0, 6);
                if ((i2 += ((meta = str.regionMatches(i2, "\\M-", 0, 3) || str.regionMatches(i2, "\\C-\\M-", 0, 6)) ? 3 : 0) + (ctrl ? 3 : 0) + (!meta && !ctrl ? 1 : 0)) >= str.length()) break;
                c2 = str.charAt(i2);
                if (meta) {
                    sb.append("\u001b");
                }
                if (ctrl) {
                    char c3 = (char)(c2 = (char)(c2 == 63 ? 127 : (char)(Character.toUpperCase((char)c2) & 0x1F)));
                }
                if (!meta && !ctrl) {
                    switch (c2) {
                        case 97: {
                            c2 = 7;
                            break;
                        }
                        case 98: {
                            c2 = 8;
                            break;
                        }
                        case 100: {
                            c2 = 127;
                            break;
                        }
                        case 101: {
                            c2 = 27;
                            break;
                        }
                        case 102: {
                            c2 = 12;
                            break;
                        }
                        case 110: {
                            c2 = 10;
                            break;
                        }
                        case 114: {
                            c2 = 13;
                            break;
                        }
                        case 116: {
                            c2 = 9;
                            break;
                        }
                        case 118: {
                            c2 = 11;
                            break;
                        }
                        case 92: {
                            c2 = 92;
                            break;
                        }
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: {
                            int k2;
                            int j2;
                            c2 = 0;
                            for (j2 = 0; j2 < 3 && i2 < str.length() && (k2 = Character.digit(str.charAt(i2), 8)) >= 0; ++j2, ++i2) {
                                c2 = (char)(c2 * 8 + k2);
                            }
                            c2 = (char)(c2 & 0xFF);
                            break;
                        }
                        case 120: {
                            int k2;
                            int j2;
                            ++i2;
                            c2 = 0;
                            for (j2 = 0; j2 < 2 && i2 < str.length() && (k2 = Character.digit(str.charAt(i2), 16)) >= 0; ++j2, ++i2) {
                                c2 = (char)(c2 * 16 + k2);
                            }
                            c2 = (char)(c2 & 0xFF);
                            break;
                        }
                        case 117: {
                            int k2;
                            int j2;
                            ++i2;
                            c2 = 0;
                            for (j2 = 0; j2 < 4 && i2 < str.length() && (k2 = Character.digit(str.charAt(i2), 16)) >= 0; ++j2, ++i2) {
                                c2 = (char)(c2 * 16 + k2);
                            }
                            break;
                        }
                    }
                }
                sb.append((char)c2);
                continue;
            }
            sb.append((char)c2);
        }
        return sb.toString();
    }

    private static char getKeyFromName(String name2) {
        if ("DEL".equalsIgnoreCase(name2) || "Rubout".equalsIgnoreCase(name2)) {
            return '\u007f';
        }
        if ("ESC".equalsIgnoreCase(name2) || "Escape".equalsIgnoreCase(name2)) {
            return '\u001b';
        }
        if ("LFD".equalsIgnoreCase(name2) || "NewLine".equalsIgnoreCase(name2)) {
            return '\n';
        }
        if ("RET".equalsIgnoreCase(name2) || "Return".equalsIgnoreCase(name2)) {
            return '\r';
        }
        if ("SPC".equalsIgnoreCase(name2) || "Space".equalsIgnoreCase(name2)) {
            return ' ';
        }
        if ("Tab".equalsIgnoreCase(name2)) {
            return '\t';
        }
        return name2.charAt(0);
    }

    static void setVar(LineReader reader, String key, String val) {
        if ("keymap".equalsIgnoreCase(key)) {
            reader.setKeyMap(val);
            return;
        }
        for (LineReader.Option option2 : LineReader.Option.values()) {
            if (!option2.name().toLowerCase(Locale.ENGLISH).replace('_', '-').equals(val)) continue;
            if ("on".equalsIgnoreCase(val)) {
                reader.setOpt(option2);
            } else if ("off".equalsIgnoreCase(val)) {
                reader.unsetOpt(option2);
            }
            return;
        }
        reader.setVariable(key, val);
    }
}

