/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.gradle.api.Describable;
import org.gradle.api.internal.file.FileCollectionStructureVisitor;
import org.gradle.internal.execution.ExecutionContext;
import org.gradle.internal.execution.Identity;
import org.gradle.internal.execution.ImplementationVisitor;
import org.gradle.internal.execution.InputFingerprinter;
import org.gradle.internal.execution.InputVisitor;
import org.gradle.internal.execution.OutputVisitor;
import org.gradle.internal.execution.WorkOutput;
import org.gradle.internal.execution.WorkValidationContext;
import org.gradle.internal.execution.caching.CachingDisabledReason;
import org.gradle.internal.execution.caching.CachingDisabledReasonCategory;
import org.gradle.internal.execution.caching.CachingState;
import org.gradle.internal.execution.history.OverlappingOutputs;
import org.gradle.internal.file.TreeType;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.jspecify.annotations.Nullable;

public interface UnitOfWork
extends Describable {
    public static final CachingDisabledReason NOT_WORTH_CACHING = new CachingDisabledReason(CachingDisabledReasonCategory.NOT_CACHEABLE, "Not worth caching.");

    public Identity identify(Map<String, ValueSnapshot> var1, Map<String, CurrentFileCollectionFingerprint> var2);

    public WorkOutput execute(ExecutionContext var1);

    default public void validate(WorkValidationContext validationContext) {
    }

    default public void visitImplementations(ImplementationVisitor visitor) {
        visitor.visitImplementation(this.getClass());
    }

    default public void visitImmutableInputs(InputVisitor visitor) {
    }

    default public void visitMutableInputs(InputVisitor visitor) {
    }

    public void visitOutputs(File var1, OutputVisitor var2);

    public @Nullable Object loadAlreadyProducedOutput(File var1);

    default public Optional<CachingDisabledReason> shouldDisableCaching(@Nullable OverlappingOutputs detectedOverlappingOutputs) {
        return Optional.empty();
    }

    default public boolean isAllowedToLoadFromCache() {
        return true;
    }

    default public Optional<Duration> getTimeout() {
        return Optional.empty();
    }

    default public void checkOutputDependencies(WorkValidationContext validationContext) {
    }

    public InputFingerprinter getInputFingerprinter();

    default public FileCollectionStructureVisitor getInputDependencyChecker(WorkValidationContext validationContext) {
        return FileCollectionStructureVisitor.NO_OP;
    }

    default public void markLegacySnapshottingInputsStarted() {
    }

    default public void markLegacySnapshottingInputsFinished(CachingState cachingState) {
    }

    default public void ensureLegacySnapshottingInputsClosed() {
    }

    default public Optional<String> getBuildOperationWorkType() {
        return Optional.empty();
    }

    default public List<String> getAllOutputLocationsForInvalidation(File workspace) {
        final ImmutableList.Builder builder = ImmutableList.builder();
        this.visitOutputs(workspace, new OutputVisitor(){

            @Override
            public void visitOutputProperty(String propertyName, TreeType type, OutputVisitor.OutputFileValueSupplier value) {
                builder.add((Object)value.getValue().getAbsolutePath());
            }

            @Override
            public void visitLocalState(File localStateRoot) {
                builder.add((Object)localStateRoot.getAbsolutePath());
            }

            @Override
            public void visitDestroyable(File destroyableRoot) {
                builder.add((Object)destroyableRoot.getAbsolutePath());
            }
        });
        return builder.build();
    }

    default public List<String> getCachedOutputLocationsForInvalidation(File workspace) {
        final ImmutableList.Builder builder = ImmutableList.builder();
        this.visitOutputs(workspace, new OutputVisitor(){

            @Override
            public void visitOutputProperty(String propertyName, TreeType type, OutputVisitor.OutputFileValueSupplier value) {
                builder.add((Object)value.getValue().getAbsolutePath());
            }
        });
        return builder.build();
    }
}

