/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.deps;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.internal.tasks.compile.incremental.compilerapi.CompilerApiData;
import org.gradle.api.internal.tasks.compile.incremental.compilerapi.deps.DependentsSet;
import org.gradle.api.internal.tasks.compile.incremental.compilerapi.deps.GeneratedResource;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassSetAnalysisData;
import org.gradle.api.internal.tasks.compile.incremental.processing.AnnotationProcessingData;

public class ClassSetAnalysis {
    private final ClassSetAnalysisData classAnalysis;
    private final AnnotationProcessingData annotationProcessingData;
    private final CompilerApiData compilerApiData;

    public ClassSetAnalysis(ClassSetAnalysisData classAnalysis) {
        this(classAnalysis, new AnnotationProcessingData(), CompilerApiData.unavailable());
    }

    public ClassSetAnalysis(ClassSetAnalysisData classAnalysis, AnnotationProcessingData annotationProcessingData, CompilerApiData compilerApiData) {
        this.classAnalysis = classAnalysis;
        this.annotationProcessingData = annotationProcessingData;
        this.compilerApiData = compilerApiData;
    }

    public ClassSetDiff findChangesSince(ClassSetAnalysis other) {
        DependentsSet directChanges = this.classAnalysis.getChangedClassesSince(other.classAnalysis);
        if (directChanges.isDependencyToAll()) {
            return new ClassSetDiff(directChanges, Collections.emptyMap());
        }
        DependentsSet transitiveChanges = other.findTransitiveDependents(directChanges.getAllDependentClasses(), Collections.emptyMap());
        if (transitiveChanges.isDependencyToAll()) {
            return new ClassSetDiff(transitiveChanges, Collections.emptyMap());
        }
        DependentsSet allChanges = DependentsSet.merge(Arrays.asList(directChanges, transitiveChanges));
        Map<String, IntSet> changedConstants = this.findChangedConstants(other, allChanges);
        return new ClassSetDiff(allChanges, changedConstants);
    }

    private Map<String, IntSet> findChangedConstants(ClassSetAnalysis other, DependentsSet affectedClasses) {
        if (affectedClasses.isDependencyToAll()) {
            return Collections.emptyMap();
        }
        Set dependentClasses = affectedClasses.getAllDependentClasses();
        HashMap<String, IntSet> result = new HashMap<String, IntSet>(dependentClasses.size());
        for (String affectedClass : dependentClasses) {
            IntOpenHashSet difference = new IntOpenHashSet((IntCollection)other.getConstants(affectedClass));
            difference.removeAll((IntCollection)this.getConstants(affectedClass));
            result.put(affectedClass, (IntSet)difference);
        }
        return result;
    }

    public DependentsSet findTransitiveDependents(Collection<String> classes, Map<String, IntSet> changedConstantsByClass) {
        if (classes.isEmpty()) {
            return DependentsSet.empty();
        }
        String fullRebuildCause = this.annotationProcessingData.getFullRebuildCause();
        if (fullRebuildCause != null) {
            return DependentsSet.dependencyToAll((String)fullRebuildCause);
        }
        if (!this.compilerApiData.isSupportsConstantsMapping()) {
            for (Map.Entry<String, IntSet> changedConstantsOfClass : changedConstantsByClass.entrySet()) {
                if (changedConstantsOfClass.getValue().isEmpty()) continue;
                return DependentsSet.dependencyToAll((String)("an inlineable constant in '" + changedConstantsOfClass.getKey() + "' has changed"));
            }
        }
        HashSet privateDependents = new HashSet();
        HashSet<String> accessibleDependents = new HashSet<String>();
        HashSet<GeneratedResource> dependentResources = new HashSet<GeneratedResource>(this.annotationProcessingData.getGeneratedResourcesDependingOnAllOthers());
        HashSet<String> visited = new HashSet<String>();
        ArrayDeque<String> remaining = new ArrayDeque<String>(classes);
        remaining.addAll(this.annotationProcessingData.getGeneratedTypesDependingOnAllOthers());
        while (!remaining.isEmpty()) {
            String current = (String)remaining.pop();
            if (!visited.add(current)) continue;
            accessibleDependents.add(current);
            DependentsSet dependents = this.findDirectDependents(current);
            if (dependents.isDependencyToAll()) {
                return dependents;
            }
            dependentResources.addAll(dependents.getDependentResources());
            privateDependents.addAll(dependents.getPrivateDependentClasses());
            remaining.addAll(dependents.getAccessibleDependentClasses());
        }
        privateDependents.removeAll(classes);
        accessibleDependents.removeAll(classes);
        return DependentsSet.dependents(privateDependents, accessibleDependents, dependentResources);
    }

    private DependentsSet findDirectDependents(String className) {
        DependentsSet annotationProcessingDependentsSet = this.getAnnotationProcessingDependentsSet(className);
        return DependentsSet.merge(Arrays.asList(this.classAnalysis.getDependents(className), this.compilerApiData.getConstantDependentsForClass(className), annotationProcessingDependentsSet));
    }

    public DependentsSet getAnnotationProcessingDependentsSet(String className) {
        Set generatedClasses = this.annotationProcessingData.getGeneratedTypesByOrigin().getOrDefault(className, Collections.emptySet());
        Set generatedResources = this.annotationProcessingData.getGeneratedResourcesByOrigin().getOrDefault(className, Collections.emptySet());
        return DependentsSet.dependents(Collections.emptySet(), generatedClasses, generatedResources);
    }

    public Set<String> getTypesToReprocess(Set<String> compiledClasses) {
        if (compiledClasses.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> typesToReprocess = new HashSet<String>(this.annotationProcessingData.getAggregatedTypes());
        for (Map.Entry<String, Set<String>> entry : this.annotationProcessingData.getGeneratedTypesByOrigin().entrySet()) {
            if (!entry.getValue().stream().anyMatch(compiledClasses::contains)) continue;
            typesToReprocess.add(entry.getKey());
        }
        for (String toReprocess : new ArrayList<String>(typesToReprocess)) {
            typesToReprocess.removeAll(this.annotationProcessingData.getGeneratedTypesByOrigin().getOrDefault(toReprocess, Collections.emptySet()));
        }
        return typesToReprocess;
    }

    public IntSet getConstants(String className) {
        return this.classAnalysis.getConstants(className);
    }

    public static final class ClassSetDiff {
        private final DependentsSet dependents;
        private final Map<String, IntSet> constants;

        public ClassSetDiff(DependentsSet dependents, Map<String, IntSet> constants) {
            this.dependents = dependents;
            this.constants = constants;
        }

        public DependentsSet getDependents() {
            return this.dependents;
        }

        public Map<String, IntSet> getConstants() {
            return this.constants;
        }
    }
}

