/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resources;

import org.gradle.internal.resources.AbstractTrackedResourceLock;
import org.gradle.internal.resources.LeaseHolder;
import org.gradle.internal.resources.ResourceLockContainer;
import org.gradle.internal.resources.ResourceLockCoordinationService;
import org.jspecify.annotations.Nullable;

public class DefaultLease
extends AbstractTrackedResourceLock {
    private final LeaseHolder parent;
    private @Nullable Thread ownerThread;

    public DefaultLease(String displayName, ResourceLockCoordinationService coordinationService, ResourceLockContainer owner, LeaseHolder parent) {
        super(displayName, coordinationService, owner);
        this.parent = parent;
    }

    @Override
    protected boolean doIsLocked() {
        return this.ownerThread != null;
    }

    @Override
    protected boolean doIsLockedByCurrentThread() {
        return Thread.currentThread() == this.ownerThread;
    }

    @Override
    protected boolean acquireLock() {
        if (this.parent.grantLease()) {
            this.ownerThread = Thread.currentThread();
        }
        return this.ownerThread != null;
    }

    @Override
    protected void releaseLock() {
        if (Thread.currentThread() != this.ownerThread) {
            throw new UnsupportedOperationException("Must complete operation from owner thread.");
        }
        this.parent.releaseLease();
        this.ownerThread = null;
    }
}

