/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.gradle.api.internal.ClassPathProvider;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyFactoryInternal;
import org.gradle.api.internal.classpath.ModuleRegistry;
import org.gradle.api.internal.classpath.PluginModuleRegistry;
import org.gradle.internal.classpath.ClassPath;

public class DependencyClassPathProvider
implements ClassPathProvider {
    private static final List<String> GRADLE_API_ENTRY_POINTS = Arrays.asList("gradle-worker-main", "gradle-launcher", "gradle-workers", "gradle-dependency-management", "gradle-plugin-use", "gradle-tooling-api-builders", "gradle-configuration-cache", "gradle-isolated-action-services", "gradle-unit-test-fixtures");
    public static final Set<String> GROOVY_MODULES = ImmutableSet.of((Object)"groovy", (Object)"groovy-ant", (Object)"groovy-astbuilder", (Object)"groovy-datetime", (Object)"groovy-dateutil", (Object)"groovy-groovydoc", (Object[])new String[]{"groovy-json", "groovy-nio", "groovy-templates", "groovy-xml"});
    private final ModuleRegistry moduleRegistry;
    private final PluginModuleRegistry pluginModuleRegistry;
    private ClassPath gradleApi;

    public DependencyClassPathProvider(ModuleRegistry moduleRegistry, PluginModuleRegistry pluginModuleRegistry) {
        this.moduleRegistry = moduleRegistry;
        this.pluginModuleRegistry = pluginModuleRegistry;
    }

    public ClassPath findClassPath(String name) {
        if (name.equals(DependencyFactoryInternal.ClassPathNotation.GRADLE_API.name())) {
            return this.gradleApi();
        }
        if (name.equals(DependencyFactoryInternal.ClassPathNotation.GRADLE_TEST_KIT.name())) {
            return this.gradleTestKit();
        }
        if (name.equals(DependencyFactoryInternal.ClassPathNotation.LOCAL_GROOVY.name())) {
            return this.localGroovy();
        }
        if (name.equals(DependencyFactoryInternal.ClassPathNotation.GRADLE_KOTLIN_DSL.name())) {
            return this.gradleKotlinDsl();
        }
        return null;
    }

    private ClassPath gradleApi() {
        if (this.gradleApi == null) {
            this.gradleApi = this.initGradleApi();
        }
        return this.gradleApi;
    }

    private ClassPath initGradleApi() {
        Iterable apiEntryModules = Iterables.transform(GRADLE_API_ENTRY_POINTS, arg_0 -> ((ModuleRegistry)this.moduleRegistry).getModule(arg_0));
        Iterable rootModules = Iterables.concat((Iterable)apiEntryModules, this.pluginModuleRegistry.getApiModules());
        ClassPath classpath = this.moduleRegistry.getRuntimeClasspath(rootModules);
        return classpath.removeIf(f -> f.getName().startsWith("kotlin-sam-with-receiver-compiler-plugin"));
    }

    private ClassPath gradleTestKit() {
        return this.moduleRegistry.getRuntimeClasspath("gradle-test-kit");
    }

    private ClassPath localGroovy() {
        ClassPath groovy = ClassPath.EMPTY;
        for (String groovyModule : GROOVY_MODULES) {
            groovy = groovy.plus(this.moduleRegistry.getModule(groovyModule).getImplementationClasspath());
        }
        groovy = groovy.plus(this.moduleRegistry.getModule("javaparser-core").getImplementationClasspath());
        return groovy;
    }

    private ClassPath gradleKotlinDsl() {
        return this.moduleRegistry.getRuntimeClasspath("gradle-kotlin-dsl");
    }
}

