/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import com.google.common.collect.Lists;
import groovy.lang.Closure;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.DomainObjectCollectionInternal;
import org.gradle.api.internal.collections.CollectionEventRegister;
import org.gradle.api.internal.collections.CollectionFilter;
import org.gradle.api.internal.collections.DefaultCollectionEventRegister;
import org.gradle.api.internal.collections.ElementSource;
import org.gradle.api.internal.collections.FilteredElementSource;
import org.gradle.api.internal.lambdas.SerializableLambdas;
import org.gradle.api.internal.provider.CollectionProviderInternal;
import org.gradle.api.internal.provider.DefaultListProperty;
import org.gradle.api.internal.provider.PropertyHost;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.internal.Cast;
import org.gradle.internal.ImmutableActionSet;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.util.internal.ConfigureUtil;

public class DefaultDomainObjectCollection<T>
extends AbstractCollection<T>
implements DomainObjectCollectionInternal<T> {
    private final Class<? extends T> type;
    private final CollectionEventRegister<T> eventRegister;
    private final ElementSource<T> store;
    private ImmutableActionSet<String> beforeContainerChange = ImmutableActionSet.empty();

    protected DefaultDomainObjectCollection(Class<? extends T> type, ElementSource<T> store, CollectionCallbackActionDecorator callbackActionDecorator) {
        this(type, store, new DefaultCollectionEventRegister<T>(type, callbackActionDecorator));
    }

    protected DefaultDomainObjectCollection(Class<? extends T> type, ElementSource<T> store, CollectionEventRegister<T> eventRegister) {
        this.type = type;
        this.store = store;
        this.eventRegister = eventRegister;
        this.store.onPendingAdded(SerializableLambdas.action((SerializableLambdas.SerializableAction & Serializable)toAdd -> {
            this.didAdd(toAdd);
            eventRegister.fireObjectAdded(toAdd);
        }));
        this.store.setSubscriptionVerifier(eventRegister);
    }

    protected DefaultDomainObjectCollection(DefaultDomainObjectCollection<? super T> collection, CollectionFilter<T> filter) {
        this(filter.getType(), collection.filteredStore(filter), collection.filteredEvents(filter));
    }

    protected void realized(ProviderInternal<? extends T> provider) {
        this.getStore().realizeExternal(provider);
    }

    public Class<? extends T> getType() {
        return this.type;
    }

    public String getDisplayName() {
        return this.getTypeDisplayName() + " collection";
    }

    @Override
    public String toString() {
        return this.getDisplayName();
    }

    protected String getTypeDisplayName() {
        return this.getType().getSimpleName();
    }

    protected ElementSource<T> getStore() {
        return this.store;
    }

    protected CollectionEventRegister<T> getEventRegister() {
        return this.eventRegister;
    }

    protected CollectionFilter<T> createFilter(Spec<? super T> filter) {
        return new CollectionFilter<T>(this.type, this.eventRegister.getDecorator().decorateSpec(filter));
    }

    protected <S extends T> CollectionFilter<S> createFilter(Class<S> type) {
        return new CollectionFilter<S>(type);
    }

    protected <S extends T> DefaultDomainObjectCollection<S> filtered(CollectionFilter<S> filter) {
        return new DefaultDomainObjectCollection<S>(this, filter);
    }

    protected <S extends T> ElementSource<S> filteredStore(CollectionFilter<S> filter) {
        return this.filteredStore(filter, this.store);
    }

    protected <S extends T> ElementSource<S> filteredStore(CollectionFilter<S> filter, ElementSource<T> elementSource) {
        return new FilteredElementSource<T, S>(elementSource, filter);
    }

    protected <S extends T> CollectionEventRegister<S> filteredEvents(CollectionFilter<S> filter) {
        return this.eventRegister.filtered(filter);
    }

    public DomainObjectCollection<T> matching(Spec<? super T> spec) {
        return this.filtered(this.createFilter(spec));
    }

    public DomainObjectCollection<T> matching(Closure spec) {
        return this.matching(Specs.convertClosureToSpec((Closure)spec));
    }

    public <S extends T> DomainObjectCollection<S> withType(Class<S> type) {
        return this.filtered(this.createFilter(type));
    }

    @Override
    public Iterator<T> iterator() {
        return new IteratorImpl(this.store.iterator());
    }

    Iterator<T> iteratorNoFlush() {
        if (this.store.constantTimeIsEmpty()) {
            return Collections.emptyIterator();
        }
        return new IteratorImpl(this.store.iteratorNoFlush());
    }

    public void all(Action<? super T> action) {
        this.assertEagerContext("all(Action)");
        Action<? super T> decoratedAction = this.addEagerAction(action);
        if (this.store.constantTimeIsEmpty()) {
            return;
        }
        ArrayList<T> copied = null;
        for (Object t : this) {
            if (copied == null) {
                copied = new ArrayList<T>(this.estimatedSize());
            }
            copied.add(t);
        }
        if (copied != null) {
            for (Object t : copied) {
                decoratedAction.execute(t);
            }
        }
    }

    public void configureEach(Action<? super T> action) {
        this.assertEagerContext("configureEach(Action)");
        Action<? super T> wrappedAction = this.wrapLazyAction(this.decorate(action));
        Action<? super T> registerLazyAddActionDecorated = this.eventRegister.registerLazyAddAction(wrappedAction);
        ArrayList<T> copied = null;
        Iterator<T> iterator = this.iteratorNoFlush();
        while (iterator.hasNext()) {
            if (copied == null) {
                copied = new ArrayList<T>(this.estimatedSize());
            }
            copied.add(iterator.next());
        }
        if (copied != null) {
            for (Object next : copied) {
                registerLazyAddActionDecorated.execute(next);
            }
        }
    }

    protected <I extends T> Action<? super I> wrapLazyAction(Action<? super I> action) {
        return this.store.getLazyBehaviorGuard().wrapLazyAction(action);
    }

    public void all(Closure action) {
        this.all(this.toAction(action));
    }

    public <S extends T> DomainObjectCollection<S> withType(Class<S> type, Action<? super S> configureAction) {
        this.assertEagerContext("withType(Class, Action)");
        DomainObjectCollection<S> result = this.withType(type);
        result.all(configureAction);
        return result;
    }

    public <S extends T> DomainObjectCollection<S> withType(Class<S> type, Closure configureClosure) {
        return this.withType(type, this.toAction(configureClosure));
    }

    public Action<? super T> whenObjectAdded(Action<? super T> action) {
        this.assertEagerContext("whenObjectAdded(Action)");
        return this.addEagerAction(action);
    }

    public void whenObjectAdded(Closure action) {
        this.whenObjectAdded(this.toAction(action));
    }

    private Action<? super T> addEagerAction(Action<? super T> action) {
        this.store.realizePending(this.type);
        return this.eventRegister.registerEagerAddAction(this.type, this.decorate(action));
    }

    public Action<? super T> whenObjectRemoved(Action<? super T> action) {
        this.eventRegister.registerRemoveAction(this.type, this.decorate(action));
        return action;
    }

    public void whenObjectRemoved(Closure action) {
        this.whenObjectRemoved(this.toAction(action));
    }

    private Action<? super T> decorate(Action<? super T> action) {
        return this.eventRegister.getDecorator().decorate(action);
    }

    private Action<? super T> toAction(Closure action) {
        return ConfigureUtil.configureUsing((Closure)action);
    }

    @Override
    public boolean add(T toAdd) {
        this.assertCanMutate("add(T)");
        return this.doAdd((Object)toAdd, (Action)this.eventRegister.getAddActions());
    }

    protected <I extends T> boolean doAdd(I toAdd, Action<? super I> notification) {
        if (this.getStore().add(toAdd)) {
            this.didAdd(toAdd);
            notification.execute(toAdd);
            return true;
        }
        return false;
    }

    public void addLater(Provider<? extends T> provider) {
        this.assertCanMutate("addLater(Provider)");
        this.doAddLater(provider);
    }

    protected void doAddLater(Provider<? extends T> provider) {
        ProviderInternal providerInternal = Providers.internal(provider);
        this.store.addPending(providerInternal);
    }

    public void addAllLater(Provider<? extends Iterable<T>> provider) {
        CollectionProviderInternal providerInternal;
        this.assertCanMutate("addAllLater(Provider)");
        if (provider instanceof CollectionProviderInternal) {
            providerInternal = (CollectionProviderInternal)Cast.uncheckedCast(provider);
        } else {
            DefaultListProperty defaultListProperty = new DefaultListProperty(PropertyHost.NO_OP, (Class)Cast.uncheckedCast(this.getType()));
            defaultListProperty.convention(provider);
            providerInternal = defaultListProperty;
        }
        this.store.addPendingCollection(providerInternal);
    }

    protected void didAdd(T toAdd) {
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        this.assertCanMutate("addAll(Collection)");
        boolean changed = false;
        for (T o : c) {
            if (!this.doAdd((Object)o, (Action)this.eventRegister.getAddActions())) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public void clear() {
        this.assertCanMutate("clear()");
        if (this.store.constantTimeIsEmpty()) {
            return;
        }
        ArrayList c = Lists.newArrayList(this.store.iteratorNoFlush());
        this.getStore().clear();
        for (Object o : c) {
            this.eventRegister.fireObjectRemoved(o);
        }
    }

    @Override
    public boolean contains(Object o) {
        return this.getStore().contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.getStore().containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.getStore().isEmpty();
    }

    @Override
    public boolean remove(Object o) {
        this.assertCanMutate("remove(Object)");
        return this.doRemove(o);
    }

    private boolean doRemove(Object o) {
        if (o instanceof ProviderInternal) {
            ProviderInternal providerInternal = (ProviderInternal)Cast.uncheckedCast((Object)o);
            if (this.getStore().removePending(providerInternal)) {
                this.didRemove(providerInternal);
                return true;
            }
            if (this.getType().isAssignableFrom(providerInternal.getType()) && providerInternal.isPresent()) {
                o = providerInternal.get();
            }
        }
        if (this.getStore().remove(o)) {
            Object cast = o;
            this.didRemove(cast);
            this.eventRegister.fireObjectRemoved(cast);
            return true;
        }
        return false;
    }

    protected void didRemove(T t) {
    }

    protected void didRemove(ProviderInternal<? extends T> t) {
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.assertCanMutate("removeAll(Collection)");
        if (this.store.constantTimeIsEmpty()) {
            return false;
        }
        boolean changed = false;
        for (Object o : c) {
            if (!this.doRemove(o)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> target) {
        this.assertCanMutate("retainAll(Collection)");
        Object[] existingItems = this.toArray();
        boolean changed = false;
        for (Object existingItem : existingItems) {
            if (target.contains(existingItem)) continue;
            this.doRemove(existingItem);
            changed = true;
        }
        return changed;
    }

    @Override
    public int size() {
        return this.store.size();
    }

    @Override
    public int estimatedSize() {
        return this.store.estimatedSize();
    }

    @Deprecated
    public Collection<T> findAll(Closure cl) {
        return this.findAll(cl, new ArrayList());
    }

    @Deprecated
    protected <S extends Collection<? super T>> S findAll(Closure cl, S matches) {
        ((DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.deprecateMethod(DomainObjectCollection.class, (String)"findAll(Closure)").willBeRemovedInGradle10().withUpgradeGuideSection(9, "findAll_removal")).nagUser();
        if (this.store.constantTimeIsEmpty()) {
            return matches;
        }
        for (T t : this.filteredStore(this.createFilter(Specs.convertClosureToSpec((Closure)cl)))) {
            matches.add(t);
        }
        return matches;
    }

    protected final void assertCanMutate(String methodName) {
        this.beforeContainerChange.execute((Object)methodName);
        this.assertEagerContext(methodName);
    }

    protected final void assertEagerContext(String methodName) {
        this.store.getLazyBehaviorGuard().assertEagerContext(methodName, this);
    }

    @Override
    public void beforeCollectionChanges(Action<String> action) {
        this.beforeContainerChange = this.beforeContainerChange.add(action);
    }

    protected class IteratorImpl
    implements Iterator<T> {
        private final Iterator<T> iterator;
        private T currentElement;

        public IteratorImpl(Iterator<T> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            this.currentElement = this.iterator.next();
            return this.currentElement;
        }

        @Override
        public void remove() {
            DefaultDomainObjectCollection.this.assertCanMutate("iterator().remove()");
            this.iterator.remove();
            DefaultDomainObjectCollection.this.didRemove(this.currentElement);
            DefaultDomainObjectCollection.this.getEventRegister().fireObjectRemoved(this.currentElement);
            this.currentElement = null;
        }
    }
}

