/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import org.gradle.cache.CacheCleanupStrategy;
import org.gradle.cache.CacheOpenException;
import org.gradle.cache.FineGrainedCacheBuilder;
import org.gradle.cache.FineGrainedCacheCleanupStrategy;
import org.gradle.cache.FineGrainedPersistentCache;
import org.gradle.cache.internal.CacheFactory;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class DefaultFineGrainedCacheBuilder
implements FineGrainedCacheBuilder {
    private final CacheFactory factory;
    private final File baseDir;
    private @Nullable FineGrainedCacheCleanupStrategy cleanupStrategy;
    private String displayName = "<unnamed>";

    public DefaultFineGrainedCacheBuilder(CacheFactory factory, File baseDir) {
        this.factory = factory;
        this.baseDir = baseDir;
    }

    @Override
    public FineGrainedCacheBuilder withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    public FineGrainedCacheBuilder withCleanupStrategy(FineGrainedCacheCleanupStrategy cacheCleanupStrategy) {
        this.cleanupStrategy = cacheCleanupStrategy;
        return this;
    }

    @Override
    public FineGrainedPersistentCache open() throws CacheOpenException {
        FineGrainedCacheCleanupStrategy cleanupStrategy = this.cleanupStrategy == null ? () -> CacheCleanupStrategy.NO_CLEANUP : this.cleanupStrategy;
        return this.factory.openFineGrained(this.baseDir, this.displayName, cleanupStrategy);
    }
}

