/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import org.gradle.internal.execution.MutableUnitOfWork;
import org.gradle.internal.execution.history.changes.ExecutionStateChanges;
import org.gradle.internal.execution.history.changes.InputChangesInternal;
import org.gradle.internal.execution.steps.InputChangesContext;
import org.gradle.internal.execution.steps.MutableCachingContext;
import org.gradle.internal.execution.steps.MutableChangesContext;
import org.gradle.internal.execution.steps.MutableStep;
import org.gradle.internal.execution.steps.MutableValidationFinishedContext;
import org.gradle.internal.execution.steps.Result;
import org.gradle.internal.execution.steps.Step;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolveInputChangesStep<C extends MutableCachingContext, R extends Result>
extends MutableStep<C, R> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResolveInputChangesStep.class);
    private final Step<? super InputChangesContext, ? extends R> delegate;

    public ResolveInputChangesStep(Step<? super InputChangesContext, ? extends R> delegate) {
        this.delegate = delegate;
    }

    @Override
    protected R executeMutable(MutableUnitOfWork work, C context) {
        return this.delegate.execute(work, new InputChangesContext((MutableValidationFinishedContext)context, ResolveInputChangesStep.determineInputChanges(work, context), ((MutableCachingContext)context).getCachingState()));
    }

    private static @Nullable InputChangesInternal determineInputChanges(MutableUnitOfWork work, MutableChangesContext context) {
        if (work.getExecutionBehavior() == MutableUnitOfWork.ExecutionBehavior.NON_INCREMENTAL) {
            return null;
        }
        ExecutionStateChanges changes = context.getChanges().orElseThrow(() -> new IllegalStateException("Changes are not tracked, unable determine incremental changes."));
        InputChangesInternal inputChanges = changes.createInputChanges();
        if (!inputChanges.isIncremental()) {
            LOGGER.info("The input changes require a full rebuild for incremental {}.", (Object)work.getDisplayName());
        }
        return inputChanges;
    }
}

