/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.collect;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import org.gradle.internal.collect.ArrayCopy;
import org.gradle.internal.collect.MutableBoolean;
import org.gradle.internal.collect.PersistentArray;
import org.gradle.internal.collect.ToString;
import org.gradle.util.internal.ArrayUtils;

final class PersistentArrayTrie<T>
implements PersistentArray<T> {
    static final int WIDTH = 32;
    private static final int BITS = 5;
    private static final int BITMASK = 31;
    private final int size;
    private final int shift;
    private final Object[] root;
    private final Object[] tail;

    public PersistentArrayTrie(int size, int shift, Object[] root, Object[] tail) {
        this.size = size;
        this.shift = shift;
        this.root = root;
        this.tail = tail;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public int hashCode() {
        int hashCode = 1;
        for (int i = 0; i < this.size; i += 32) {
            hashCode += 31 * hashCode + Arrays.hashCode(this.arrayStartingAt(i));
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PersistentArrayTrie) {
            PersistentArrayTrie other = (PersistentArrayTrie)obj;
            if (this.size != other.size) {
                return false;
            }
            for (int i = 0; i < this.size; i += 32) {
                if (Arrays.equals(this.arrayStartingAt(i), other.arrayStartingAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return ToString.nonEmptyIterator(this.iterator());
    }

    @Override
    public T get(int index) {
        int tailOffset = this.size - this.tail.length;
        if (index < tailOffset) {
            if (index < 0) {
                throw PersistentArrayTrie.indexOutOfBounds(index);
            }
            Object[] array = this.root;
            for (int i = this.shift; i != 0; i -= 5) {
                int nodeIndex = index >>> i & 0x1F;
                array = (Object[])array[nodeIndex];
            }
            return (T)array[index & 0x1F];
        }
        if (index >= this.size) {
            throw PersistentArrayTrie.indexOutOfBounds(index);
        }
        return (T)this.tail[index - tailOffset];
    }

    @Override
    public PersistentArray<T> set(int index, T value) {
        int tailOffset = this.size - this.tail.length;
        if (index < tailOffset) {
            Object[] newRoot;
            if (index < 0) {
                throw PersistentArrayTrie.indexOutOfBounds(index);
            }
            Object[] array = newRoot = (Object[])this.root.clone();
            for (int i = this.shift; i != 0; i -= 5) {
                Object[] node;
                int nodeIndex = index >>> i & 0x1F;
                array[nodeIndex] = node = (Object[])((Object[])array[nodeIndex]).clone();
                array = node;
            }
            array[index & 0x1F] = value;
            return new PersistentArrayTrie<T>(this.size, this.shift, newRoot, this.tail);
        }
        if (index >= this.size) {
            throw PersistentArrayTrie.indexOutOfBounds(index);
        }
        Object[] newTail = (Object[])this.tail.clone();
        newTail[index - tailOffset] = value;
        return new PersistentArrayTrie<T>(this.size, this.shift, this.root, newTail);
    }

    @Override
    public T getLast() {
        return (T)this.tail[this.tail.length - 1];
    }

    @Override
    public PersistentArray<T> plus(T value) {
        int newShift;
        Object[] newRoot;
        if (this.tail.length < 32) {
            return new PersistentArrayTrie<T>(this.size + 1, this.shift, this.root, ArrayCopy.append(this.tail, value));
        }
        if (this.size - this.tail.length != 32 << this.shift) {
            MutableBoolean overflow = new MutableBoolean(false);
            newRoot = PersistentArrayTrie.pushTail(this.shift, this.root, this.tail, overflow);
            assert (!overflow.value);
            newShift = this.shift;
        } else {
            newRoot = new Object[]{this.root, PersistentArrayTrie.createTailPath(this.shift, this.tail)};
            newShift = this.shift + 5;
        }
        return new PersistentArrayTrie<T>(this.size + 1, newShift, newRoot, new Object[]{value});
    }

    private static Object createTailPath(int shift, Object[] tail) {
        Object[] path = tail;
        for (int i = shift; i > 0; i -= 5) {
            path = new Object[]{path};
        }
        return path;
    }

    private static Object[] pushTail(int shift, Object[] nodes, Object[] tail, MutableBoolean overflow) {
        if (shift > 5) {
            int length = nodes.length;
            int tailIndex = length - 1;
            Object[] newTail = PersistentArrayTrie.pushTail(shift - 5, (Object[])nodes[tailIndex], tail, overflow);
            if (!overflow.value) {
                return ArrayCopy.replaceAt(tailIndex, nodes, newTail);
            }
            if (length < 32) {
                overflow.value = false;
                return ArrayCopy.append(nodes, newTail);
            }
            return new Object[]{newTail};
        }
        if (nodes.length < 32) {
            return ArrayCopy.append(nodes, tail);
        }
        overflow.value = true;
        return new Object[]{tail};
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int index = 0;
            final int count = PersistentArrayTrie.access$000(PersistentArrayTrie.this);
            Object[] array = ArrayCopy.EMPTY_ARRAY;

            @Override
            public boolean hasNext() {
                return this.index < this.count;
            }

            @Override
            public T next() {
                if (this.index < this.count) {
                    int next = this.index & 0x1F;
                    if (next == 0) {
                        this.array = PersistentArrayTrie.this.arrayStartingAt(this.index);
                    }
                    ++this.index;
                    return this.array[next];
                }
                throw new NoSuchElementException();
            }
        };
    }

    @Override
    public boolean contains(T value) {
        for (int i = 0; i < this.size; i += 32) {
            if (!ArrayUtils.contains((Object[])this.arrayStartingAt(i), value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        for (int i = 0; i < this.size; i += 32) {
            for (Object value : this.arrayStartingAt(i)) {
                action.accept(value);
            }
        }
    }

    private Object[] arrayStartingAt(int index) {
        if (index < this.size - this.tail.length) {
            Object[] array = this.root;
            for (int i = this.shift; i > 0; i -= 5) {
                int nodeIndex = index >>> i & 0x1F;
                array = (Object[])array[nodeIndex];
            }
            return array;
        }
        return this.tail;
    }

    static IndexOutOfBoundsException indexOutOfBounds(int index) {
        return new IndexOutOfBoundsException("Index out of range: " + index);
    }

    static /* synthetic */ int access$000(PersistentArrayTrie x0) {
        return x0.size;
    }
}

