/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.connection;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.internal.consumer.PhasedBuildAction;
import org.gradle.tooling.internal.consumer.TestExecutionRequest;
import org.gradle.tooling.internal.consumer.connection.AbstractConsumerConnection;
import org.gradle.tooling.internal.consumer.connection.HelpModelCompatibilityHelper;
import org.gradle.tooling.internal.consumer.parameters.ConsumerOperationParameters;
import org.gradle.tooling.internal.consumer.versioning.VersionDetails;
import org.gradle.tooling.internal.protocol.ConnectionVersion4;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.tooling.model.build.Help;
import org.gradle.tooling.model.internal.Exceptions;

public abstract class HelpAndVersionHandlingConsumerConnection
extends AbstractConsumerConnection {
    public HelpAndVersionHandlingConsumerConnection(ConnectionVersion4 delegate, VersionDetails providerMetaData) {
        super(delegate, providerMetaData);
    }

    @Override
    public <T> T run(Class<T> type, ConsumerOperationParameters operationParameters) {
        if (operationParameters.containsHelpOrVersionArgs() && type == Void.class) {
            return this.handleHelpOrVersion(type, operationParameters);
        }
        return this.getModelProducer().produceModel(type, HelpAndVersionHandlingConsumerConnection.removeHelpVersionArgs(operationParameters));
    }

    @Override
    public <T> T run(BuildAction<T> action, ConsumerOperationParameters operationParameters) {
        return this.getActionRunner().run(action, HelpAndVersionHandlingConsumerConnection.removeHelpVersionArgs(operationParameters));
    }

    @Override
    public void run(PhasedBuildAction phasedBuildAction, ConsumerOperationParameters operationParameters) {
        this.doRun(phasedBuildAction, HelpAndVersionHandlingConsumerConnection.removeHelpVersionArgs(operationParameters));
    }

    protected void doRun(PhasedBuildAction phasedBuildAction, ConsumerOperationParameters operationParameters) {
        throw Exceptions.unsupportedFeature(operationParameters.getEntryPointName(), this.getVersionDetails().getVersion(), "4.8");
    }

    @Override
    public void runTests(TestExecutionRequest testExecutionRequest, ConsumerOperationParameters operationParameters) {
        this.doRunTests(testExecutionRequest, HelpAndVersionHandlingConsumerConnection.removeHelpVersionArgs(operationParameters));
    }

    protected void doRunTests(TestExecutionRequest testExecutionRequest, ConsumerOperationParameters operationParameters) {
        throw Exceptions.unsupportedFeature(operationParameters.getEntryPointName(), this.getVersionDetails().getVersion(), "2.6");
    }

    private <T> T handleHelpOrVersion(Class<T> type, ConsumerOperationParameters operationParameters) {
        boolean containsHelpArg = operationParameters.containsHelpArg();
        boolean containsVersionArg = operationParameters.containsVersionArg();
        boolean containsShowVersionArg = operationParameters.containsShowVersionArg();
        ConsumerOperationParameters cleanParams = operationParameters.withoutHelpOrVersionArgs();
        ConsumerOperationParameters modelParams = cleanParams.withNoTasks();
        if (containsHelpArg) {
            this.queryAndPrintHelp(operationParameters, modelParams);
            return null;
        }
        if (containsVersionArg || containsShowVersionArg) {
            this.queryAndPrintVersion(operationParameters, modelParams);
        }
        if (containsVersionArg) {
            return null;
        }
        if (containsShowVersionArg) {
            return this.getModelProducer().produceModel(type, cleanParams);
        }
        return null;
    }

    private void queryAndPrintHelp(ConsumerOperationParameters operationParameters, ConsumerOperationParameters modelParams) {
        OutputStream standardOutput = operationParameters.getStandardOutput();
        if (this.getVersionDetails().supportsHelpToolingModel()) {
            Help helpModel = this.getModelProducer().produceModel(Help.class, modelParams);
            HelpAndVersionHandlingConsumerConnection.print(standardOutput, helpModel.getRenderedText());
        } else {
            String renderedText = HelpModelCompatibilityHelper.getRenderedText(this.getVersionDetails().getVersion());
            HelpAndVersionHandlingConsumerConnection.print(standardOutput, renderedText);
        }
    }

    private void queryAndPrintVersion(ConsumerOperationParameters operationParameters, ConsumerOperationParameters modelParams) {
        BuildEnvironment env = this.getModelProducer().produceModel(BuildEnvironment.class, modelParams);
        OutputStream standardOutput = operationParameters.getStandardOutput();
        String output = env.getVersionInfo();
        HelpAndVersionHandlingConsumerConnection.print(standardOutput, output);
    }

    private static void print(OutputStream stdOut, String content) {
        try {
            if (stdOut != null) {
                stdOut.write(content.getBytes(StandardCharsets.UTF_8));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot write to stdout", e);
        }
    }

    private static ConsumerOperationParameters removeHelpVersionArgs(ConsumerOperationParameters parameters) {
        if (!parameters.containsHelpOrVersionArgs()) {
            return parameters;
        }
        HelpAndVersionHandlingConsumerConnection.print(parameters.getStandardError(), "The Tooling API does not support --help, --version or --show-version arguments for this operation. These arguments have been ignored.");
        return parameters.withoutHelpOrVersionArgs();
    }
}

