/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.runtimeshaded;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.internal.util.Trie;
import org.objectweb.asm.commons.Remapper;

class ImplementationDependencyRelocator
extends Remapper {
    private final Pattern classPattern = Pattern.compile("(\\[*)?L(.+)");
    private final Trie prefixes;
    private final List<String> mustRelocateList = Arrays.asList("com/sun/jna", "org/apache/groovy", "org/eclipse/jgit");

    private static Trie readPrefixes(URL resource) {
        Trie.Builder builder = new Trie.Builder();
        try (InputStream is = resource.openStream();){
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF-8")));
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).length() <= 0) continue;
                builder.addWord(line);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return builder.build();
    }

    public ImplementationDependencyRelocator(URL resource) {
        super(589824);
        this.prefixes = ImplementationDependencyRelocator.readPrefixes(resource);
    }

    public String map(String name) {
        String relocated;
        String value = name;
        String prefix = "";
        Matcher m = this.classPattern.matcher(name);
        if (m.matches()) {
            prefix = m.group(1) + "L";
            name = m.group(2);
        }
        if ((relocated = this.maybeRelocateResource(name)) == null) {
            return value;
        }
        return prefix.concat(relocated);
    }

    public String maybeRelocateResource(String resource) {
        if (this.prefixes.find((CharSequence)resource)) {
            return "org/gradle/internal/impldep/" + resource;
        }
        return null;
    }

    public boolean keepOriginalResource(String resource) {
        return resource == null || this.maybeRelocateResource(resource) == null || !this.mustBeRelocated(resource);
    }

    private final boolean mustBeRelocated(String resource) {
        for (String mustRelocate : this.mustRelocateList) {
            if (!resource.startsWith(mustRelocate)) continue;
            return true;
        }
        return false;
    }

    public ClassLiteralRemapping maybeRemap(String literal) {
        if (literal.startsWith("class$")) {
            String className = literal.substring(6).replace('$', '.');
            String replacement = this.maybeRelocateResource(className.replace('.', '/'));
            if (replacement == null) {
                return null;
            }
            String fieldNameReplacement = "class$" + replacement.replace('/', '$');
            return new ClassLiteralRemapping(className, replacement, fieldNameReplacement);
        }
        return null;
    }

    public static class ClassLiteralRemapping {
        private final String literal;
        private final String literalReplacement;
        private final String fieldNameReplacement;

        public ClassLiteralRemapping(String literal, String literalReplacement, String fieldNameReplacement) {
            this.literal = literal;
            this.literalReplacement = literalReplacement;
            this.fieldNameReplacement = fieldNameReplacement;
        }

        public String getLiteral() {
            return this.literal;
        }

        public String getLiteralReplacement() {
            return this.literalReplacement;
        }

        public String getFieldNameReplacement() {
            return this.fieldNameReplacement;
        }
    }
}

