/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junitplatform;

import java.io.File;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.WillCloseWhenClosed;
import org.gradle.api.internal.tasks.testing.ClassTestDefinition;
import org.gradle.api.internal.tasks.testing.DirectoryBasedTestDefinition;
import org.gradle.api.internal.tasks.testing.RequiresTestFrameworkTestDefinitionProcessor;
import org.gradle.api.internal.tasks.testing.TestDefinition;
import org.gradle.api.internal.tasks.testing.TestDefinitionConsumer;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.filter.TestFilterSpec;
import org.gradle.api.internal.tasks.testing.filter.TestSelectionMatcher;
import org.gradle.api.internal.tasks.testing.junit.AbstractJUnitTestDefinitionProcessor;
import org.gradle.api.internal.tasks.testing.junit.JUnitTestExecutor;
import org.gradle.api.internal.tasks.testing.junitplatform.JUnitPlatformSpec;
import org.gradle.api.internal.tasks.testing.junitplatform.JUnitPlatformTestExecutionListener;
import org.gradle.api.internal.tasks.testing.junitplatform.filters.ClassMethodNameFilter;
import org.gradle.api.internal.tasks.testing.junitplatform.filters.DelegatingByTypeFilter;
import org.gradle.api.internal.tasks.testing.junitplatform.filters.FilePathFilter;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.actor.Actor;
import org.gradle.internal.actor.ActorFactory;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.time.Clock;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.descriptor.DirectorySource;
import org.junit.platform.engine.support.descriptor.FileSource;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.EngineFilter;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.LauncherSession;
import org.junit.platform.launcher.TagFilter;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;

@NullMarked
public final class JUnitPlatformTestDefinitionProcessor
extends AbstractJUnitTestDefinitionProcessor<TestDefinition> {
    private final JUnitPlatformSpec spec;
    private final IdGenerator<?> idGenerator;
    private final Clock clock;
    private @Nullable CollectThenExecuteTestDefinitionConsumer testClassExecutor;
    private @Nullable BackwardsCompatibleLauncherSession launcherSession;
    private @Nullable ClassLoader junitClassLoader;

    public JUnitPlatformTestDefinitionProcessor(JUnitPlatformSpec spec, IdGenerator<?> idGenerator, ActorFactory actorFactory, Clock clock) {
        super(actorFactory);
        this.spec = spec;
        this.idGenerator = idGenerator;
        this.clock = clock;
    }

    public void assertTestFrameworkAvailable() {
        try {
            Class.forName("org.junit.platform.launcher.core.LauncherFactory");
        }
        catch (ClassNotFoundException e) {
            throw new RequiresTestFrameworkTestDefinitionProcessor.TestFrameworkNotAvailableException("Failed to load JUnit Platform.  Please ensure that all JUnit Platform dependencies are available on the test's runtime classpath, including the JUnit Platform launcher.");
        }
    }

    @Override
    protected TestDefinitionConsumer<TestDefinition> createTestExecutor(Actor resultProcessorActor) {
        TestResultProcessor threadSafeResultProcessor = (TestResultProcessor)resultProcessorActor.getProxy(TestResultProcessor.class);
        this.launcherSession = BackwardsCompatibleLauncherSession.open();
        ClassLoader junitClassLoader = Thread.currentThread().getContextClassLoader();
        this.testClassExecutor = new CollectThenExecuteTestDefinitionConsumer(threadSafeResultProcessor, this.launcherSession, junitClassLoader, this.spec, this.idGenerator, this.clock);
        return this.testClassExecutor;
    }

    @Override
    public void stop() {
        if (this.startedProcessing) {
            Objects.requireNonNull(this.testClassExecutor).processAllTestDefinitions();
            Objects.requireNonNull(this.launcherSession).close();
            super.stop();
        }
    }

    private static final class BackwardsCompatibleLauncherSession
    implements AutoCloseable {
        private final Launcher launcher;
        private final Runnable onClose;

        static BackwardsCompatibleLauncherSession open() {
            try {
                LauncherSession launcherSession = LauncherFactory.openSession();
                return new BackwardsCompatibleLauncherSession(launcherSession);
            }
            catch (NoSuchMethodError ignore) {
                return new BackwardsCompatibleLauncherSession(LauncherFactory.create(), () -> {});
            }
        }

        BackwardsCompatibleLauncherSession(@WillCloseWhenClosed LauncherSession session) {
            this(session.getLauncher(), () -> ((LauncherSession)session).close());
        }

        BackwardsCompatibleLauncherSession(Launcher launcher, Runnable onClose) {
            this.launcher = launcher;
            this.onClose = onClose;
        }

        Launcher getLauncher() {
            return this.launcher;
        }

        @Override
        public void close() {
            this.onClose.run();
        }
    }

    private static final class CollectThenExecuteTestDefinitionConsumer
    implements TestDefinitionConsumer<TestDefinition> {
        private final List<DiscoverySelector> selectors = new ArrayList<DiscoverySelector>();
        private final TestResultProcessor resultProcessor;
        private final BackwardsCompatibleLauncherSession launcherSession;
        private final ClassLoader junitClassLoader;
        private final JUnitPlatformSpec spec;
        private final IdGenerator<?> idGenerator;
        private final Clock clock;

        CollectThenExecuteTestDefinitionConsumer(TestResultProcessor resultProcessor, BackwardsCompatibleLauncherSession launcherSession, ClassLoader junitClassLoader, JUnitPlatformSpec spec, IdGenerator<?> idGenerator, Clock clock) {
            this.resultProcessor = resultProcessor;
            this.launcherSession = launcherSession;
            this.junitClassLoader = junitClassLoader;
            this.spec = spec;
            this.idGenerator = idGenerator;
            this.clock = clock;
        }

        @Override
        public void accept(TestDefinition testDefinition) {
            if (testDefinition instanceof ClassTestDefinition) {
                this.executeClass((ClassTestDefinition)testDefinition);
            } else if (testDefinition instanceof DirectoryBasedTestDefinition) {
                this.executeDirectory((DirectoryBasedTestDefinition)testDefinition);
            } else {
                throw new IllegalStateException("Unexpected test definition type " + testDefinition.getClass().getName());
            }
        }

        private void executeClass(ClassTestDefinition testDefinition) {
            Class<?> klass = this.loadClass(testDefinition.getTestClassName());
            if (this.isInnerClass(klass) || this.supportsVintageTests() && JUnitTestExecutor.isNestedClassInsideEnclosedRunner(klass)) {
                return;
            }
            this.selectors.add((DiscoverySelector)DiscoverySelectors.selectClass(klass));
        }

        private void executeDirectory(DirectoryBasedTestDefinition testDefinition) {
            this.selectors.add((DiscoverySelector)DiscoverySelectors.selectDirectory((File)testDefinition.getTestDefinitionsDir()));
        }

        private void processAllTestDefinitions() {
            LauncherDiscoveryRequest discoveryRequest = this.createLauncherDiscoveryRequest();
            JUnitPlatformTestExecutionListener executionListener = new JUnitPlatformTestExecutionListener(this.resultProcessor, this.clock, this.idGenerator, this.spec.getBaseDefinitionsDir());
            Launcher launcher = Objects.requireNonNull(this.launcherSession).getLauncher();
            if (this.spec.isDryRun()) {
                TestPlan testPlan = launcher.discover(discoveryRequest);
                this.executeDryRun(testPlan, executionListener);
            } else {
                launcher.execute(discoveryRequest, new TestExecutionListener[]{executionListener});
            }
            executionListener.throwAnyFatalExceptions();
        }

        private Class<?> loadClass(String className) {
            try {
                return Class.forName(className, false, this.junitClassLoader);
            }
            catch (ClassNotFoundException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }

        private boolean isInnerClass(Class<?> klass) {
            return klass.getEnclosingClass() != null && !Modifier.isStatic(klass.getModifiers());
        }

        private boolean supportsVintageTests() {
            try {
                Class.forName("org.junit.vintage.engine.VintageTestEngine", false, this.junitClassLoader);
                Class.forName("org.junit.runner.Request", false, this.junitClassLoader);
                return true;
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }

        private LauncherDiscoveryRequest createLauncherDiscoveryRequest() {
            LauncherDiscoveryRequestBuilder requestBuilder = LauncherDiscoveryRequestBuilder.request().selectors(this.selectors);
            this.addTestNameFilters(requestBuilder);
            this.addEnginesFilter(requestBuilder);
            this.addTagsFilter(requestBuilder);
            return requestBuilder.build();
        }

        private void addTestNameFilters(LauncherDiscoveryRequestBuilder requestBuilder) {
            TestFilterSpec filterSpec = this.spec.getFilter();
            if (this.isNotEmpty(filterSpec)) {
                TestSelectionMatcher matcher = new TestSelectionMatcher(filterSpec);
                DelegatingByTypeFilter delegatingFilter = new DelegatingByTypeFilter();
                if (matcher.hasClassBasedFilters()) {
                    ClassMethodNameFilter classFilter = new ClassMethodNameFilter(matcher);
                    delegatingFilter.addDelegate(ClassSource.class, classFilter);
                    delegatingFilter.addDelegate(MethodSource.class, classFilter);
                }
                if (matcher.hasPathBasedFilters()) {
                    FilePathFilter fileFilter = new FilePathFilter(matcher, this.spec.getBaseDefinitionsDir());
                    delegatingFilter.addDelegate(FileSource.class, fileFilter);
                    delegatingFilter.addDelegate(DirectorySource.class, fileFilter);
                }
                requestBuilder.filters(new Filter[]{delegatingFilter});
            }
        }

        private void addEnginesFilter(LauncherDiscoveryRequestBuilder requestBuilder) {
            List<String> excludeEngines;
            List<String> includeEngines = this.spec.getIncludeEngines();
            if (!includeEngines.isEmpty()) {
                requestBuilder.filters(new Filter[]{EngineFilter.includeEngines(includeEngines)});
            }
            if (!(excludeEngines = this.spec.getExcludeEngines()).isEmpty()) {
                requestBuilder.filters(new Filter[]{EngineFilter.excludeEngines(excludeEngines)});
            }
        }

        private void addTagsFilter(LauncherDiscoveryRequestBuilder requestBuilder) {
            List<String> excludeTags;
            List<String> includeTags = this.spec.getIncludeTags();
            if (!includeTags.isEmpty()) {
                requestBuilder.filters(new Filter[]{TagFilter.includeTags(includeTags)});
            }
            if (!(excludeTags = this.spec.getExcludeTags()).isEmpty()) {
                requestBuilder.filters(new Filter[]{TagFilter.excludeTags(excludeTags)});
            }
        }

        private void executeDryRun(TestPlan testPlan, TestExecutionListener listener) {
            listener.testPlanExecutionStarted(testPlan);
            for (TestIdentifier root : testPlan.getRoots()) {
                this.dryRun(root, testPlan, listener);
            }
            listener.testPlanExecutionFinished(testPlan);
        }

        private void dryRun(TestIdentifier testIdentifier, TestPlan testPlan, TestExecutionListener listener) {
            if (testIdentifier.isTest()) {
                listener.executionSkipped(testIdentifier, "Gradle test execution dry run");
            } else {
                listener.executionStarted(testIdentifier);
                for (TestIdentifier child : testPlan.getChildren(testIdentifier)) {
                    this.dryRun(child, testPlan, listener);
                }
                listener.executionFinished(testIdentifier, TestExecutionResult.successful());
            }
        }

        private boolean isNotEmpty(TestFilterSpec filter) {
            return !filter.getIncludedTests().isEmpty() || !filter.getIncludedTestsCommandLine().isEmpty() || !filter.getExcludedTests().isEmpty();
        }
    }
}

