/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.gradle.buildinit.plugins.internal.BuildContentGenerationContext;
import org.gradle.buildinit.plugins.internal.BuildContentGenerator;
import org.gradle.buildinit.plugins.internal.InitSettings;
import org.gradle.internal.UncheckedException;

public class GitAttributesGenerator
implements BuildContentGenerator {
    @Override
    public void generate(InitSettings settings, BuildContentGenerationContext buildContentGenerationContext) {
        File file = settings.getTarget().file(".gitattributes").getAsFile();
        try (PrintWriter writer = new PrintWriter(Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]));){
            writer.println("#");
            writer.println("# https://help.github.com/articles/dealing-with-line-endings/");
            writer.println("#");
            writer.println("# Linux start script should use lf");
            writer.println("/gradlew        text eol=lf");
            writer.println();
            writer.println("# These are Windows script files and should use crlf");
            writer.println("*.bat           text eol=crlf");
            writer.println();
            writer.println("# Binary files should be left untouched");
            writer.println("*.jar           binary");
            writer.println();
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }
}

