/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing;

import org.gradle.api.internal.tasks.testing.DefaultTestFailure;
import org.gradle.api.internal.tasks.testing.TestCompleteEvent;
import org.gradle.api.internal.tasks.testing.TestDefinition;
import org.gradle.api.internal.tasks.testing.TestDefinitionProcessor;
import org.gradle.api.internal.tasks.testing.TestDescriptorInternal;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.TestStartEvent;
import org.gradle.api.internal.tasks.testing.TestSuiteExecutionException;
import org.gradle.api.internal.tasks.testing.processors.CaptureTestOutputTestResultProcessor;
import org.gradle.api.internal.tasks.testing.redirector.JULRedirector;
import org.gradle.api.internal.tasks.testing.results.AttachParentTestResultProcessor;
import org.gradle.api.tasks.testing.TestFailure;
import org.gradle.internal.time.Clock;

public class SuiteTestDefinitionProcessor<D extends TestDefinition>
implements TestDefinitionProcessor<D> {
    private final TestDefinitionProcessor<D> processor;
    private final Clock clock;
    private final TestDescriptorInternal suiteDescriptor;
    private TestResultProcessor resultProcessor;

    public SuiteTestDefinitionProcessor(TestDescriptorInternal suiteDescriptor, TestDefinitionProcessor<D> processor, Clock clock) {
        this.suiteDescriptor = suiteDescriptor;
        this.processor = processor;
        this.clock = clock;
    }

    @Override
    public void startProcessing(TestResultProcessor testResultProcessor) {
        try {
            this.resultProcessor = new AttachParentTestResultProcessor(new CaptureTestOutputTestResultProcessor(this.clock, testResultProcessor, new JULRedirector()));
            this.resultProcessor.started(this.suiteDescriptor, new TestStartEvent(this.clock.getCurrentTime()));
            this.processor.startProcessing(this.resultProcessor);
        }
        catch (Throwable t) {
            TestSuiteExecutionException rawFailure = new TestSuiteExecutionException("Could not start " + this.suiteDescriptor + ".", t);
            this.resultProcessor.failure(this.suiteDescriptor.getId(), DefaultTestFailure.fromTestFrameworkStartupFailure((Throwable)((Object)rawFailure)));
        }
    }

    @Override
    public void processTestDefinition(D testDefinition) {
        try {
            this.processor.processTestDefinition(testDefinition);
        }
        catch (Throwable t) {
            TestSuiteExecutionException rawFailure = new TestSuiteExecutionException("Could not execute " + testDefinition.getDisplayName() + ".", t);
            this.resultProcessor.failure(this.suiteDescriptor.getId(), TestFailure.fromTestFrameworkFailure((Throwable)((Object)rawFailure)));
        }
    }

    @Override
    public void stop() {
        try {
            this.processor.stop();
        }
        catch (Throwable t) {
            TestSuiteExecutionException rawFailure = new TestSuiteExecutionException("Could not complete execution for " + this.suiteDescriptor + ".", t);
            this.resultProcessor.failure(this.suiteDescriptor.getId(), TestFailure.fromTestFrameworkFailure((Throwable)((Object)rawFailure)));
        }
        finally {
            this.resultProcessor.completed(this.suiteDescriptor.getId(), new TestCompleteEvent(this.clock.getCurrentTime()));
        }
    }

    @Override
    public void stopNow() {
        throw new UnsupportedOperationException("stopNow() should not be invoked on remote worker TestDefinitionProcessor");
    }
}

